/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderPdf;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class PurchaseOrderQuoteRequestsPdf
extends PdfPageEventHelper {
    private static Logger LOG = Logger.getLogger(PurchaseOrderQuoteRequestsPdf.class);
    public PdfTemplate tpl;
    public PdfContentByte cb;
    public PdfPTable headerTable;
    public PurchaseOrderDocument po;
    public BaseFont helv;
    Font titleFont = FontFactory.getFont((String)"ARIAL", (float)14.0f, (int)0);
    Font cellTitleFont = FontFactory.getFont((String)"ARIAL", (float)8.0f, (int)0);
    Font cellTextFont = FontFactory.getFont((String)"ARIAL", (float)12.0f, (int)0);

    public void onOpenDocument(PdfWriter writer, Document document) {
        LOG.debug((Object)"onOpenDocument() started.");
        try {
            this.tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        LOG.debug((Object)"onEndPage() started.");
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        String text = "Page " + writer.getPageNumber() + " of ";
        float textSize = this.helv.getWidthPoint(text, 12.0f);
        float textBase = document.bottom() - 20.0f;
        cb.beginText();
        cb.setFontAndSize(this.helv, 12.0f);
        float adjust = this.helv.getWidthPoint("0", 12.0f);
        cb.setTextMatrix(document.right() - textSize - adjust, textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.tpl, document.right() - adjust, textBase);
        cb.saveState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        LOG.debug((Object)"onCloseDocument() started.");
        this.tpl.beginText();
        this.tpl.setFontAndSize(this.helv, 12.0f);
        this.tpl.setTextMatrix(0.0f, 0.0f);
        this.tpl.showText("" + (writer.getPageNumber() - 1));
        this.tpl.endText();
    }

    public PurchaseOrderPdf getPageEvents() {
        LOG.debug((Object)"getPageEvents() started.");
        return new PurchaseOrderPdf();
    }

    private Document getDocument() throws DocumentException {
        LOG.debug((Object)"getDocument() started");
        Document document = new Document(PageSize.A4);
        document.setMargins(9.0f, 9.0f, 25.0f, 36.0f);
        return document;
    }

    public Collection generatePOQuoteRequestsListPdf(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream, String institutionName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("generatePOQuoteRequestsListPDF() started for po number " + po.getPurapDocumentIdentifier()));
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            Document doc = this.getDocument();
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)byteArrayOutputStream);
            this.createPOQuoteRequestsListPdf(po, doc, writer, institutionName);
        }
        catch (DocumentException de) {
            LOG.error((Object)de.getMessage(), (Throwable)de);
            errors.add(de.getMessage());
        }
        return errors;
    }

    public Collection savePOQuoteRequestsListPdf(PurchaseOrderDocument po, String pdfFileLocation, String pdfFilename, String institutionName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("savePOQuoteRequestsListPDF() started for po number " + po.getPurapDocumentIdentifier()));
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            Document doc = this.getDocument();
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(pdfFileLocation + pdfFilename));
            this.createPOQuoteRequestsListPdf(po, doc, writer, institutionName);
        }
        catch (DocumentException de) {
            LOG.error((Object)de.getMessage(), (Throwable)de);
            errors.add(de.getMessage());
        }
        catch (FileNotFoundException f) {
            LOG.error((Object)f.getMessage(), (Throwable)f);
            errors.add(f.getMessage());
        }
        return errors;
    }

    public void deletePdf(String pdfFileLocation, String pdfFilename) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deletePdf() started for po pdf file: " + pdfFilename));
        }
        File f = new File(pdfFileLocation + pdfFilename);
        f.delete();
    }

    private void createPOQuoteRequestsListPdf(PurchaseOrderDocument po, Document document, PdfWriter writer, String instName) throws DocumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createPOQuoteRequestsListPdf() started for po number " + po.getPurapDocumentIdentifier()));
        }
        this.po = po;
        PurchaseOrderPdf events = new PurchaseOrderPdf().getPageEvents();
        writer.setPageEvent((PdfPageEvent)this);
        document.open();
        Paragraph p = new Paragraph();
        float[] headerWidths = new float[]{0.25f, 0.25f, 0.25f, 0.25f};
        this.headerTable = new PdfPTable(headerWidths);
        this.headerTable.setWidthPercentage(100.0f);
        this.headerTable.setHorizontalAlignment(1);
        this.headerTable.getDefaultCell().setBorderWidth(0.0f);
        this.headerTable.getDefaultCell().setHorizontalAlignment(1);
        this.headerTable.getDefaultCell().setVerticalAlignment(1);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(instName + "\nRequest for Quotation Vendor List\n\n", this.titleFont));
        cell.setBorderWidth(0.0f);
        cell.setHorizontalAlignment(1);
        cell.setColspan(4);
        this.headerTable.addCell(cell);
        cell = new PdfPCell((Phrase)new Paragraph("PO Number: " + po.getPurapDocumentIdentifier(), this.cellTextFont));
        cell.setHorizontalAlignment(1);
        cell.setBorderWidth(0.0f);
        this.headerTable.addCell(cell);
        cell = new PdfPCell((Phrase)new Paragraph("Req. Number: " + po.getRequisitionIdentifier(), this.cellTextFont));
        cell.setHorizontalAlignment(1);
        cell.setBorderWidth(0.0f);
        this.headerTable.addCell(cell);
        SimpleDateFormat sdf = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.KUALI_SIMPLE_DATE_FORMAT_2);
        Date today = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        cell = new PdfPCell((Phrase)new Paragraph("Printed: " + sdf.format(today), this.cellTextFont));
        cell.setBorderWidth(0.0f);
        cell.setHorizontalAlignment(1);
        this.headerTable.addCell(cell);
        if (po.getPurchaseOrderQuoteDueDate() != null) {
            Date dueDate = po.getPurchaseOrderQuoteDueDate();
            cell = new PdfPCell((Phrase)new Paragraph("Due: " + sdf.format(dueDate) + "\n\n", this.cellTextFont));
        } else {
            cell = new PdfPCell((Phrase)new Paragraph("Due: N/A\n\n", this.cellTextFont));
        }
        cell.setBorderWidth(0.0f);
        cell.setHorizontalAlignment(1);
        this.headerTable.addCell(cell);
        document.add((Element)this.headerTable);
        LOG.debug((Object)"createPOQuoteRequestsListPdf() list table started.");
        float[] listWidths = new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.2f};
        PdfPTable listTable = new PdfPTable(listWidths);
        listTable.setWidthPercentage(100.0f);
        listTable.setHorizontalAlignment(1);
        cell = new PdfPCell((Phrase)new Paragraph("Vendor Name", this.cellTextFont));
        cell.setHorizontalAlignment(0);
        cell.setBorderWidth(0.0f);
        listTable.addCell(cell);
        cell = new PdfPCell((Phrase)new Paragraph("City", this.cellTextFont));
        cell.setHorizontalAlignment(0);
        cell.setBorderWidth(0.0f);
        listTable.addCell(cell);
        cell = new PdfPCell((Phrase)new Paragraph("Attention", this.cellTextFont));
        cell.setHorizontalAlignment(0);
        cell.setBorderWidth(0.0f);
        listTable.addCell(cell);
        cell = new PdfPCell((Phrase)new Paragraph("Fax #", this.cellTextFont));
        cell.setHorizontalAlignment(0);
        cell.setBorderWidth(0.0f);
        listTable.addCell(cell);
        cell = new PdfPCell((Phrase)new Paragraph("Received", this.cellTextFont));
        cell.setHorizontalAlignment(0);
        cell.setBorderWidth(0.0f);
        listTable.addCell(cell);
        cell = new PdfPCell((Phrase)new Paragraph(" ", this.cellTitleFont));
        cell.setFixedHeight(1.0f);
        cell.setColspan(5);
        listTable.addCell(cell);
        for (PurchaseOrderVendorQuote poqv : po.getPurchaseOrderVendorQuotes()) {
            cell = new PdfPCell((Phrase)new Paragraph(poqv.getVendorName(), this.cellTextFont));
            cell.setHorizontalAlignment(0);
            cell.setBorderWidth(0.0f);
            listTable.addCell(cell);
            cell = poqv.getVendorStateCode() != null ? new PdfPCell((Phrase)new Paragraph(poqv.getVendorCityName() + ", " + poqv.getVendorStateCode(), this.cellTextFont)) : (poqv.getVendorCountryCode() != null ? new PdfPCell((Phrase)new Paragraph(poqv.getVendorCityName() + ", " + poqv.getVendorCountryCode(), this.cellTextFont)) : new PdfPCell((Phrase)new Paragraph(poqv.getVendorCityName(), this.cellTextFont)));
            cell.setHorizontalAlignment(0);
            cell.setBorderWidth(0.0f);
            listTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(poqv.getVendorAttentionName(), this.cellTextFont));
            cell.setHorizontalAlignment(0);
            cell.setBorderWidth(0.0f);
            listTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(poqv.getVendorFaxNumber(), this.cellTextFont));
            cell.setHorizontalAlignment(0);
            cell.setBorderWidth(0.0f);
            listTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph("__________", this.cellTextFont));
            cell.setHorizontalAlignment(0);
            cell.setBorderWidth(0.0f);
            listTable.addCell(cell);
        }
        document.add((Element)listTable);
        document.close();
        LOG.debug((Object)"createPOQuoteRequestsListPdf()pdf document closed.");
    }
}

