/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashMap;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.document.PurchasingDocumentBase;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurapRequisitionRoomBuildingInActiveValidation
extends GenericValidation {
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean isActive = true;
        PurchasingDocumentBase req = (PurchasingDocumentBase)event.getDocument();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.clearErrorPath();
        HashMap<String, String> primarykeys = new HashMap<String, String>();
        primarykeys.put("campusCode", req.getDeliveryCampusCode());
        primarykeys.put("buildingCode", req.getDeliveryBuildingCode());
        Building building = (Building)this.businessObjectService.findByPrimaryKey(Building.class, primarykeys);
        if (building != null && !building.isActive()) {
            errorMap.putError("document.deliveryBuildingName", "error.inactive.building", new String[0]);
            isActive &= building.isActive();
        }
        primarykeys.put("buildingRoomNumber", req.getDeliveryBuildingRoomNumber());
        Room room = (Room)this.businessObjectService.findByPrimaryKey(Room.class, primarykeys);
        if (room != null && !room.isActive()) {
            errorMap.putError("document.deliveryBuildingRoomNumber", "error.inactive.room", new String[0]);
            isActive &= room.isActive();
        }
        return isActive;
    }

    public void setbusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

