/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizerBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class ElectronicInvoiceRejectDocumentAuthorizer
extends TransactionalDocumentAuthorizerBase {
    protected void addRoleQualification(Object businessObject, Map<String, String> attributes) {
        super.addRoleQualification(businessObject, attributes);
        attributes.put("documentSensitive", "false");
        ElectronicInvoiceRejectDocument purapDoc = (ElectronicInvoiceRejectDocument)((Object)businessObject);
        if (purapDoc.getAccountsPayablePurchasingDocumentLinkIdentifier() != null) {
            List<SensitiveData> sensitiveDataList = ((SensitiveDataService)SpringContext.getBean(SensitiveDataService.class)).getSensitiveDatasAssignedByRelatedDocId(purapDoc.getAccountsPayablePurchasingDocumentLinkIdentifier());
            StringBuffer sensitiveDataCodes = new StringBuffer();
            for (SensitiveData sensitiveData : sensitiveDataList) {
                sensitiveDataCodes.append(sensitiveData.getSensitiveDataCode()).append(";");
            }
            if (sensitiveDataCodes.length() > 0) {
                attributes.put("documentSensitive", "true");
                attributes.put("sensitiveDataCode", sensitiveDataCodes.toString().substring(0, sensitiveDataCodes.length() - 1));
                attributes.put("accountsPayablePurchasingDocumentLinkIdentifier", purapDoc.getAccountsPayablePurchasingDocumentLinkIdentifier().toString());
            }
        }
    }

    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.isAuthorizedByTemplate((BusinessObject)document, "KR-NS", "Edit Document", user.getPrincipalId());
    }
}

