/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.batch.service.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.purap.batch.service.AutoClosePurchaseOrderService;
import org.kuali.kfs.module.purap.businessobject.AutoClosePurchaseOrderView;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@NonTransactional
public class AutoClosePurchaseOrderServiceImpl
implements AutoClosePurchaseOrderService {
    private static Logger LOG = Logger.getLogger(AutoClosePurchaseOrderServiceImpl.class);
    protected PurchaseOrderService purchaseOrderService;

    @Override
    @NonTransactional
    public boolean autoCloseFullyDisencumberedOrders() {
        LOG.debug((Object)"autoCloseFullyDisencumberedOrders() started");
        List<AutoClosePurchaseOrderView> autoCloseList = this.getPurchaseOrderService().getAllOpenPurchaseOrdersForAutoClose();
        for (AutoClosePurchaseOrderView poAutoClose : autoCloseList) {
            this.autoClosePurchaseOrder(poAutoClose);
        }
        LOG.debug((Object)"autoCloseFullyDisencumberedOrders() ended");
        return true;
    }

    @Override
    @Transactional
    public void autoClosePurchaseOrder(AutoClosePurchaseOrderView poAutoClose) {
        if (poAutoClose.getTotalAmount() != null && KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)poAutoClose.getTotalAmount()) != 0) {
            LOG.info((Object)("autoCloseFullyDisencumberedOrders() PO ID " + poAutoClose.getPurapDocumentIdentifier() + " with total " + poAutoClose.getTotalAmount().doubleValue() + " will be closed"));
            String newStatus = "Pending Close";
            String annotation = "This PO was automatically closed in batch.";
            String documentType = "POC";
            PurchaseOrderDocument document = this.getPurchaseOrderService().getPurchaseOrderByDocumentNumber(poAutoClose.getDocumentNumber());
            this.getPurchaseOrderService().createNoteForAutoCloseOrders(document, annotation);
            this.getPurchaseOrderService().createAndRoutePotentialChangeDocument(poAutoClose.getDocumentNumber(), documentType, annotation, null, newStatus);
        }
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return this.purchaseOrderService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }
}

