/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountDelegate;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentBase;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.MailService;
import org.kuali.kfs.krad.service.MaintenanceDocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.batch.AutoCloseRecurringOrdersStep;
import org.kuali.kfs.module.purap.businessobject.AutoClosePurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.ContractManagerAssignmentDetail;
import org.kuali.kfs.module.purap.businessobject.CreditMemoView;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderCapitalAssetSystem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderQuoteStatus;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.ReceivingThreshold;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderSplitDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.dataaccess.PurchaseOrderDao;
import org.kuali.kfs.module.purap.document.service.B2BPurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.LogicContainer;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PrintService;
import org.kuali.kfs.module.purap.document.service.PurApWorkflowIntegrationService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.util.PurApObjectUtils;
import org.kuali.kfs.module.purap.util.ThresholdHelper;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.validation.event.AttributedRouteDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.DocumentSystemSaveEvent;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.CommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorCommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.businessobject.VendorPhoneNumber;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    private static final Logger LOG = Logger.getLogger(PurchaseOrderServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected NoteService noteService;
    protected PurapService purapService;
    protected PrintService printService;
    protected PurchaseOrderDao purchaseOrderDao;
    protected WorkflowDocumentService workflowDocumentService;
    protected ConfigurationService kualiConfigurationService;
    protected KualiRuleService kualiRuleService;
    protected VendorService vendorService;
    protected RequisitionService requisitionService;
    protected PurApWorkflowIntegrationService purapWorkflowIntegrationService;
    protected MaintenanceDocumentService maintenanceDocumentService;
    protected ParameterService parameterService;
    protected PersonService personService;
    protected MailService mailService;
    protected B2BPurchaseOrderService b2bPurchaseOrderService;
    protected DataDictionaryService dataDictionaryService;
    protected FinancialSystemDocumentService financialSystemDocumentService;

    @Override
    public boolean isPurchaseOrderOpenForProcessing(Integer poId) {
        return this.isPurchaseOrderOpenForProcessing(this.getCurrentPurchaseOrder(poId));
    }

    @Override
    public boolean isPurchaseOrderOpenForProcessing(PurchaseOrderDocument purchaseOrderDocument) {
        boolean can = "Open".equals(purchaseOrderDocument.getApplicationDocumentStatus());
        boolean bl = can = can && purchaseOrderDocument.isPurchaseOrderCurrentIndicator() && !purchaseOrderDocument.isPendingActionIndicator();
        if (can) {
            List<CreditMemoView> cmViews;
            List<PaymentRequestView> preqViews = purchaseOrderDocument.getRelatedViews().getRelatedPaymentRequestViews();
            if (preqViews != null) {
                for (PaymentRequestView preqView : preqViews) {
                    if (this.purapService.isPaymentRequestFullDocumentEntryCompleted(preqView.getApplicationDocumentStatus())) continue;
                    return false;
                }
            }
            if ((cmViews = purchaseOrderDocument.getRelatedViews().getRelatedCreditMemoViews()) != null) {
                for (CreditMemoView cmView : cmViews) {
                    if (this.purapService.isVendorCreditMemoFullDocumentEntryCompleted(cmView.getApplicationDocumentStatus())) continue;
                    return false;
                }
            }
        }
        return can;
    }

    @Override
    public boolean isCommodityCodeRequiredOnPurchaseOrder() {
        boolean enableCommodityCode = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_COMMODITY_CODE_IND");
        if (!enableCommodityCode) {
            return false;
        }
        return this.parameterService.getParameterValueAsBoolean(PurchaseOrderDocument.class, "ITEMS_REQUIRE_COMMODITY_CODE_IND");
    }

    protected void saveDocumentNoValidationUsingClearMessageMap(PurchaseOrderDocument document) {
        MessageMap errorHolder = GlobalVariables.getMessageMap();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        try {
            this.purapService.saveDocumentNoValidation((Document)document);
        }
        finally {
            GlobalVariables.setMessageMap((MessageMap)errorHolder);
        }
    }

    protected void saveDocumentStandardSave(PurchaseOrderDocument document) {
        try {
            this.documentService.saveDocument((Document)document);
        }
        catch (WorkflowException we) {
            String errorMsg = "Workflow Error saving document # " + document.getDocumentHeader().getDocumentNumber() + " " + we.getMessage();
            LOG.error((Object)errorMsg, (Throwable)we);
            throw new RuntimeException(errorMsg, we);
        }
    }

    @Override
    public PurchasingCapitalAssetItem createCamsItem(PurchasingDocument purDoc, PurApItem purapItem) {
        PurchaseOrderCapitalAssetItem camsItem = new PurchaseOrderCapitalAssetItem();
        camsItem.setItemIdentifier(purapItem.getItemIdentifier());
        if (purDoc.getCapitalAssetSystemTypeCode().equals("IND")) {
            PurchaseOrderCapitalAssetSystem resultSystem = new PurchaseOrderCapitalAssetSystem();
            camsItem.setPurchasingCapitalAssetSystem(resultSystem);
        }
        camsItem.setPurchasingDocument(purDoc);
        return camsItem;
    }

    @Override
    public CapitalAssetSystem createCapitalAssetSystem() {
        PurchaseOrderCapitalAssetSystem resultSystem = new PurchaseOrderCapitalAssetSystem();
        return resultSystem;
    }

    @Override
    public void createAutomaticPurchaseOrderDocument(RequisitionDocument reqDocument) {
        String newSessionUserId = "kfs";
        try {
            LogicContainer logicToRun = new LogicContainer(){

                @Override
                public Object runLogic(Object[] objects) throws Exception {
                    RequisitionDocument doc = (RequisitionDocument)objects[0];
                    doc.setPurchaseOrderAutomaticIndicator(Boolean.TRUE);
                    PurchaseOrderDocument po = PurchaseOrderServiceImpl.this.generatePurchaseOrderFromRequisition(doc);
                    po.setDefaultValuesForAPO();
                    PurchaseOrderServiceImpl.this.checkForPrintTransmission(po);
                    po.setContractManagerCode(PurapConstants.APO_CONTRACT_MANAGER);
                    PurchaseOrderServiceImpl.this.documentService.routeDocument((Document)po, null, null);
                    DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
                    documentAttributeIndexingQueue.indexDocument(po.getDocumentNumber());
                    return null;
                }
            };
            this.purapService.performLogicWithFakedUserSession(newSessionUserId, logicToRun, reqDocument);
        }
        catch (WorkflowException e) {
            String errorMsg = "Workflow Exception caught: " + e.getLocalizedMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void checkForPrintTransmission(PurchaseOrderDocument po) throws WorkflowException {
        if ("PRIN".equals(po.getPurchaseOrderRetransmissionMethodCode())) {
            po.updateAndSaveAppDocStatus("Pending Print");
        }
    }

    @Override
    public PurchaseOrderDocument createPurchaseOrderDocument(RequisitionDocument reqDocument, String newSessionUserId, Integer contractManagerCode) {
        try {
            LogicContainer logicToRun = new LogicContainer(){

                @Override
                public Object runLogic(Object[] objects) throws Exception {
                    RequisitionDocument doc = (RequisitionDocument)objects[0];
                    PurchaseOrderDocument po = PurchaseOrderServiceImpl.this.generatePurchaseOrderFromRequisition(doc);
                    Integer cmCode = (Integer)objects[1];
                    po.setContractManagerCode(cmCode);
                    PurchaseOrderServiceImpl.this.purapService.saveDocumentNoValidation((Document)po);
                    return po;
                }
            };
            return (PurchaseOrderDocument)this.purapService.performLogicWithFakedUserSession(newSessionUserId, logicToRun, reqDocument, contractManagerCode);
        }
        catch (WorkflowException e) {
            String errorMsg = "Workflow Exception caught: " + e.getLocalizedMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PurchaseOrderDocument generatePurchaseOrderFromRequisition(RequisitionDocument reqDocument) throws WorkflowException {
        PurchaseOrderDocument poDocument = null;
        poDocument = (PurchaseOrderDocument)this.documentService.getNewDocument("PO");
        poDocument.populatePurchaseOrderFromRequisition(reqDocument);
        poDocument.updateAndSaveAppDocStatus("In Process");
        poDocument.setPurchaseOrderCurrentIndicator(true);
        poDocument.setPendingActionIndicator(false);
        if ("B2B".equals(poDocument.getRequisitionSourceCode())) {
            String paramName = "DEFAULT_B2B_VENDOR_CHOICE";
            String paramValue = this.parameterService.getParameterValueAsString(PurchaseOrderDocument.class, paramName);
            poDocument.setPurchaseOrderVendorChoiceCode(paramValue);
        }
        if (ObjectUtils.isNotNull((Object)poDocument.getVendorContract())) {
            poDocument.setVendorPaymentTermsCode(poDocument.getVendorContract().getVendorPaymentTermsCode());
            poDocument.setVendorShippingPaymentTermsCode(poDocument.getVendorContract().getVendorShippingPaymentTermsCode());
            poDocument.setVendorShippingTitleCode(poDocument.getVendorContract().getVendorShippingTitleCode());
        } else {
            VendorDetail vendor = this.vendorService.getVendorDetail(poDocument.getVendorHeaderGeneratedIdentifier(), poDocument.getVendorDetailAssignedIdentifier());
            if (ObjectUtils.isNotNull((Object)vendor)) {
                poDocument.setVendorPaymentTermsCode(vendor.getVendorPaymentTermsCode());
                poDocument.setVendorShippingPaymentTermsCode(vendor.getVendorShippingPaymentTermsCode());
                poDocument.setVendorShippingTitleCode(vendor.getVendorShippingTitleCode());
            }
        }
        if (!"B2B".equals(poDocument.getRequisitionSourceCode())) {
            this.purapService.addBelowLineItems(poDocument);
        }
        poDocument.fixItemReferences();
        return poDocument;
    }

    @Override
    public KualiDecimal getInternalPurchasingDollarLimit(PurchaseOrderDocument document) {
        if (document.getVendorContract() != null && document.getContractManager() != null) {
            KualiDecimal contractDollarLimit = this.vendorService.getApoLimitFromContract(document.getVendorContract().getVendorContractGeneratedIdentifier(), document.getChartOfAccountsCode(), document.getOrganizationCode());
            if (document.getContractManager().getContractManagerDelegationDollarLimit() == null) {
                document.refreshReferenceObject("contractManager");
            }
            KualiDecimal contractManagerLimit = document.getContractManager().getContractManagerDelegationDollarLimit();
            if (contractDollarLimit != null && contractManagerLimit != null) {
                if (contractDollarLimit.compareTo((AbstractKualiDecimal)contractManagerLimit) > 0) {
                    return contractDollarLimit;
                }
                return contractManagerLimit;
            }
            if (contractDollarLimit != null) {
                return contractDollarLimit;
            }
            return contractManagerLimit;
        }
        if (document.getVendorContract() == null && document.getContractManager() != null) {
            if (document.getContractManager().getContractManagerDelegationDollarLimit() == null) {
                document.refreshReferenceObject("contractManager");
            }
            return document.getContractManager().getContractManagerDelegationDollarLimit();
        }
        if (document.getVendorContract() != null && document.getContractManager() == null) {
            return this.purapService.getApoLimit(document.getVendorContract().getVendorContractGeneratedIdentifier(), document.getChartOfAccountsCode(), document.getOrganizationCode());
        }
        String errorMsg = "No internal purchase order dollar limit found for purchase order '" + document.getPurapDocumentIdentifier() + "'.";
        LOG.warn((Object)errorMsg);
        return null;
    }

    protected void addStringErrorMessagesToMessageMap(String errorKey, Collection<String> errors) {
        if (ObjectUtils.isNotNull(errors)) {
            for (String error : errors) {
                LOG.error((Object)("Adding error message using error key '" + errorKey + "' with text '" + error + "'"));
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", errorKey, new String[]{error});
            }
        }
    }

    @Override
    public boolean printPurchaseOrderQuoteRequestsListPDF(String documentNumber, ByteArrayOutputStream baosPDF) {
        PurchaseOrderDocument po = this.getPurchaseOrderByDocumentNumber(documentNumber);
        String environment = this.kualiConfigurationService.getPropertyValueAsString("environment");
        Collection generatePDFErrors = this.printService.generatePurchaseOrderQuoteRequestsListPdf(po, baosPDF);
        if (generatePDFErrors.size() > 0) {
            this.addStringErrorMessagesToMessageMap("error.purchaseOrder.pdf", generatePDFErrors);
            return false;
        }
        return true;
    }

    @Override
    public boolean printPurchaseOrderQuotePDF(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq, ByteArrayOutputStream baosPDF) {
        String environment = this.kualiConfigurationService.getPropertyValueAsString("environment");
        Collection generatePDFErrors = this.printService.generatePurchaseOrderQuotePdf(po, povq, baosPDF, environment);
        if (generatePDFErrors.size() > 0) {
            this.addStringErrorMessagesToMessageMap("error.purchaseOrder.pdf", generatePDFErrors);
            return false;
        }
        return true;
    }

    @Override
    public void performPurchaseOrderFirstTransmitViaPrinting(PurchaseOrderDocument po) {
        if (ObjectUtils.isNotNull((Object)po.getPurchaseOrderFirstTransmissionTimestamp())) {
            String errorMsg = "Method to perform first transmit was called on document (doc id " + po.getDocumentNumber() + ") with already filled in 'first transmit date'";
            LOG.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        Timestamp currentDate = this.dateTimeService.getCurrentTimestamp();
        po.setPurchaseOrderFirstTransmissionTimestamp(currentDate);
        po.setPurchaseOrderLastTransmitTimestamp(currentDate);
        po.setOverrideWorkflowButtons(Boolean.FALSE);
        boolean performedAction = this.purapWorkflowIntegrationService.takeAllActionsForGivenCriteria((Document)po, "Action taken automatically as part of document initial print transmission", "JoinVendorIsEmployeeOrNonResidentAlien", GlobalVariables.getUserSession().getPerson(), null);
        if (!performedAction) {
            Person systemUserPerson = this.getPersonService().getPersonByPrincipalName("kfs");
            this.purapWorkflowIntegrationService.takeAllActionsForGivenCriteria((Document)po, "Action taken automatically as part of document initial print transmission by user " + GlobalVariables.getUserSession().getPerson().getName(), "JoinVendorIsEmployeeOrNonResidentAlien", systemUserPerson, "kfs");
        }
        po.setOverrideWorkflowButtons(Boolean.TRUE);
        if (!po.getApplicationDocumentStatus().equals("Open")) {
            this.attemptSetupOfInitialOpenOfDocument(po);
            if (this.shouldAdhocFyi(po.getRequisitionSourceCode())) {
                this.sendAdhocFyi(po);
            }
        }
        this.purapService.saveDocumentNoValidation((Document)po);
    }

    private boolean shouldAdhocFyi(String reqSourceCode) {
        Collection excludeList = new ArrayList();
        if (this.parameterService.parameterExists(PurchaseOrderDocument.class, "NOTIFY_REQUISITION_SOURCES").booleanValue()) {
            excludeList = this.parameterService.getParameterValuesAsString(PurchaseOrderDocument.class, "NOTIFY_REQUISITION_SOURCES");
        }
        return !excludeList.contains(reqSourceCode);
    }

    @Override
    public void performPurchaseOrderPreviewPrinting(String documentNumber, ByteArrayOutputStream baosPDF) {
        this.performPrintPurchaseOrderPDFOnly(documentNumber, baosPDF);
    }

    @Override
    public void performPrintPurchaseOrderPDFOnly(String documentNumber, ByteArrayOutputStream baosPDF) {
        String environment;
        PurchaseOrderDocument po = this.getPurchaseOrderByDocumentNumber(documentNumber);
        Collection generatePDFErrors = this.printService.generatePurchaseOrderPdf(po, baosPDF, environment = this.kualiConfigurationService.getPropertyValueAsString("environment"), null);
        if (!generatePDFErrors.isEmpty()) {
            this.addStringErrorMessagesToMessageMap("error.purchaseOrder.pdf", generatePDFErrors);
            throw new ValidationException("printing purchase order for first transmission failed");
        }
    }

    @Override
    public void retransmitPurchaseOrderPDF(PurchaseOrderDocument po, ByteArrayOutputStream baosPDF) {
        String environment = this.kualiConfigurationService.getPropertyValueAsString("environment");
        List items = po.getItems();
        ArrayList<PurchaseOrderItem> retransmitItems = new ArrayList<PurchaseOrderItem>();
        for (PurchaseOrderItem item : items) {
            if (!item.isItemSelectedForRetransmitIndicator()) continue;
            retransmitItems.add(item);
        }
        Collection generatePDFErrors = this.printService.generatePurchaseOrderPdfForRetransmission(po, baosPDF, environment, retransmitItems);
        if (generatePDFErrors.size() > 0) {
            this.addStringErrorMessagesToMessageMap("error.purchaseOrder.pdf", generatePDFErrors);
            throw new ValidationException("found errors while trying to print po with doc id " + po.getDocumentNumber());
        }
        po.setPurchaseOrderLastTransmitTimestamp(this.dateTimeService.getCurrentTimestamp());
        this.purapService.saveDocumentNoValidation((Document)po);
    }

    protected PurchaseOrderDocument createPurchaseOrderDocumentFromSourceDocument(PurchaseOrderDocument sourceDocument, String docType) throws WorkflowException {
        if (ObjectUtils.isNull((Object)sourceDocument)) {
            String errorMsg = "Attempting to create new PO of type '" + docType + "' from source PO doc that is null";
            LOG.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        PurchaseOrderDocument newPurchaseOrderChangeDocument = (PurchaseOrderDocument)this.documentService.getNewDocument(docType);
        newPurchaseOrderChangeDocument.setAccountDistributionMethod(sourceDocument.getAccountDistributionMethod());
        HashSet<Class> classesToExclude = new HashSet<Class>();
        Class sourceObjectClass = FinancialSystemTransactionalDocumentBase.class;
        classesToExclude.add(sourceObjectClass);
        while (sourceObjectClass.getSuperclass() != null) {
            sourceObjectClass = sourceObjectClass.getSuperclass();
            classesToExclude.add(sourceObjectClass);
        }
        PurApObjectUtils.populateFromBaseWithSuper((BusinessObject)sourceDocument, (BusinessObject)newPurchaseOrderChangeDocument, PurapConstants.uncopyableFieldsForPurchaseOrder(), classesToExclude);
        newPurchaseOrderChangeDocument.getDocumentHeader().setDocumentDescription(sourceDocument.getDocumentHeader().getDocumentDescription());
        newPurchaseOrderChangeDocument.getDocumentHeader().setOrganizationDocumentNumber(sourceDocument.getDocumentHeader().getOrganizationDocumentNumber());
        newPurchaseOrderChangeDocument.getDocumentHeader().setExplanation(sourceDocument.getDocumentHeader().getExplanation());
        newPurchaseOrderChangeDocument.setPurchaseOrderCurrentIndicator(false);
        newPurchaseOrderChangeDocument.setPendingActionIndicator(false);
        for (PurApItem item : newPurchaseOrderChangeDocument.getItems()) {
            item.getSourceAccountingLines().iterator();
            SequenceAccessorService sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
            Integer itemIdentifier = sas.getNextAvailableSequenceNumber("PO_ITM_ID", PurApItem.class).intValue();
            item.setItemIdentifier(itemIdentifier);
        }
        this.updateCapitalAssetRelatedCollections(newPurchaseOrderChangeDocument);
        newPurchaseOrderChangeDocument.refreshNonUpdateableReferences();
        return newPurchaseOrderChangeDocument;
    }

    protected void updateCapitalAssetRelatedCollections(PurchaseOrderDocument newDocument) {
        for (PurchasingCapitalAssetItem capitalAssetItem : newDocument.getPurchasingCapitalAssetItems()) {
            Integer lineNumber = capitalAssetItem.getPurchasingItem().getItemLineNumber();
            PurApItem newItem = newDocument.getItemByLineNumber(lineNumber);
            capitalAssetItem.setItemIdentifier(newItem.getItemIdentifier());
            capitalAssetItem.setPurchasingDocument(newDocument);
            capitalAssetItem.setCapitalAssetSystemIdentifier(null);
            CapitalAssetSystem oldSystem = capitalAssetItem.getPurchasingCapitalAssetSystem();
            capitalAssetItem.setPurchasingCapitalAssetSystem(new PurchaseOrderCapitalAssetSystem(oldSystem));
        }
    }

    @Override
    public PurchaseOrderDocument createAndSavePotentialChangeDocument(String documentNumber, String docType, String currentDocumentStatusCode) {
        PurchaseOrderDocument currentDocument = this.getPurchaseOrderByDocumentNumber(documentNumber);
        try {
            PurchaseOrderDocument newDocument = this.createPurchaseOrderDocumentFromSourceDocument(currentDocument, docType);
            if (ObjectUtils.isNotNull((Object)newDocument)) {
                newDocument.updateAndSaveAppDocStatus("Change in Process");
                if (StringUtils.isNotBlank((String)currentDocumentStatusCode)) {
                    currentDocument.updateAndSaveAppDocStatus(currentDocumentStatusCode);
                }
                this.documentService.saveDocument((Document)newDocument, DocumentSystemSaveEvent.class);
                currentDocument.setPendingActionIndicator(true);
                this.savePurchaseOrderData(currentDocument);
                return newDocument;
            }
            String errorMsg = "Attempting to create new PO of type '" + docType + "' from source PO doc id " + documentNumber + " returned null for new document";
            LOG.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        catch (WorkflowException we) {
            String errorMsg = "Workflow Exception caught trying to create and save PO document of type '" + docType + "' using source document with doc id '" + documentNumber + "'";
            LOG.error((Object)errorMsg, (Throwable)we);
            throw new RuntimeException(errorMsg, we);
        }
    }

    @Override
    public PurchaseOrderDocument createAndRoutePotentialChangeDocument(String documentNumber, String docType, String annotation, List adhocRoutingRecipients, String currentDocumentStatusCode) {
        PurchaseOrderDocument currentDocument = this.getPurchaseOrderByDocumentNumber(documentNumber);
        try {
            currentDocument.updateAndSaveAppDocStatus(currentDocumentStatusCode);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Error saving routing data while saving document with id " + currentDocument.getDocumentNumber(), e);
        }
        try {
            PurchaseOrderDocument newDocument = this.createPurchaseOrderDocumentFromSourceDocument(currentDocument, docType);
            newDocument.updateAndSaveAppDocStatus("Change in Process");
            if (ObjectUtils.isNotNull((Object)newDocument)) {
                try {
                    currentDocument.setPendingActionIndicator(true);
                    this.documentService.routeDocument((Document)newDocument, annotation, adhocRoutingRecipients);
                }
                catch (ValidationException ve) {
                    currentDocument.setPendingActionIndicator(false);
                    this.savePurchaseOrderData(currentDocument);
                    throw ve;
                }
                return newDocument;
            }
            String errorMsg = "Attempting to create new PO of type '" + docType + "' from source PO doc id " + documentNumber + " returned null for new document";
            LOG.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        catch (WorkflowException we) {
            String errorMsg = "Workflow Exception caught trying to create and route PO document of type '" + docType + "' using source document with doc id '" + documentNumber + "'";
            LOG.error((Object)errorMsg, (Throwable)we);
            throw new RuntimeException(errorMsg, we);
        }
    }

    @Override
    public PurchaseOrderSplitDocument createAndSavePurchaseOrderSplitDocument(List<PurchaseOrderItem> newPOItems, PurchaseOrderDocument currentDocument, boolean copyNotes, String splitNoteText) {
        if (ObjectUtils.isNull((Object)currentDocument)) {
            String errorMsg = "Attempting to create new PO of type PurchaseOrderSplitDocument from source PO doc that is null";
            LOG.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        String documentNumber = currentDocument.getDocumentNumber();
        try {
            Person person = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(currentDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
            PurchaseOrderSplitDocument newDocument = (PurchaseOrderSplitDocument)this.documentService.getNewDocument("POSP", person.getPrincipalName());
            if (ObjectUtils.isNotNull((Object)newDocument)) {
                List notes;
                int noteLength;
                Set<Class> classesToExclude = this.getClassesToExcludeFromCopy();
                Map<String, Class> uncopyableFields = PurapConstants.UNCOPYABLE_FIELDS_FOR_PO;
                uncopyableFields.putAll(PurapConstants.uncopyableFieldsForSplitPurchaseOrder());
                PurApObjectUtils.populateFromBaseWithSuper((BusinessObject)currentDocument, (BusinessObject)newDocument, uncopyableFields, classesToExclude);
                newDocument.getDocumentHeader().setDocumentDescription(currentDocument.getDocumentHeader().getDocumentDescription());
                newDocument.getDocumentHeader().setOrganizationDocumentNumber(currentDocument.getDocumentHeader().getOrganizationDocumentNumber());
                newDocument.setPurchaseOrderCurrentIndicator(true);
                newDocument.setPendingActionIndicator(false);
                newDocument.setAccountDistributionMethod(currentDocument.getAccountDistributionMethod());
                newDocument.setItems(newPOItems);
                this.purapService.addBelowLineItems(newDocument);
                newDocument.renumberItems(0);
                newDocument.setPostingYear(currentDocument.getPostingYear());
                if (copyNotes && (noteLength = (notes = currentDocument.getNotes()).size()) > 0) {
                    notes.subList(noteLength - 1, noteLength).clear();
                    for (Note note : notes) {
                        try {
                            Note copyingNote = this.documentService.createNoteFromDocument((Document)newDocument, note.getNoteText());
                            newDocument.addNote(copyingNote);
                            this.noteService.saveNoteList(notes);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                newDocument.updateAndSaveAppDocStatus("In Process");
                this.fixItemReferences(newDocument);
                newDocument.clearCapitalAssetFields();
                this.purapService.saveDocumentNoValidation((Document)newDocument);
                splitNoteText = splitNoteText.substring(splitNoteText.indexOf(":") + 1);
                splitNoteText = "Note entered while being split from Purchase Order " + currentDocument.getPurapDocumentIdentifier() + " : " + splitNoteText;
                try {
                    Note splitNote = this.documentService.createNoteFromDocument((Document)newDocument, splitNoteText);
                    newDocument.addNote(splitNote);
                    this.noteService.save(splitNote);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return newDocument;
            }
            String errorMsg = "Attempting to create new PO of type 'PurchaseOrderSplitDocument' from source PO doc id " + documentNumber + " returned null for new document";
            LOG.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        catch (WorkflowException we) {
            String errorMsg = "Workflow Exception caught trying to create and save PO document of type PurchaseOrderSplitDocument using source document with doc id '" + documentNumber + "'";
            LOG.error((Object)errorMsg, (Throwable)we);
            throw new RuntimeException(errorMsg, we);
        }
    }

    protected Set<Class> getClassesToExcludeFromCopy() {
        HashSet<Class> classesToExclude = new HashSet<Class>();
        Class sourceObjectClass = DocumentBase.class;
        classesToExclude.add(sourceObjectClass);
        while (sourceObjectClass.getSuperclass() != null) {
            sourceObjectClass = sourceObjectClass.getSuperclass();
            classesToExclude.add(sourceObjectClass);
        }
        return classesToExclude;
    }

    protected String getCurrentRouteNodeName(WorkflowDocument wd) throws WorkflowException {
        String[] nodeNames = (String[])wd.getNodeNames().toArray();
        if (nodeNames == null || nodeNames.length == 0) {
            return null;
        }
        return nodeNames[0];
    }

    @Override
    public void completePurchaseOrder(PurchaseOrderDocument po) {
        LOG.debug((Object)"completePurchaseOrder() started");
        this.setCurrentAndPendingIndicatorsForApprovedPODocuments(po);
        this.setupDocumentForPendingFirstTransmission(po);
        if (!po.isReceivingDocumentRequiredIndicator()) {
            this.setReceivingRequiredIndicatorForPurchaseOrder(po);
        }
        this.updateVendorCommodityCode(po);
        if (!PurapConstants.PurchaseOrderStatuses.STATUSES_BY_TRANSMISSION_TYPE.values().contains(po.getApplicationDocumentStatus())) {
            this.attemptSetupOfInitialOpenOfDocument(po);
        } else if ("Pending cxml".equals(po.getApplicationDocumentStatus())) {
            this.completeB2BPurchaseOrder(po);
        } else if ("Pending Print".equals(po.getApplicationDocumentStatus())) {
            Set currentNodes;
            String userToRouteFyi = po.getDocumentHeader().getWorkflowDocument().getRoutedByPrincipalId();
            if (po.getPurchaseOrderAutomaticIndicator()) {
                RequisitionDocument req = this.requisitionService.getRequisitionById(po.getRequisitionIdentifier());
                userToRouteFyi = req.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
            }
            if (CollectionUtils.isNotEmpty((Collection)(currentNodes = po.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames()))) {
                po.getDocumentHeader().getWorkflowDocument().adHocToPrincipal(ActionRequestType.FYI, (String)currentNodes.iterator().next(), "This PO is ready for printing and distribution.", userToRouteFyi, "", true, "PRINT");
            }
        }
    }

    protected boolean completeB2BPurchaseOrder(PurchaseOrderDocument po) {
        String errors = this.b2bPurchaseOrderService.sendPurchaseOrder(po);
        if (StringUtils.isEmpty((String)errors)) {
            this.attemptSetupOfInitialOpenOfDocument(po);
            po.setPurchaseOrderLastTransmitTimestamp(this.dateTimeService.getCurrentTimestamp());
            return true;
        }
        try {
            String noteText = "Unable to transmit the PO for the following reasons:\n" + errors;
            int noteMaxSize = this.dataDictionaryService.getAttributeMaxLength("Note", "noteText");
            while (noteText.length() > noteMaxSize) {
                boolean fromIndex = false;
                String noteText1 = noteText.substring(0, noteMaxSize);
                Note note1 = this.documentService.createNoteFromDocument((Document)po, noteText1);
                po.addNote(note1);
                noteText = noteText.substring(noteMaxSize);
            }
            Note note = this.documentService.createNoteFromDocument((Document)po, noteText);
            po.addNote(note);
            this.documentService.saveDocumentNotes((Document)po);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            po.updateAndSaveAppDocStatus("Error occurred sending cxml");
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Error saving routing data while saving document with id " + po.getDocumentNumber(), e);
        }
        return false;
    }

    @Override
    public void retransmitB2BPurchaseOrder(PurchaseOrderDocument po) {
        if (this.completeB2BPurchaseOrder(po)) {
            KNSGlobalVariables.getMessageList().add("message.b2b.po.retransmit.success", new String[0]);
        } else {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "message.b2b.po.retransmit.failed", new String[0]);
        }
        this.purapService.saveDocumentNoValidation((Document)po);
    }

    @Override
    public void completePurchaseOrderAmendment(PurchaseOrderDocument poa) {
        LOG.debug((Object)"completePurchaseOrderAmendment() started");
        this.setCurrentAndPendingIndicatorsForApprovedPODocuments(poa);
        if (!poa.isReceivingDocumentRequiredIndicator() && !((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).hasActivePaymentRequestsForPurchaseOrder(poa.getPurapDocumentIdentifier())) {
            this.setReceivingRequiredIndicatorForPurchaseOrder(poa);
        }
        if (this.hasNewUnorderedItem(poa)) {
            this.sendFyiForNewUnorderedItems(poa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateVendorCommodityCode(PurchaseOrderDocument po) {
        String noteText = "";
        VendorDetail oldVendorDetail = po.getVendorDetail();
        VendorDetail newVendorDetail = this.updateVendorWithMissingCommodityCodesIfNecessary(po);
        Boolean shouldUpdate = this.parameterService.getParameterValueAsBoolean(RequisitionDocument.class, "AUTO_ADD_COMMODITY_CODES_TO_VENDOR_IND", Boolean.TRUE);
        if (shouldUpdate.booleanValue() && newVendorDetail != null) {
            try {
                org.kuali.kfs.kns.document.MaintenanceDocument vendorMaintDoc = null;
                try {
                    vendorMaintDoc = (org.kuali.kfs.kns.document.MaintenanceDocument)this.documentService.getNewDocument("PVEN");
                    vendorMaintDoc.getDocumentHeader().setDocumentDescription("Automatically spawned from PO");
                    vendorMaintDoc.getOldMaintainableObject().setBusinessObject((PersistableBusinessObject)oldVendorDetail);
                    vendorMaintDoc.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)newVendorDetail);
                    vendorMaintDoc.getNewMaintainableObject().setMaintenanceAction("Edit");
                    vendorMaintDoc.getNewMaintainableObject().setDocumentNumber(vendorMaintDoc.getDocumentNumber());
                    boolean isVendorLocked = this.checkForLockingDocument(vendorMaintDoc);
                    if (!isVendorLocked) {
                        vendorMaintDoc.validateBusinessRules((KualiDocumentEvent)new RouteDocumentEvent((Document)vendorMaintDoc));
                        this.addNoteForCommodityCodeToVendor(vendorMaintDoc.getNewMaintainableObject(), vendorMaintDoc.getDocumentNumber(), po.getPurapDocumentIdentifier());
                        this.documentService.routeDocument((Document)vendorMaintDoc, null, null);
                    } else {
                        noteText = "Unable to automatically update vendor because it is locked";
                    }
                }
                catch (Exception e) {
                    noteText = ObjectUtils.isNull(vendorMaintDoc) ? "Unable to create a new VendorDetailMaintenanceDocument to update the vendor with new commodity codes" : "Unable to route a new VendorDetailMaintenanceDocument to update the vendor with new commodity codes";
                }
                finally {
                    if (StringUtils.isNotBlank((String)noteText)) {
                        Note note = this.documentService.createNoteFromDocument((Document)po, noteText);
                        po.addNote(note);
                        this.noteService.save(note);
                        if (GlobalVariables.getMessageMap().hasErrors()) {
                            GlobalVariables.setMessageMap((MessageMap)new MessageMap());
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("updateVendorCommodityCode() unable to add a note(" + noteText + ") to PO document " + po.getDocumentNumber()));
            }
        }
    }

    protected void addNoteForCommodityCodeToVendor(Maintainable maintainable, String documentNumber, Integer poID) {
        Note newBONote = new Note();
        newBONote.setNoteText("Change vendor document ID <" + documentNumber + ">. Document was automatically created from PO <" + poID + "> to add commodity codes used on this PO that were not yet assigned to this vendor.");
        try {
            newBONote = this.noteService.createNote(newBONote, maintainable.getBusinessObject(), GlobalVariables.getUserSession().getPrincipalId());
            newBONote.setNotePostedTimestampToCurrent();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught Exception While Trying To Add Note to Vendor", e);
        }
        List noteList = this.noteService.getByRemoteObjectId(maintainable.getBusinessObject().getObjectId());
        noteList.add(newBONote);
        this.noteService.saveNoteList(noteList);
    }

    protected boolean checkForLockingDocument(org.kuali.kfs.kns.document.MaintenanceDocument document) {
        String blockingDocId = this.maintenanceDocumentService.getLockingDocumentId((MaintenanceDocument)document);
        return !StringUtils.isBlank((String)blockingDocId);
    }

    @Override
    public VendorDetail updateVendorWithMissingCommodityCodesIfNecessary(PurchaseOrderDocument po) {
        ArrayList<CommodityCode> result = new ArrayList<CommodityCode>();
        boolean foundDefault = false;
        VendorDetail vendor = (VendorDetail)ObjectUtils.deepCopy((Serializable)po.getVendorDetail());
        for (PurchaseOrderItem item : po.getItems()) {
            CommodityCode cc;
            if (!item.getItemType().isLineItemIndicator() || !item.isItemActiveIndicator() || (cc = item.getCommodityCode()) == null || result.contains(cc)) continue;
            List vendorCommodityCodes = po.getVendorDetail().getVendorCommodities();
            boolean foundMatching = false;
            for (VendorCommodityCode vcc : vendorCommodityCodes) {
                if (vcc.getCommodityCode().getPurchasingCommodityCode().equals(cc.getPurchasingCommodityCode())) {
                    foundMatching = true;
                }
                if (foundDefault || !vcc.isCommodityDefaultIndicator()) continue;
                foundDefault = true;
            }
            if (foundMatching) continue;
            result.add(cc);
            VendorCommodityCode vcc = new VendorCommodityCode(vendor.getVendorHeaderGeneratedIdentifier(), vendor.getVendorDetailAssignedIdentifier(), cc, true);
            vcc.setActive(true);
            if (!foundDefault) {
                vcc.setCommodityDefaultIndicator(true);
                foundDefault = true;
            }
            vendor.getVendorCommodities().add(vcc);
        }
        if (result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                po.getVendorDetail().getVendorCommodities().add(new VendorCommodityCode());
            }
            return vendor;
        }
        return null;
    }

    protected void setupDocumentForPendingFirstTransmission(PurchaseOrderDocument po) {
        if ("PRIN".equals(po.getPurchaseOrderTransmissionMethodCode()) || "FAX".equals(po.getPurchaseOrderTransmissionMethodCode()) || "ELEC".equals(po.getPurchaseOrderTransmissionMethodCode())) {
            String newStatusCode = PurapConstants.PurchaseOrderStatuses.STATUSES_BY_TRANSMISSION_TYPE.get(po.getPurchaseOrderTransmissionMethodCode());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("setupDocumentForPendingFirstTransmission() Purchase Order Transmission Type is '" + po.getPurchaseOrderTransmissionMethodCode() + "' setting status to '" + newStatusCode + "'"));
            }
            try {
                po.updateAndSaveAppDocStatus(newStatusCode);
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Error saving routing data while saving document with id " + po.getDocumentNumber(), e);
            }
        }
    }

    protected void attemptSetupOfInitialOpenOfDocument(PurchaseOrderDocument po) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("attemptSetupOfInitialOpenOfDocument() started using document with doc id " + po.getDocumentNumber()));
        }
        if (!"Open".equals(po.getApplicationDocumentStatus())) {
            if (!ObjectUtils.isNull((Object)po.getPurchaseOrderInitialOpenTimestamp())) {
                throw new RuntimeException("Document does not have status code 'Open' on it but value of initial open date is " + po.getPurchaseOrderInitialOpenTimestamp());
            }
            LOG.debug((Object)"attemptSetupOfInitialOpenOfDocument() setting initial open date on document");
            po.setPurchaseOrderInitialOpenTimestamp(this.dateTimeService.getCurrentTimestamp());
            LOG.info((Object)("attemptSetupOfInitialOpenOfDocument() Setting po document id " + po.getDocumentNumber() + " status from '" + po.getApplicationDocumentStatus() + "' to '" + "Open" + "'"));
            try {
                po.updateAndSaveAppDocStatus("Open");
            }
            catch (WorkflowException we) {
                throw new RuntimeException("Unable to load a WorkflowDocument object for " + po.getDocumentNumber(), we);
            }
        } else {
            LOG.error((Object)("attemptSetupOfInitialOpenOfDocument() Found document already in 'Open' status for PO#" + po.getPurapDocumentIdentifier() + "; will not change or update"));
        }
    }

    @Override
    public PurchaseOrderDocument getCurrentPurchaseOrder(Integer id) {
        return this.getPurchaseOrderByDocumentNumber(this.purchaseOrderDao.getDocumentNumberForCurrentPurchaseOrder(id));
    }

    @Override
    public PurchaseOrderDocument getPurchaseOrderByDocumentNumber(String documentNumber) {
        if (ObjectUtils.isNotNull((Object)documentNumber)) {
            try {
                PurchaseOrderDocument doc = (PurchaseOrderDocument)this.documentService.getByDocumentHeaderId(documentNumber);
                if (ObjectUtils.isNotNull((Object)doc)) {
                    WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
                    doc.refreshReferenceObject("documentHeader");
                    doc.getDocumentHeader().setWorkflowDocument(workflowDocument);
                }
                return doc;
            }
            catch (WorkflowException e) {
                String errorMessage = "Error getting purchase order document from document service";
                LOG.error((Object)("getPurchaseOrderByDocumentNumber() " + errorMessage), (Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public PurchaseOrderDocument getOldestPurchaseOrder(PurchaseOrderDocument po, PurchaseOrderDocument documentBusinessObject) {
        LOG.debug((Object)"entering getOldestPO(PurchaseOrderDocument)");
        if (ObjectUtils.isNotNull((Object)po)) {
            String oldestDocumentNumber = this.purchaseOrderDao.getOldestPurchaseOrderDocumentNumber(po.getPurapDocumentIdentifier());
            if (StringUtils.isBlank((String)oldestDocumentNumber)) {
                return null;
            }
            if (StringUtils.equals((String)oldestDocumentNumber, (String)po.getDocumentNumber())) {
                this.updateNotes(po, documentBusinessObject);
                LOG.debug((Object)"exiting getOldestPO(PurchaseOrderDocument)");
                return po;
            }
            PurchaseOrderDocument oldestPurchaseOrder = this.getPurchaseOrderByDocumentNumber(oldestDocumentNumber);
            this.updateNotes(oldestPurchaseOrder, documentBusinessObject);
            LOG.debug((Object)"exiting getOldestPO(PurchaseOrderDocument)");
            return oldestPurchaseOrder;
        }
        return null;
    }

    protected void updateNotes(PurchaseOrderDocument po, PurchaseOrderDocument documentBusinessObject) {
        if (ObjectUtils.isNotNull((Object)documentBusinessObject)) {
            if (ObjectUtils.isNotNull((Object)po.getObjectId())) {
                List dbNotes = this.noteService.getByRemoteObjectId(po.getObjectId());
                this.fixDbNoteFields(documentBusinessObject, dbNotes);
                po.setNotes(dbNotes);
            } else {
                po.setNotes(documentBusinessObject.getNotes());
            }
        }
    }

    protected void fixDbNoteFields(PurchaseOrderDocument documentBusinessObject, List<Note> dbNotes) {
        for (int i = 0; i < dbNotes.size(); ++i) {
            Note currentNote;
            AdHocRouteRecipient fyiNoteRecipient;
            Note dbNote = dbNotes.get(i);
            List currentNotes = documentBusinessObject.getNotes();
            if (i >= currentNotes.size() || !ObjectUtils.isNotNull((Object)(fyiNoteRecipient = (currentNote = (Note)currentNotes.get(i)).getAdHocRouteRecipient()))) continue;
            dbNote.setAdHocRouteRecipient(fyiNoteRecipient);
        }
    }

    @Override
    public List<Note> getPurchaseOrderNotes(Integer id) {
        List<Object> notes = new ArrayList<Note>();
        PurchaseOrderDocument po = this.getPurchaseOrderByDocumentNumber(this.purchaseOrderDao.getOldestPurchaseOrderDocumentNumber(id));
        if (ObjectUtils.isNotNull((Object)po)) {
            notes = this.noteService.getByRemoteObjectId(po.getDocumentHeader().getObjectId());
        }
        return notes;
    }

    @Override
    public void setCurrentAndPendingIndicatorsForApprovedPODocuments(PurchaseOrderDocument newPO) {
        PurchaseOrderDocument oldPO = this.getCurrentPurchaseOrder(newPO.getPurapDocumentIdentifier());
        if (!oldPO.getDocumentNumber().equals(newPO.getDocumentNumber())) {
            oldPO.setPurchaseOrderCurrentIndicator(false);
            oldPO.setPendingActionIndicator(false);
            try {
                oldPO.updateAndSaveAppDocStatus("Retired Version");
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Error saving routing data while saving document with id " + oldPO.getDocumentNumber(), e);
            }
            this.savePurchaseOrderData(oldPO);
        }
        newPO.setPurchaseOrderCurrentIndicator(true);
        newPO.setPendingActionIndicator(false);
    }

    @Override
    public void setCurrentAndPendingIndicatorsForDisapprovedChangePODocuments(PurchaseOrderDocument newPO) {
        this.updateCurrentDocumentForNoPendingAction(newPO, "Disapproved Change", "Open");
    }

    @Override
    public void setCurrentAndPendingIndicatorsForCancelledChangePODocuments(PurchaseOrderDocument newPO) {
        this.updateCurrentDocumentForNoPendingAction(newPO, "Cancelled Change", "Open");
    }

    @Override
    public void setCurrentAndPendingIndicatorsForCancelledReopenPODocuments(PurchaseOrderDocument newPO) {
        this.updateCurrentDocumentForNoPendingAction(newPO, "Cancelled Change", "Closed");
    }

    @Override
    public void setCurrentAndPendingIndicatorsForDisapprovedReopenPODocuments(PurchaseOrderDocument newPO) {
        this.updateCurrentDocumentForNoPendingAction(newPO, "Disapproved Change", "Closed");
    }

    @Override
    public void setCurrentAndPendingIndicatorsForCancelledRemoveHoldPODocuments(PurchaseOrderDocument newPO) {
        this.updateCurrentDocumentForNoPendingAction(newPO, "Cancelled Change", "Payment Hold");
    }

    @Override
    public void setCurrentAndPendingIndicatorsForDisapprovedRemoveHoldPODocuments(PurchaseOrderDocument newPO) {
        this.updateCurrentDocumentForNoPendingAction(newPO, "Disapproved Change", "Payment Hold");
    }

    protected void updateCurrentDocumentForNoPendingAction(PurchaseOrderDocument newPO, String newPOStatus, String oldPOStatus) {
        PurchaseOrderDocument oldPO = this.getCurrentPurchaseOrder(newPO.getPurapDocumentIdentifier());
        oldPO.setPendingActionIndicator(false);
        try {
            oldPO.updateAndSaveAppDocStatus(oldPOStatus);
            newPO.updateAndSaveAppDocStatus(newPOStatus);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Error saving routing data while saving document", e);
        }
        this.savePurchaseOrderData(oldPO);
        this.saveDocumentNoValidationUsingClearMessageMap(newPO);
    }

    @Override
    public List<PurchaseOrderQuoteStatus> getPurchaseOrderQuoteStatusCodes() {
        ArrayList<PurchaseOrderQuoteStatus> poQuoteStatuses = new ArrayList();
        poQuoteStatuses = (List)this.businessObjectService.findAll(PurchaseOrderQuoteStatus.class);
        return poQuoteStatuses;
    }

    @Override
    public void setReceivingRequiredIndicatorForPurchaseOrder(PurchaseOrderDocument po) {
        ThresholdHelper thresholdHelper = new ThresholdHelper(po);
        boolean result = thresholdHelper.isReceivingDocumentRequired();
        if (result) {
            ThresholdHelper.ThresholdSummary thresholdSummary = thresholdHelper.getThresholdSummary();
            ReceivingThreshold receivingThreshold = thresholdHelper.getReceivingThreshold();
            po.setReceivingDocumentRequiredIndicator(true);
            String notetxt = "Receiving is set to be required because the threshold summary with a total amount of " + thresholdSummary.getTotalAmount();
            notetxt = notetxt + " exceeds the receiving threshold of " + receivingThreshold.getThresholdAmount();
            notetxt = notetxt + " with respect to the threshold criteria ";
            if (thresholdSummary.getThresholdCriteria() == ThresholdHelper.CHART) {
                notetxt = notetxt + " Chart " + receivingThreshold.getChartOfAccountsCode();
            } else if (thresholdSummary.getThresholdCriteria() == ThresholdHelper.CHART_AND_ACCOUNTTYPE) {
                notetxt = notetxt + " Chart " + receivingThreshold.getChartOfAccountsCode();
                notetxt = notetxt + " - Account Type " + receivingThreshold.getAccountTypeCode();
            } else if (thresholdSummary.getThresholdCriteria() == ThresholdHelper.CHART_AND_SUBFUND) {
                notetxt = notetxt + " Chart " + receivingThreshold.getChartOfAccountsCode();
                notetxt = notetxt + " - Sub-Fund " + receivingThreshold.getSubFundGroupCode();
            } else if (thresholdSummary.getThresholdCriteria() == ThresholdHelper.CHART_AND_COMMODITYCODE) {
                notetxt = notetxt + " Chart " + receivingThreshold.getChartOfAccountsCode();
                notetxt = notetxt + " - Commodity Code " + receivingThreshold.getPurchasingCommodityCode();
            } else if (thresholdSummary.getThresholdCriteria() == ThresholdHelper.CHART_AND_OBJECTCODE) {
                notetxt = notetxt + " Chart " + receivingThreshold.getChartOfAccountsCode();
                notetxt = notetxt + " - Object code " + receivingThreshold.getFinancialObjectCode();
            } else if (thresholdSummary.getThresholdCriteria() == ThresholdHelper.CHART_AND_ORGANIZATIONCODE) {
                notetxt = notetxt + " Chart " + receivingThreshold.getChartOfAccountsCode();
                notetxt = notetxt + " - Organization " + receivingThreshold.getOrganizationCode();
            } else if (thresholdSummary.getThresholdCriteria() == ThresholdHelper.CHART_AND_VENDOR) {
                notetxt = notetxt + " Chart " + receivingThreshold.getChartOfAccountsCode();
                notetxt = notetxt + " - Vendor " + receivingThreshold.getVendorNumber();
            }
            try {
                Note note = this.documentService.createNoteFromDocument((Document)po, notetxt);
                this.noteService.save(note);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean hasNewUnorderedItem(PurchaseOrderDocument po) {
        boolean itemAdded = false;
        for (PurchaseOrderItem poItem : po.getItems()) {
            if (!poItem.isItemActiveIndicator() || !poItem.getItemType().isLineItemIndicator() || !"UNOR".equals(poItem.getItemTypeCode()) || poItem.getItemIdentifier() != null && this.purchaseOrderDao.itemExistsOnPurchaseOrder(poItem.getItemLineNumber(), this.purchaseOrderDao.getDocumentNumberForCurrentPurchaseOrder(po.getPurapDocumentIdentifier()))) continue;
            itemAdded = true;
            break;
        }
        return itemAdded;
    }

    @Override
    public boolean isNewUnorderedItem(PurchaseOrderItem poItem) {
        boolean itemAdded = false;
        if (poItem.isItemActiveIndicator() && poItem.getItemType().isLineItemIndicator() && "UNOR".equals(poItem.getItemTypeCode()) && (poItem.getItemIdentifier() == null || !this.purchaseOrderDao.itemExistsOnPurchaseOrder(poItem.getItemLineNumber(), this.purchaseOrderDao.getDocumentNumberForCurrentPurchaseOrder(poItem.getPurchaseOrder().getPurapDocumentIdentifier())))) {
            itemAdded = true;
        }
        return itemAdded;
    }

    @Override
    public boolean isNewItemForAmendment(PurchaseOrderItem poItem) {
        boolean itemAdded = false;
        if (poItem.isItemActiveIndicator() && poItem.getItemType().isLineItemIndicator()) {
            Integer docId = poItem.getPurapDocumentIdentifier();
            if (docId == null) {
                docId = poItem.getPurchaseOrder().getPurapDocumentIdentifier();
            }
            if (poItem.getItemIdentifier() == null || !this.purchaseOrderDao.itemExistsOnPurchaseOrder(poItem.getItemLineNumber(), this.purchaseOrderDao.getDocumentNumberForCurrentPurchaseOrder(docId))) {
                itemAdded = true;
            }
        }
        return itemAdded;
    }

    protected void sendFyiForNewUnorderedItems(PurchaseOrderDocument po) {
        List<AdHocRoutePerson> fyiList = this.createFyiFiscalOfficerListForNewUnorderedItems(po);
        String annotation = "Notification of New Unordered Items for Purchase Order" + po.getPurapDocumentIdentifier() + "(document id " + po.getDocumentNumber() + ")";
        String responsibilityNote = "Purchase Order Amendment Routed By User";
        for (AdHocRoutePerson adHocPerson : fyiList) {
            try {
                po.appSpecificRouteDocumentToUser(po.getDocumentHeader().getWorkflowDocument(), adHocPerson.getPerson().getPrincipalId(), annotation, responsibilityNote);
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Error routing fyi for document with id " + po.getDocumentNumber(), e);
            }
        }
    }

    protected List<AdHocRoutePerson> createFyiFiscalOfficerListForNewUnorderedItems(PurchaseOrderDocument po) {
        ArrayList<AdHocRoutePerson> adHocRoutePersons = new ArrayList<AdHocRoutePerson>();
        HashMap<String, String> fiscalOfficers = new HashMap<String, String>();
        AdHocRoutePerson adHocRoutePerson = null;
        for (PurchaseOrderItem poItem : po.getItems()) {
            if (!poItem.isItemActiveIndicator() || !poItem.getItemType().isLineItemIndicator() || !"UNOR".equals(poItem.getItemTypeCode()) || poItem.getItemIdentifier() != null && this.purchaseOrderDao.itemExistsOnPurchaseOrder(poItem.getItemLineNumber(), this.purchaseOrderDao.getDocumentNumberForCurrentPurchaseOrder(po.getPurapDocumentIdentifier()))) continue;
            for (PurApAccountingLine account : poItem.getSourceAccountingLines()) {
                if (fiscalOfficers.containsKey(account.getAccount().getAccountFiscalOfficerUser().getPrincipalName())) continue;
                fiscalOfficers.put(account.getAccount().getAccountFiscalOfficerUser().getPrincipalName(), account.getAccount().getAccountFiscalOfficerUser().getPrincipalName());
                adHocRoutePerson = new AdHocRoutePerson();
                adHocRoutePerson.setId(account.getAccount().getAccountFiscalOfficerUser().getPrincipalName());
                adHocRoutePerson.setActionRequested("F");
                adHocRoutePersons.add(adHocRoutePerson);
            }
        }
        return adHocRoutePersons;
    }

    @Override
    public void sendFyiForGLEntries(PurchaseOrderDocument po) {
        List<AdHocRoutePerson> fyiList = this.createFyiFiscalOfficerListForAmendGlEntries(po);
        String annotation = "Amendment to Purchase Order " + po.getPurapDocumentIdentifier() + "( Document id " + po.getDocumentNumber() + ")" + " resulted in the generation of Pending General Ledger Entries.";
        String responsibilityNote = "Purchase Order Amendment Routed By User";
        for (AdHocRoutePerson adHocPerson : fyiList) {
            try {
                po.appSpecificRouteDocumentToUser(po.getDocumentHeader().getWorkflowDocument(), adHocPerson.getPerson().getPrincipalId(), annotation, responsibilityNote);
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Error routing fyi for document with id " + po.getDocumentNumber(), e);
            }
        }
    }

    @Override
    public void sendAdhocFyi(PurchaseOrderDocument po) {
        RequisitionDocument req = po.getPurApSourceDocumentIfPossible();
        String reqInitiator = null;
        if (ObjectUtils.isNotNull((Object)req)) {
            reqInitiator = req.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        }
        String currentDocumentTypeName = po.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        HashSet<String> fiscalOfficerIds = new HashSet<String>();
        HashSet<Account> accounts = new HashSet<Account>();
        try {
            if (reqInitiator != null) {
                po.appSpecificRouteDocumentToUser(po.getDocumentHeader().getWorkflowDocument(), reqInitiator, this.getAdhocFyiAnnotation(po) + " " + req.getPurapDocumentIdentifier() + " " + "(document Id " + req.getDocumentNumber() + ")", "Requisition Routed By User");
            }
            if (!"POA".equalsIgnoreCase(currentDocumentTypeName)) {
                List items = po.getItemsActiveOnly();
                for (PurchaseOrderItem item : items) {
                    List<PurApAccountingLine> lines = item.getSourceAccountingLines();
                    for (PurApAccountingLine line : lines) {
                        accounts.add(line.getAccount());
                    }
                }
                for (Account account : accounts) {
                    String principalId = account.getAccountFiscalOfficerUser().getPrincipalId();
                    if (fiscalOfficerIds.contains(principalId)) continue;
                    fiscalOfficerIds.add(principalId);
                    AccountDelegate accountDelegate = this.getAccountPrimaryDelegate(account);
                    if (ObjectUtils.isNotNull((Object)accountDelegate)) {
                        String delegateName = KimApiServiceLocator.getPersonService().getPerson(accountDelegate.getAccountDelegateSystemId()).getPrincipalName();
                        String annotationText = "Delegation of: KFS-SYS Fiscal Officer " + account.getChartOfAccountsCode() + " " + account.getAccountNumber() + " " + "to principal" + " " + delegateName;
                        po.appSpecificRouteDocumentToUser(po.getDocumentHeader().getWorkflowDocument(), accountDelegate.getAccountDelegateSystemId(), annotationText, "Fiscal Officer Notification");
                        continue;
                    }
                    String annotationText = "KFS-SYS Fiscal Officer " + account.getChartOfAccountsCode() + " " + account.getAccountNumber();
                    po.appSpecificRouteDocumentToUser(po.getDocumentHeader().getWorkflowDocument(), principalId, annotationText, "Fiscal Officer Notification");
                }
            }
        }
        catch (WorkflowException ex) {
            throw new RuntimeException("Error routing fyi for document with id " + po.getDocumentNumber(), ex);
        }
    }

    private AccountDelegate getAccountPrimaryDelegate(Account account) {
        AccountDelegate delegateExample = new AccountDelegate();
        delegateExample.setChartOfAccountsCode(account.getChartOfAccountsCode());
        delegateExample.setAccountNumber(account.getAccountNumber());
        delegateExample.setFinancialDocumentTypeCode("PO");
        AccountDelegate accountDelegate = ((AccountService)SpringContext.getBean(AccountService.class)).getPrimaryDelegationByExample(delegateExample, null);
        return accountDelegate;
    }

    protected String getAdhocFyiAnnotation(PurchaseOrderDocument po) {
        String annotation = "";
        if (po.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            annotation = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("message.document.purap.disapprove.annotation");
        }
        if (po.getDocumentHeader().getWorkflowDocument().isFinal()) {
            annotation = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("message.document.purap.final.annotation");
        }
        if (po.getDocumentHeader().getWorkflowDocument().isCanceled()) {
            annotation = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("message.document.purap.cancel.annotation");
        }
        return annotation;
    }

    protected List<AdHocRoutePerson> createFyiFiscalOfficerListForAmendGlEntries(PurchaseOrderDocument po) {
        ArrayList<AdHocRoutePerson> adHocRoutePersons = new ArrayList<AdHocRoutePerson>();
        HashMap<String, String> fiscalOfficers = new HashMap<String, String>();
        AdHocRoutePerson adHocRoutePerson = null;
        for (SourceAccountingLine account : po.getGlOnlySourceAccountingLines()) {
            Account acct = ((AccountService)SpringContext.getBean(AccountService.class)).getByPrimaryId(account.getChartOfAccountsCode(), account.getAccountNumber());
            String principalName = acct.getAccountFiscalOfficerUser().getPrincipalName();
            if (fiscalOfficers.containsKey(principalName)) continue;
            fiscalOfficers.put(principalName, principalName);
            adHocRoutePerson = new AdHocRoutePerson();
            adHocRoutePerson.setId(principalName);
            adHocRoutePerson.setActionRequested("F");
            adHocRoutePersons.add(adHocRoutePerson);
        }
        return adHocRoutePersons;
    }

    @Override
    public HashMap<String, List<PurchaseOrderItem>> categorizeItemsForSplit(List<PurchaseOrderItem> items) {
        HashMap<String, List<PurchaseOrderItem>> movingOrNot = new HashMap<String, List<PurchaseOrderItem>>(3);
        ArrayList<PurchaseOrderItem> movingPOItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurchaseOrderItem> remainingPOItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurchaseOrderItem> remainingPOLineItems = new ArrayList<PurchaseOrderItem>();
        for (PurchaseOrderItem item : items) {
            if (item.isMovingToSplit()) {
                movingPOItems.add(item);
                continue;
            }
            remainingPOItems.add(item);
            if (!item.getItemType().isLineItemIndicator()) continue;
            remainingPOLineItems.add(item);
        }
        movingOrNot.put("movingPOItems", movingPOItems);
        movingOrNot.put("remainingPOItems", remainingPOItems);
        movingOrNot.put("remainingPOLineItems", remainingPOLineItems);
        return movingOrNot;
    }

    @Override
    public PurchaseOrderVendorQuote populateQuoteWithVendor(Integer headerId, Integer detailId, String documentNumber) {
        VendorDetail vendor = this.vendorService.getVendorDetail(headerId, detailId);
        this.updateDefaultVendorAddress(vendor);
        PurchaseOrderVendorQuote newPOVendorQuote = this.populateAddressForPOVendorQuote(vendor, documentNumber);
        for (VendorPhoneNumber phone : vendor.getVendorPhoneNumbers()) {
            if (!"PH".equals(phone.getVendorPhoneTypeCode())) continue;
            newPOVendorQuote.setVendorPhoneNumber(phone.getVendorPhoneNumber());
            break;
        }
        return newPOVendorQuote;
    }

    protected PurchaseOrderVendorQuote populateAddressForPOVendorQuote(VendorDetail newVendor, String documentNumber) {
        PurchaseOrderVendorQuote newPOVendorQuote = new PurchaseOrderVendorQuote();
        newPOVendorQuote.setVendorName(newVendor.getVendorName());
        newPOVendorQuote.setVendorHeaderGeneratedIdentifier(newVendor.getVendorHeaderGeneratedIdentifier());
        newPOVendorQuote.setVendorDetailAssignedIdentifier(newVendor.getVendorDetailAssignedIdentifier());
        newPOVendorQuote.setDocumentNumber(documentNumber);
        boolean foundAddress = false;
        for (VendorAddress address : newVendor.getVendorAddresses()) {
            if (!"QT".equals(address.getVendorAddressTypeCode())) continue;
            newPOVendorQuote.setVendorCityName(address.getVendorCityName());
            newPOVendorQuote.setVendorCountryCode(address.getVendorCountryCode());
            newPOVendorQuote.setVendorLine1Address(address.getVendorLine1Address());
            newPOVendorQuote.setVendorLine2Address(address.getVendorLine2Address());
            newPOVendorQuote.setVendorPostalCode(address.getVendorZipCode());
            newPOVendorQuote.setVendorStateCode(address.getVendorStateCode());
            newPOVendorQuote.setVendorFaxNumber(address.getVendorFaxNumber());
            foundAddress = true;
            break;
        }
        if (!foundAddress) {
            newPOVendorQuote.setVendorCityName(newVendor.getDefaultAddressCity());
            newPOVendorQuote.setVendorCountryCode(newVendor.getDefaultAddressCountryCode());
            newPOVendorQuote.setVendorLine1Address(newVendor.getDefaultAddressLine1());
            newPOVendorQuote.setVendorLine2Address(newVendor.getDefaultAddressLine2());
            newPOVendorQuote.setVendorPostalCode(newVendor.getDefaultAddressPostalCode());
            newPOVendorQuote.setVendorStateCode(newVendor.getDefaultAddressStateCode());
            newPOVendorQuote.setVendorFaxNumber(newVendor.getDefaultFaxNumber());
        }
        return newPOVendorQuote;
    }

    protected void updateDefaultVendorAddress(VendorDetail vendor) {
        VendorAddress defaultAddress = this.vendorService.getVendorDefaultAddress(vendor.getVendorHeaderGeneratedIdentifier(), vendor.getVendorDetailAssignedIdentifier(), vendor.getVendorHeader().getVendorType().getAddressType().getVendorAddressTypeCode(), "", false);
        if (defaultAddress != null) {
            if (defaultAddress.getVendorState() != null) {
                vendor.setVendorStateForLookup(defaultAddress.getVendorState().getName());
            }
            vendor.setDefaultAddressLine1(defaultAddress.getVendorLine1Address());
            vendor.setDefaultAddressLine2(defaultAddress.getVendorLine2Address());
            vendor.setDefaultAddressCity(defaultAddress.getVendorCityName());
            vendor.setDefaultAddressPostalCode(defaultAddress.getVendorZipCode());
            vendor.setDefaultAddressStateCode(defaultAddress.getVendorStateCode());
            vendor.setDefaultAddressInternationalProvince(defaultAddress.getVendorAddressInternationalProvinceName());
            vendor.setDefaultAddressCountryCode(defaultAddress.getVendorCountryCode());
            vendor.setDefaultFaxNumber(defaultAddress.getVendorFaxNumber());
        }
    }

    @Override
    public void processACMReq(ContractManagerAssignmentDocument acmDoc) {
        List acmDetails = acmDoc.getContractManagerAssignmentDetails();
        for (ContractManagerAssignmentDetail detail : acmDetails) {
            RequisitionDocument req;
            if (!ObjectUtils.isNotNull((Object)detail.getContractManagerCode()) || !"Awaiting Contract Manager Assignment".equals((req = this.requisitionService.getRequisitionById(detail.getRequisitionIdentifier())).getApplicationDocumentStatus())) continue;
            try {
                req.updateAndSaveAppDocStatus("Closed");
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Error saving routing data while saving document with id " + req.getDocumentNumber(), e);
            }
            this.purapService.saveDocumentNoValidation((Document)req);
            this.createPurchaseOrderDocument(req, "kfs", detail.getContractManagerCode());
        }
    }

    @Override
    public boolean autoCloseRecurringOrders() {
        LOG.debug((Object)"autoCloseRecurringOrders() started");
        boolean shouldSendEmail = true;
        MailMessage message = new MailMessage();
        String parameterEmail = this.parameterService.getParameterValueAsString(AutoCloseRecurringOrdersStep.class, "AUTO_CLOSE_RECURRING_PO_TO_EMAIL_ADDRESSES");
        if (StringUtils.isEmpty((String)parameterEmail)) {
            LOG.error((Object)"autoCloseRecurringOrders(): parameterEmail is missing, we'll not send out any emails for this job.");
            shouldSendEmail = false;
        }
        if (shouldSendEmail) {
            message = this.setMessageAddressesAndSubject(message, parameterEmail);
        }
        StringBuffer emailBody = new StringBuffer();
        String recurringOrderDateString = this.parameterService.getParameterValueAsString(AutoCloseRecurringOrdersStep.class, "AUTO_CLOSE_RECURRING_PO_DATE");
        boolean validDate = true;
        Date recurringOrderDate = null;
        try {
            recurringOrderDate = this.dateTimeService.convertToDate(recurringOrderDateString);
        }
        catch (ParseException pe) {
            validDate = false;
        }
        if (StringUtils.isEmpty((String)recurringOrderDateString) || recurringOrderDateString.equalsIgnoreCase("mm/dd/yyyy") || !validDate) {
            if (recurringOrderDateString.equalsIgnoreCase("mm/dd/yyyy")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"autoCloseRecurringOrders(): mm/dd/yyyy was found in the Application Settings table. No orders will be closed, method will end.");
                }
                if (shouldSendEmail) {
                    emailBody.append("The AUTO_CLOSE_RECURRING_ORDER_DT found in the Application Settings table was mm/dd/yyyy. No recurring PO's were closed.");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("autoCloseRecurringOrders(): An invalid autoCloseRecurringOrdersDate was found in the Application Settings table: " + recurringOrderDateString + ". Method will end."));
                }
                if (shouldSendEmail) {
                    emailBody.append("An invalid AUTO_CLOSE_RECURRING_ORDER_DT was found in the Application Settings table: " + recurringOrderDateString + ". No recurring PO's were closed.");
                }
            }
            if (shouldSendEmail) {
                this.sendMessage(message, emailBody.toString());
            }
            LOG.info((Object)"autoCloseRecurringOrders() ended");
            return false;
        }
        LOG.info((Object)("autoCloseRecurringOrders() The autoCloseRecurringOrdersDate found in the Application Settings table was " + recurringOrderDateString));
        if (shouldSendEmail) {
            emailBody.append("The autoCloseRecurringOrdersDate found in the Application Settings table was " + recurringOrderDateString + ".");
        }
        Calendar appSettingsDate = this.dateTimeService.getCalendar(recurringOrderDate);
        Timestamp appSettingsDay = new Timestamp(appSettingsDate.getTime().getTime());
        Calendar todayMinusThreeMonths = this.getTodayMinusThreeMonths();
        Timestamp threeMonthsAgo = new Timestamp(todayMinusThreeMonths.getTime().getTime());
        if (appSettingsDate.after(todayMinusThreeMonths)) {
            LOG.info((Object)("autoCloseRecurringOrders() The appSettingsDate: " + appSettingsDay + " is after todayMinusThreeMonths: " + threeMonthsAgo + ". The program will end."));
            if (shouldSendEmail) {
                emailBody.append("\n\nThe autoCloseRecurringOrdersDate: " + appSettingsDay + " is after todayMinusThreeMonths: " + threeMonthsAgo + ". The program will end.");
                this.sendMessage(message, emailBody.toString());
            }
            LOG.info((Object)"autoCloseRecurringOrders() ended");
            return false;
        }
        List<AutoClosePurchaseOrderView> closeList = this.purchaseOrderDao.getAutoCloseRecurringPurchaseOrders(this.getExcludedVendorChoiceCodes());
        List<AutoClosePurchaseOrderView> purchaseOrderAutoCloseList = this.filterDocumentsForAppDocStatusOpen(closeList);
        LOG.info((Object)("autoCloseRecurringOrders(): " + purchaseOrderAutoCloseList.size() + " PO's were returned for processing."));
        int counter = 0;
        for (AutoClosePurchaseOrderView poAutoClose : purchaseOrderAutoCloseList) {
            LOG.info((Object)("autoCloseRecurringOrders(): Testing PO ID " + poAutoClose.getPurapDocumentIdentifier() + ". recurringPaymentEndDate: " + poAutoClose.getRecurringPaymentEndDate()));
            if (!poAutoClose.getRecurringPaymentEndDate().before(threeMonthsAgo)) continue;
            String newStatus = "Pending Close";
            String annotation = "This recurring PO was automatically closed in batch.";
            String documentType = "POC";
            PurchaseOrderDocument document = this.getPurchaseOrderByDocumentNumber(poAutoClose.getDocumentNumber());
            boolean rulePassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new AttributedRouteDocumentEvent("", (Document)document));
            boolean success = true;
            if (success) {
                if (++counter == 1) {
                    emailBody.append("\n\nThe following recurring Purchase Orders will be closed by auto close recurring batch job \n");
                }
                LOG.info((Object)("autoCloseRecurringOrders() PO ID " + poAutoClose.getPurapDocumentIdentifier() + " will be closed."));
                this.createNoteForAutoCloseOrders(document, annotation);
                this.createAndRoutePotentialChangeDocument(poAutoClose.getDocumentNumber(), documentType, annotation, null, newStatus);
                if (!shouldSendEmail) continue;
                emailBody.append("\n\n" + counter + " PO ID: " + poAutoClose.getPurapDocumentIdentifier() + ", End Date: " + poAutoClose.getRecurringPaymentEndDate() + ", Status: " + poAutoClose.getApplicationDocumentStatus() + ", VendorChoice: " + poAutoClose.getVendorChoiceCode() + ", RecurringPaymentType: " + poAutoClose.getRecurringPaymentTypeCode());
                continue;
            }
            GlobalVariables.getMessageMap().clearErrorMessages();
        }
        if (counter == 0) {
            LOG.info((Object)"\n\nNo recurring PO's fit the conditions for closing.");
            if (shouldSendEmail) {
                emailBody.append("\n\nNo recurring PO's fit the conditions for closing.");
            }
        }
        if (shouldSendEmail) {
            this.sendMessage(message, emailBody.toString());
        }
        this.resetAutoCloseRecurringOrderDateParameter();
        LOG.debug((Object)"autoCloseRecurringOrders() ended");
        return true;
    }

    protected List<AutoClosePurchaseOrderView> filterDocumentsForAppDocStatusOpen(List<AutoClosePurchaseOrderView> autoClosePurchaseOrderViews) {
        ArrayList<AutoClosePurchaseOrderView> filteredAutoClosePOView = new ArrayList<AutoClosePurchaseOrderView>();
        for (AutoClosePurchaseOrderView autoClosePurchaseOrderView : autoClosePurchaseOrderViews) {
            Document document = this.findDocument(autoClosePurchaseOrderView.getDocumentNumber());
            if (document == null || !"Open".equalsIgnoreCase(document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus())) continue;
            filteredAutoClosePOView.add(autoClosePurchaseOrderView);
        }
        return filteredAutoClosePOView;
    }

    protected Document findDocument(String documentHeaderId) {
        Document document = null;
        try {
            document = this.documentService.getByDocumentHeaderId(documentHeaderId);
        }
        catch (WorkflowException ex) {
            LOG.error((Object)("Exception encountered on finding the document: " + documentHeaderId), (Throwable)ex);
        }
        catch (UnknownDocumentTypeException ex) {
            LOG.error((Object)("Exception encountered on finding the document: " + documentHeaderId), (Throwable)ex);
        }
        return document;
    }

    protected Calendar getTodayMinusThreeMonths() {
        Calendar todayMinusThreeMonths = Calendar.getInstance();
        todayMinusThreeMonths.add(2, -3);
        todayMinusThreeMonths.set(10, 12);
        todayMinusThreeMonths.set(12, 0);
        todayMinusThreeMonths.set(13, 0);
        todayMinusThreeMonths.set(14, 0);
        todayMinusThreeMonths.set(9, 0);
        return todayMinusThreeMonths;
    }

    protected MailMessage setMessageAddressesAndSubject(MailMessage message, String parameterEmail) {
        String[] toAddressList = parameterEmail.split(";");
        if (toAddressList.length > 0) {
            for (int i = 0; i < toAddressList.length; ++i) {
                if (toAddressList[i] == null) continue;
                message.addToAddress(toAddressList[i].trim());
            }
        }
        message.setFromAddress(toAddressList[0]);
        message.setSubject("Auto Close Recurring Purchase Orders");
        return message;
    }

    protected void sendMessage(MailMessage message, String emailBody) {
        message.setMessage(emailBody);
        try {
            this.mailService.sendMessage(message);
        }
        catch (Exception e) {
            LOG.error((Object)"autoCloseRecurringOrders(): email problem. Message not sent.", (Throwable)e);
        }
    }

    protected void resetAutoCloseRecurringOrderDateParameter() {
        Parameter autoCloseRecurringPODate = this.parameterService.getParameter(AutoCloseRecurringOrdersStep.class, "AUTO_CLOSE_RECURRING_PO_DATE");
        if (autoCloseRecurringPODate != null) {
            Parameter.Builder updatedParameter = Parameter.Builder.create((ParameterContract)autoCloseRecurringPODate);
            updatedParameter.setValue("mm/dd/yyyy");
            this.parameterService.updateParameter(updatedParameter.build());
        }
    }

    protected List<String> getExcludedVendorChoiceCodes() {
        ArrayList<String> excludedVendorChoiceCodes = new ArrayList<String>();
        for (int i = 0; i < PurapConstants.AUTO_CLOSE_EXCLUSION_VNDR_CHOICE_CODES.length; ++i) {
            String excludedCode = PurapConstants.AUTO_CLOSE_EXCLUSION_VNDR_CHOICE_CODES[i];
            excludedVendorChoiceCodes.add(excludedCode);
        }
        return excludedVendorChoiceCodes;
    }

    @Override
    public void createNoteForAutoCloseOrders(PurchaseOrderDocument purchaseOrderDocument, String annotation) {
        try {
            Note noteObj = this.documentService.createNoteFromDocument((Document)purchaseOrderDocument, annotation);
            this.noteService.save(noteObj);
        }
        catch (Exception e) {
            String errorMessage = "Error creating and saving close note for purchase order with document service";
            LOG.error((Object)("createNoteForAutoCloseRecurringOrders " + errorMessage), (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    @Override
    public List<AutoClosePurchaseOrderView> getAllOpenPurchaseOrdersForAutoClose() {
        return this.purchaseOrderDao.getAllOpenPurchaseOrders(this.getExcludedVendorChoiceCodes());
    }

    @Override
    public List<PurchasingCapitalAssetItem> retrieveCapitalAssetItemsForIndividual(Integer poId) {
        PurchaseOrderDocument po = this.getCurrentPurchaseOrder(poId);
        if (ObjectUtils.isNotNull((Object)po)) {
            return po.getPurchasingCapitalAssetItems();
        }
        return null;
    }

    @Override
    public CapitalAssetSystem retrieveCapitalAssetSystemForOneSystem(Integer poId) {
        List<CapitalAssetSystem> systems;
        PurchaseOrderDocument po = this.getCurrentPurchaseOrder(poId);
        if (ObjectUtils.isNotNull((Object)po) && ObjectUtils.isNotNull(systems = po.getPurchasingCapitalAssetSystems())) {
            return systems.get(0);
        }
        return null;
    }

    @Override
    public List<CapitalAssetSystem> retrieveCapitalAssetSystemsForMultipleSystem(Integer poId) {
        PurchaseOrderDocument po = this.getCurrentPurchaseOrder(poId);
        if (ObjectUtils.isNotNull((Object)po)) {
            return po.getPurchasingCapitalAssetSystems();
        }
        return null;
    }

    protected void fixItemReferences(PurchaseOrderDocument po) {
        for (PurApItem item : po.getItems()) {
            item.setPurapDocument(po);
            item.fixAccountReferences();
        }
    }

    public List getPendingPurchaseOrderFaxes() {
        List<PurchaseOrderDocument> purchaseOrderList = this.purchaseOrderDao.getPendingPurchaseOrdersForFaxing();
        return this.filterPurchaseOrderDocumentByAppDocStatus(purchaseOrderList, "Pending Fax");
    }

    protected List<PurchaseOrderDocument> filterPurchaseOrderDocumentByAppDocStatus(Collection<PurchaseOrderDocument> purchaseOrderDocuments, String ... appDocStatus) {
        List<String> appDocStatusList = Arrays.asList(appDocStatus);
        ArrayList<PurchaseOrderDocument> filteredPaymentRequestDocuments = new ArrayList<PurchaseOrderDocument>();
        for (PurchaseOrderDocument po : purchaseOrderDocuments) {
            if (!appDocStatusList.contains(po.getApplicationDocumentStatus())) continue;
            filteredPaymentRequestDocuments.add(po);
        }
        return filteredPaymentRequestDocuments;
    }

    @Deprecated
    protected List<String> filterPurchaseOrderDocumentNumbersByAppDocStatus(List<String> lookupDocNumbers, String ... appDocStatus) {
        ArrayList<String> purchaseOrderDocNumbers = new ArrayList<String>();
        List<String> appDocStatusList = Arrays.asList(appDocStatus);
        for (String docNumber : lookupDocNumbers) {
            if (!appDocStatusList.contains(this.financialSystemDocumentService.findByDocumentNumber(docNumber).getApplicationDocumentStatus())) continue;
            purchaseOrderDocNumbers.add(docNumber);
        }
        return purchaseOrderDocNumbers;
    }

    @Override
    public String getPurchaseOrderAppDocStatus(Integer poId) {
        PurchaseOrderDocument po = this.getCurrentPurchaseOrder(poId);
        if (ObjectUtils.isNotNull((Object)po)) {
            return po.getApplicationDocumentStatus();
        }
        return null;
    }

    protected void savePurchaseOrderData(PurchaseOrderDocument po) {
        this.businessObjectService.save((PersistableBusinessObject)po);
        DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
        documentAttributeIndexingQueue.indexDocument(po.getDocumentNumber());
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setB2bPurchaseOrderService(B2BPurchaseOrderService purchaseOrderService) {
        this.b2bPurchaseOrderService = purchaseOrderService;
    }

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.businessObjectService = boService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public void setPurchaseOrderDao(PurchaseOrderDao purchaseOrderDao) {
        this.purchaseOrderDao = purchaseOrderDao;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setRequisitionService(RequisitionService requisitionService) {
        this.requisitionService = requisitionService;
    }

    public void setPurapWorkflowIntegrationService(PurApWorkflowIntegrationService purapWorkflowIntegrationService) {
        this.purapWorkflowIntegrationService = purapWorkflowIntegrationService;
    }

    public void setMaintenanceDocumentService(MaintenanceDocumentService maintenanceDocumentService) {
        this.maintenanceDocumentService = maintenanceDocumentService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }
}

