/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.document.validation.impl.PaymentRequestProcessItemValidation;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentRequestProcessItemValidationTest {
    private PaymentRequestItem paymentRequestItemMock;
    private PaymentRequestProcessItemValidation cut;

    @Before
    public void setUp() {
        this.paymentRequestItemMock = (PaymentRequestItem)EasyMock.createMock(PaymentRequestItem.class);
        this.cut = new PaymentRequestProcessItemValidation();
    }

    @Test
    public void testValidateItemWithoutAccounts_ValidExtendedCost_AccountListNotEmpty_ReturnsTrue() {
        EasyMock.expect((Object)this.paymentRequestItemMock.getExtendedPrice()).andReturn((Object)new KualiDecimal(70)).times(2);
        EasyMock.expect((Object)this.paymentRequestItemMock.isAccountListEmpty()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.paymentRequestItemMock});
        Assert.assertTrue((boolean)this.cut.validateItemWithoutAccounts(this.paymentRequestItemMock, "foo"));
    }

    @Test
    public void testValidateItemWithoutAccounts_ValidExtendedCost_NoAccount_ReturnsFalse() {
        EasyMock.expect((Object)this.paymentRequestItemMock.getExtendedPrice()).andReturn((Object)new KualiDecimal(70)).times(2);
        EasyMock.expect((Object)this.paymentRequestItemMock.isAccountListEmpty()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.paymentRequestItemMock});
        Assert.assertFalse((boolean)this.cut.validateItemWithoutAccounts(this.paymentRequestItemMock, "foo"));
    }

    @Test
    public void testValidateItemWithoutAccounts_NullExtendedCost_ReturnsTrue() {
        EasyMock.expect((Object)this.paymentRequestItemMock.getExtendedPrice()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.paymentRequestItemMock});
        Assert.assertTrue((boolean)this.cut.validateItemWithoutAccounts(this.paymentRequestItemMock, "foo"));
    }
}

