/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomizeGeneralLedgerPendingEntryTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private PurchasingAccountsPayableDocument purapDocument;
    private UniversityDateService universityDateService;
    private ObjectCodeService objectCodeService;
    private PaymentRequestService paymentRequestService;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.universityDateService = (UniversityDateService)EasyMock.createMock(UniversityDateService.class);
        this.purapGeneralLedgerService.setUniversityDateService(this.universityDateService);
        this.objectCodeService = (ObjectCodeService)EasyMock.createMock(ObjectCodeService.class);
        this.purapGeneralLedgerService.setObjectCodeService(this.objectCodeService);
        this.paymentRequestService = (PaymentRequestService)EasyMock.createMock(PaymentRequestService.class);
        this.purapGeneralLedgerService.setPaymentRequestService(this.paymentRequestService);
        this.purapDocument = (PurchasingAccountsPayableDocument)EasyMock.createMock(PurchasingAccountsPayableDocument.class);
    }

    @Test
    public void testPODocumentSameYearNonEncumbrancePositive() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.purapDocument.getPostingYear()).andReturn((Object)2016);
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).andReturn((Object)this.getObjectCode());
        this.replayAll();
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", false);
        this.verifyAll();
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testPODocumentNextYearNonEncumbrancePositive() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.purapDocument.getPostingYear()).andReturn((Object)2017).times(2);
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2017), "BL", "4166")).andReturn((Object)this.getObjectCode());
        this.replayAll();
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", false);
        this.verifyAll();
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2017L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testPODocumentSameYearNonEncumbranceReferenceDocPositive() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.purapDocument.getPostingYear()).andReturn((Object)2016);
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).andReturn((Object)this.getObjectCode());
        this.replayAll();
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, Integer.valueOf(100), "D", "PO", false);
        this.verifyAll();
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals((Object)"100", (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals((Object)"PO", (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testPODocumentSameYearEncumbrancePositive() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.purapDocument.getPostingYear()).andReturn((Object)2016);
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).andReturn((Object)this.getObjectCode());
        this.replayAll();
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", true);
        this.verifyAll();
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testPODocumentSameYearNonEncumbranceNegativeDebit() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.purapDocument.getPostingYear()).andReturn((Object)2016);
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).andReturn((Object)this.getObjectCode());
        this.replayAll();
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("-100")), explicitEntry, null, "D", "PO", false);
        this.verifyAll();
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"C", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testPODocumentSameYearNonEncumbranceNegativeCredit() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.purapDocument.getPostingYear()).andReturn((Object)2016);
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).andReturn((Object)this.getObjectCode());
        this.replayAll();
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("-100")), explicitEntry, null, "C", "PO", false);
        this.verifyAll();
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testInvalidDocType() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234").times(2);
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        this.replayAll();
        try {
            this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "BAD", true);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPREQDocumentSameYearNonEncumbrancePositiveNoBackpost() {
        this.purapDocument = (PurchasingAccountsPayableDocument)EasyMock.createMock(PaymentRequestDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).andReturn((Object)this.getObjectCode());
        EasyMock.expect((Object)this.paymentRequestService.allowBackpost((PaymentRequestDocument)EasyMock.anyObject())).andReturn((Object)false);
        EasyMock.expect((Object)((PaymentRequestDocument)this.purapDocument).getAlternateVendorHeaderGeneratedIdentifier()).andReturn(null);
        this.replayAll();
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        this.verifyAll();
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testPREQDocumentSameYearNonEncumbrancePositiveBackpost() {
        this.purapDocument = (PurchasingAccountsPayableDocument)EasyMock.createMock(PaymentRequestDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2015), "BL", "4166")).andReturn((Object)this.getObjectCode());
        EasyMock.expect((Object)this.paymentRequestService.allowBackpost((PaymentRequestDocument)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)((PaymentRequestDocument)this.purapDocument).getAlternateVendorHeaderGeneratedIdentifier()).andReturn(null);
        this.replayAll();
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        this.verifyAll();
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2015L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"12", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testPREQDocumentSameYearNonEncumbrancePositiveAlternativeVendor() {
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        this.purapDocument = (PurchasingAccountsPayableDocument)EasyMock.createMock(PaymentRequestDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2015), "BL", "4166")).andReturn((Object)this.getObjectCode());
        EasyMock.expect((Object)this.paymentRequestService.allowBackpost((PaymentRequestDocument)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)((PaymentRequestDocument)this.purapDocument).getAlternateVendorHeaderGeneratedIdentifier()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)((PaymentRequestDocument)this.purapDocument).getAlternateVendorDetailAssignedIdentifier()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.purapDocument.getVendorHeaderGeneratedIdentifier()).andReturn((Object)1);
        EasyMock.expect((Object)this.purapDocument.getVendorDetailAssignedIdentifier()).andReturn((Object)1);
        EasyMock.expect((Object)((PaymentRequestDocument)this.purapDocument).getPurchaseOrderDocument()).andReturn((Object)purchaseOrderDocument);
        EasyMock.expect((Object)purchaseOrderDocument.getAlternateVendorName()).andReturn((Object)"HP Corporation");
        this.replayAll();
        EasyMock.replay((Object[])new Object[]{purchaseOrderDocument});
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        this.verifyAll();
        EasyMock.verify((Object[])new Object[]{purchaseOrderDocument});
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"HP Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2015L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"12", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testCMDocumentSameYearNonEncumbrancePositiveNotAlternativeVendor() {
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        this.purapDocument = (PurchasingAccountsPayableDocument)EasyMock.createMock(VendorCreditMemoDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).andReturn((Object)this.getObjectCode());
        EasyMock.expect((Object)((VendorCreditMemoDocument)this.purapDocument).isSourceDocumentPaymentRequest()).andReturn((Object)false);
        this.replayAll();
        EasyMock.replay((Object[])new Object[]{purchaseOrderDocument});
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "CM", false);
        this.verifyAll();
        EasyMock.verify((Object[])new Object[]{purchaseOrderDocument});
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void testCMDocumentSameYearNonEncumbrancePositiveAlternativeVendor() {
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)EasyMock.createMock(PaymentRequestDocument.class);
        this.purapDocument = (PurchasingAccountsPayableDocument)EasyMock.createMock(VendorCreditMemoDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        EasyMock.expect((Object)this.purapDocument.getDocumentNumber()).andReturn((Object)"DOC1234");
        EasyMock.expect((Object)this.purapDocument.getVendorName()).andReturn((Object)"ACME Corporation");
        EasyMock.expect((Object)this.universityDateService.getCurrentUniversityDate()).andReturn((Object)this.getUniversityDate());
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).andReturn((Object)this.getObjectCode());
        EasyMock.expect((Object)((VendorCreditMemoDocument)this.purapDocument).isSourceDocumentPaymentRequest()).andReturn((Object)true);
        EasyMock.expect((Object)((VendorCreditMemoDocument)this.purapDocument).getPaymentRequestDocument()).andReturn((Object)paymentRequestDocument);
        EasyMock.expect((Object)paymentRequestDocument.getAlternateVendorHeaderGeneratedIdentifier()).andReturn((Object)111).times(2);
        EasyMock.expect((Object)paymentRequestDocument.getAlternateVendorDetailAssignedIdentifier()).andReturn((Object)222).times(2);
        EasyMock.expect((Object)paymentRequestDocument.getVendorHeaderGeneratedIdentifier()).andReturn((Object)111);
        EasyMock.expect((Object)paymentRequestDocument.getVendorDetailAssignedIdentifier()).andReturn((Object)222);
        EasyMock.expect((Object)((VendorCreditMemoDocument)this.purapDocument).getPurchaseOrderDocument()).andReturn((Object)purchaseOrderDocument);
        EasyMock.expect((Object)purchaseOrderDocument.getAlternateVendorName()).andReturn((Object)"HP Corporation");
        this.replayAll();
        EasyMock.replay((Object[])new Object[]{purchaseOrderDocument});
        EasyMock.replay((Object[])new Object[]{paymentRequestDocument});
        this.purapGeneralLedgerService.customizeGeneralLedgerPendingEntry(this.purapDocument, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "CM", false);
        this.verifyAll();
        EasyMock.verify((Object[])new Object[]{purchaseOrderDocument});
        EasyMock.verify((Object[])new Object[]{paymentRequestDocument});
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"HP Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.universityDateService, this.purapDocument, this.objectCodeService, this.paymentRequestService});
    }

    private void verifyAll() {
        EasyMock.verify((Object[])new Object[]{this.universityDateService, this.purapDocument, this.objectCodeService, this.paymentRequestService});
    }

    private GeneralLedgerPendingEntry getGeneralLedgerPendingEntry() {
        GeneralLedgerPendingEntry g = new GeneralLedgerPendingEntry();
        g.setUniversityFiscalYear(Integer.valueOf(2016));
        g.setChartOfAccountsCode("BL");
        g.setAccountNumber("7654321");
        g.setFinancialObjectCode("4166");
        g.setFinancialSubObjectCode("321");
        g.setFinancialBalanceTypeCode("AC");
        return g;
    }

    private UniversityDate getUniversityDate() {
        UniversityDate d = new UniversityDate();
        d.setUniversityFiscalYear(Integer.valueOf(2016));
        d.setUniversityFiscalAccountingPeriod("03");
        return d;
    }

    private ObjectCode getObjectCode() {
        ObjectCode o = new ObjectCode();
        o.setUniversityFiscalYear(Integer.valueOf(2016));
        o.setChartOfAccountsCode("BL");
        o.setFinancialObjectCode("4166");
        o.setFinancialObjectTypeCode("EX");
        return o;
    }

    private AccountingLine getPurchaseOrderAccountingLine(KualiDecimal amount) {
        PurchaseOrderAccount p = new PurchaseOrderAccount();
        p.setAmount(amount);
        return p;
    }
}

