/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class GenerateEntriesApproveAmendPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private PurchaseOrderDocument oldPo;
    private PurchaseOrderDocument newPo;
    private PurapAccountingService purapAccountingService;
    private GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private BusinessObjectService businessObjectService;
    private PurchaseOrderService purchaseOrderService;
    private List<PurApItem> newPoItems;
    private List<PurApItem> newPoActiveItems;
    private List<PurApItem> oldPoItems;
    private List<GeneralLedgerPendingEntry> glpes;
    private List<SourceAccountingLine> newSummaryAccountingLines;
    private List<SourceAccountingLine> oldSummaryAccountingLines;
    private List<SourceAccountingLine> diffSummaryAccountingLines;
    private List<Object> dynamicMocks;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.purapAccountingService = (PurapAccountingService)EasyMock.createMock(PurapAccountingService.class);
        this.purapGeneralLedgerService.setPurapAccountingService(this.purapAccountingService);
        this.generalLedgerPendingEntryService = (GeneralLedgerPendingEntryService)EasyMock.createMock(GeneralLedgerPendingEntryService.class);
        this.purapGeneralLedgerService.setGeneralLedgerPendingEntryService(this.generalLedgerPendingEntryService);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.purapGeneralLedgerService.setBusinessObjectService(this.businessObjectService);
        this.purchaseOrderService = (PurchaseOrderService)EasyMock.createMock(PurchaseOrderService.class);
        this.purapGeneralLedgerService.setPurchaseOrderService(this.purchaseOrderService);
        this.oldPo = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        this.newPo = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        this.newPoItems = new ArrayList<PurApItem>();
        this.newPoActiveItems = new ArrayList<PurApItem>();
        this.oldPoItems = new ArrayList<PurApItem>();
        this.glpes = new ArrayList<GeneralLedgerPendingEntry>();
        this.newSummaryAccountingLines = new ArrayList<SourceAccountingLine>();
        this.oldSummaryAccountingLines = new ArrayList<SourceAccountingLine>();
        this.diffSummaryAccountingLines = new ArrayList<SourceAccountingLine>();
        this.dynamicMocks = new ArrayList<Object>();
    }

    private void execute() {
        EasyMock.replay((Object[])new Object[]{this.oldPo, this.newPo, this.purapAccountingService, this.generalLedgerPendingEntryService, this.businessObjectService, this.purchaseOrderService});
        for (Object mock : this.dynamicMocks) {
            EasyMock.replay((Object[])new Object[]{mock});
        }
        this.purapGeneralLedgerService.generateEntriesApproveAmendPurchaseOrder(this.newPo);
        EasyMock.verify((Object[])new Object[]{this.oldPo, this.newPo, this.purapAccountingService, this.generalLedgerPendingEntryService, this.businessObjectService, this.purchaseOrderService});
        for (Object mock : this.dynamicMocks) {
            EasyMock.verify((Object[])new Object[]{mock});
        }
    }

    private void prepareNewPO() {
        EasyMock.expect((Object)this.newPo.getPurapDocumentIdentifier()).andReturn((Object)101);
        EasyMock.expect((Object)this.newPo.getItems()).andReturn(this.newPoItems).anyTimes();
        EasyMock.expect((Object)this.newPo.getItemsActiveOnly()).andReturn(this.newPoActiveItems).anyTimes();
        this.newPo.setGlOnlySourceAccountingLines(GenerateEntriesApproveAmendPurchaseOrderTest.eqSummaryAccountingLineList(this.diffSummaryAccountingLines));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.newPo.getGeneralLedgerPendingEntries()).andReturn(this.glpes).anyTimes();
    }

    private void prepareOldPO() {
        EasyMock.expect((Object)this.oldPo.getItemsActiveOnlySetupAlternateAmount()).andReturn(this.oldPoItems);
    }

    private KualiDecimal doubleToKualiDecimal(Double amount) {
        if (amount == null) {
            return null;
        }
        return new KualiDecimal(amount.doubleValue());
    }

    private void prepareItem(Double quantity, Double invoicedQuantity, Double outstandingQuantity, Double unitPrice, Double invoicedAmount, Double taxAmount, Double outstandingAmount, List<PurApAccountingLine> accountingLines, boolean active) {
        PurchaseOrderItem item = (PurchaseOrderItem)EasyMock.createMock(PurchaseOrderItem.class);
        EasyMock.expect((Object)item.getItemQuantity()).andReturn((Object)this.doubleToKualiDecimal(quantity)).anyTimes();
        EasyMock.expect((Object)item.getItemInvoicedTotalQuantity()).andReturn((Object)this.doubleToKualiDecimal(invoicedQuantity)).anyTimes();
        EasyMock.expect((Object)item.getItemInvoicedTotalAmount()).andReturn((Object)this.doubleToKualiDecimal(invoicedAmount)).anyTimes();
        EasyMock.expect((Object)item.getSourceAccountingLines()).andReturn(accountingLines).anyTimes();
        EasyMock.expect((Object)item.getItemOutstandingEncumberedQuantity()).andReturn((Object)this.doubleToKualiDecimal(outstandingQuantity)).anyTimes();
        EasyMock.expect((Object)item.getItemOutstandingEncumberedAmount()).andReturn((Object)this.doubleToKualiDecimal(outstandingAmount)).anyTimes();
        EasyMock.expect((Object)item.getItemUnitPrice()).andReturn((Object)new BigDecimal(unitPrice)).anyTimes();
        EasyMock.expect((Object)item.getItemTaxAmount()).andReturn((Object)this.doubleToKualiDecimal(taxAmount)).anyTimes();
        item.setItemInvoicedTotalQuantity(this.doubleToKualiDecimal(invoicedQuantity));
        EasyMock.expectLastCall();
        item.setItemInvoicedTotalAmount(this.doubleToKualiDecimal(invoicedAmount));
        EasyMock.expectLastCall();
        item.setItemOutstandingEncumberedQuantity(this.doubleToKualiDecimal(outstandingQuantity));
        EasyMock.expectLastCall();
        item.setItemOutstandingEncumberedAmount(this.doubleToKualiDecimal(outstandingAmount));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)item.isItemActiveIndicator()).andReturn((Object)active).anyTimes();
        if (active) {
            this.newPoActiveItems.add((PurApItem)item);
        }
        this.newPoItems.add((PurApItem)item);
        this.dynamicMocks.add(item);
    }

    private PurchaseOrderAccount createPoAccountingLine(double percent, double amount, double newOutstandingAmount) {
        PurchaseOrderAccount account = (PurchaseOrderAccount)EasyMock.mock(PurchaseOrderAccount.class);
        EasyMock.expect((Object)account.getAccountLinePercent()).andReturn((Object)new BigDecimal(percent)).anyTimes();
        EasyMock.expect((Object)account.getAmount()).andReturn((Object)this.doubleToKualiDecimal(amount)).anyTimes();
        EasyMock.expect((Object)account.getItemAccountOutstandingEncumbranceAmount()).andReturn((Object)this.doubleToKualiDecimal(newOutstandingAmount));
        account.setItemAccountOutstandingEncumbranceAmount(this.doubleToKualiDecimal(newOutstandingAmount));
        EasyMock.expectLastCall();
        account.setAlternateAmountForGLEntryCreation(this.doubleToKualiDecimal(newOutstandingAmount));
        EasyMock.expectLastCall();
        this.dynamicMocks.add(account);
        return account;
    }

    private void prepareSummaryAccountingLine(Double newAmount, Double oldAmount, Double diffAmount, String objectCode) {
        SourceAccountingLine account;
        if (newAmount != null) {
            account = new SourceAccountingLine();
            account.setFinancialObjectCode(objectCode);
            account.setAmount(this.doubleToKualiDecimal(newAmount));
            this.newSummaryAccountingLines.add(account);
        }
        if (oldAmount != null) {
            account = new SourceAccountingLine();
            account.setFinancialObjectCode(objectCode);
            account.setAmount(this.doubleToKualiDecimal(oldAmount));
            this.oldSummaryAccountingLines.add(account);
        }
        account = new SourceAccountingLine();
        account.setFinancialObjectCode(objectCode);
        account.setAmount(this.doubleToKualiDecimal(diffAmount));
        this.diffSummaryAccountingLines.add(account);
    }

    private void prepareItemsNoAccountingLines() {
        this.prepareItem(3.0, 1.0, 2.0, 5.0, 5.0, 0.5, 10.5, new ArrayList<PurApAccountingLine>(), true);
        this.prepareItem(3.0, 1.0, 0.0, 5.0, 5.0, 0.5, 0.0, new ArrayList<PurApAccountingLine>(), false);
        this.prepareItem(null, 0.0, null, 10.0, 3.0, 0.5, 7.0, new ArrayList<PurApAccountingLine>(), true);
    }

    private void prepareItemsWithAccountingLines() {
        ArrayList<Object> accountingLines = new ArrayList<PurApAccountingLine>();
        accountingLines.add(this.createPoAccountingLine(100.0, 15.0, 10.0));
        this.prepareItem(3.0, 1.0, 2.0, 5.0, 5.0, 0.0, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        accountingLines.add((PurApAccountingLine)this.createPoAccountingLine(50.0, 7.5, 5.0));
        accountingLines.add(this.createPoAccountingLine(50.0, 7.5, 5.0));
        this.prepareItem(3.0, 1.0, 2.0, 5.0, 5.0, 0.0, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        accountingLines.add((PurApAccountingLine)this.createPoAccountingLine(66.66, 6666.67, 6700.0));
        accountingLines.add(this.createPoAccountingLine(33.33, 3333.33, 3300.0));
        this.prepareItem(1.0, 0.0, 1.0, 10000.0, 0.0, 0.0, 10000.0, accountingLines, true);
    }

    private void prepareSummaryAccountingLines() {
        this.prepareSummaryAccountingLine(10.0, 7.0, 3.0, "Matching");
        this.prepareSummaryAccountingLine(10.0, null, 10.0, "NewOnly");
        this.prepareSummaryAccountingLine(null, 7.0, -7.0, "OldOnly");
    }

    private void baseExpectations() {
        this.prepareOldPO();
        this.prepareNewPO();
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(101))).andReturn((Object)this.oldPo);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.newPoActiveItems)).andReturn(this.newSummaryAccountingLines);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.oldPoItems)).andReturn(this.oldSummaryAccountingLines);
        EasyMock.expect((Object)this.generalLedgerPendingEntryService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.newPo)).andReturn((Object)true);
        EasyMock.expect((Object)this.businessObjectService.save(this.glpes)).andReturn(null);
    }

    @Test
    public void testBaseCase() {
        this.baseExpectations();
        this.execute();
    }

    @Test
    public void testPoWithItems() {
        this.baseExpectations();
        this.prepareItemsNoAccountingLines();
        this.execute();
    }

    @Test
    public void testPoWithAccountingLines() {
        this.baseExpectations();
        this.prepareItemsWithAccountingLines();
        this.execute();
    }

    @Test
    public void testPoWithSummaryAccountingLines() {
        this.baseExpectations();
        this.prepareSummaryAccountingLines();
        this.execute();
    }

    public static List<SourceAccountingLine> eqSummaryAccountingLineList(List<SourceAccountingLine> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new SummaryAccountingListEquals(in));
        return null;
    }

    private static class SummaryAccountingListEquals
    implements IArgumentMatcher {
        private List<SourceAccountingLine> expected;

        public SummaryAccountingListEquals(List<SourceAccountingLine> expected) {
            this.expected = expected;
        }

        public boolean matches(Object argument) {
            if (!(argument instanceof List)) {
                return false;
            }
            List actual = (List)argument;
            if (actual.size() != this.expected.size()) {
                return false;
            }
            Collections.sort(this.expected, (a1, a2) -> a1.getFinancialObjectCode().compareTo(a2.getFinancialObjectCode()));
            Collections.sort(actual, (a1, a2) -> a1.getFinancialObjectCode().compareTo(a2.getFinancialObjectCode()));
            for (int i = 0; i < this.expected.size(); ++i) {
                SourceAccountingLine expectedItem = this.expected.get(i);
                SourceAccountingLine actualItem = (SourceAccountingLine)actual.get(i);
                if (expectedItem.getFinancialObjectCode().equals(actualItem.getFinancialObjectCode()) && expectedItem.getAmount().equals((Object)actualItem.getAmount())) continue;
                return false;
            }
            return true;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append(this.expected);
        }
    }
}

