/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class GenerateEntriesReopenPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private PurchaseOrderDocument po;
    private PurchaseOrderItem item;
    private PurchaseOrderAccount accountingLine1;
    private PurchaseOrderAccount accountingLine2;
    private PurapAccountingService purapAccountingService;
    private GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private BusinessObjectService businessObjectService;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.purapAccountingService = (PurapAccountingService)EasyMock.createMock(PurapAccountingService.class);
        this.purapGeneralLedgerService.setPurapAccountingService(this.purapAccountingService);
        this.generalLedgerPendingEntryService = (GeneralLedgerPendingEntryService)EasyMock.createMock(GeneralLedgerPendingEntryService.class);
        this.purapGeneralLedgerService.setGeneralLedgerPendingEntryService(this.generalLedgerPendingEntryService);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.purapGeneralLedgerService.setBusinessObjectService(this.businessObjectService);
        this.po = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        this.item = (PurchaseOrderItem)EasyMock.createMock(PurchaseOrderItem.class);
        this.accountingLine1 = (PurchaseOrderAccount)EasyMock.createMock(PurchaseOrderAccount.class);
        this.accountingLine2 = (PurchaseOrderAccount)EasyMock.createMock(PurchaseOrderAccount.class);
    }

    private void execute() {
        EasyMock.replay((Object[])new Object[]{this.po, this.item, this.accountingLine1, this.accountingLine2, this.purapAccountingService, this.generalLedgerPendingEntryService, this.businessObjectService});
        this.purapGeneralLedgerService.generateEntriesReopenPurchaseOrder(this.po);
        EasyMock.verify((Object[])new Object[]{this.po, this.item, this.accountingLine1, this.accountingLine2, this.purapAccountingService, this.generalLedgerPendingEntryService, this.businessObjectService});
    }

    private void baseExpectations(List<PurApItem> items, List<PurApItem> activeItems, List<SourceAccountingLine> sourceAccountingLines) {
        EasyMock.expect((Object)this.po.getItems()).andReturn(items).anyTimes();
        EasyMock.expect((Object)this.po.getItemsActiveOnly()).andReturn(activeItems).anyTimes();
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(activeItems)).andReturn(sourceAccountingLines);
        this.po.setGlOnlySourceAccountingLines(sourceAccountingLines);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.po.getGlOnlySourceAccountingLines()).andReturn(sourceAccountingLines).anyTimes();
    }

    private void mockQuantityBasedItem(PurchaseOrderItem item, int original, int invoiced, double unitPrice) {
        int remaining = original - invoiced;
        double outstandingAmount = unitPrice * (double)remaining;
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        EasyMock.expect((Object)item.getItemType()).andReturn((Object)itemType).anyTimes();
        EasyMock.expect((Object)item.getItemQuantity()).andReturn((Object)new KualiDecimal(original)).anyTimes();
        EasyMock.expect((Object)item.getItemInvoicedTotalQuantity()).andReturn((Object)new KualiDecimal(invoiced)).anyTimes();
        item.setItemOutstandingEncumberedQuantity(new KualiDecimal(remaining));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)item.getItemOutstandingEncumberedQuantity()).andReturn((Object)new KualiDecimal(remaining)).anyTimes();
        EasyMock.expect((Object)item.getItemUnitPrice()).andReturn((Object)new BigDecimal(unitPrice)).anyTimes();
        item.setItemOutstandingEncumberedAmount(new KualiDecimal(outstandingAmount));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)item.getItemOutstandingEncumberedAmount()).andReturn((Object)new KualiDecimal(outstandingAmount)).anyTimes();
        EasyMock.expect((Object)item.getItemLineNumber()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)item.isItemActiveIndicator()).andReturn((Object)true).anyTimes();
    }

    private void mockAmountBasedItem(PurchaseOrderItem item, double total, double invoiced) {
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(false);
        EasyMock.expect((Object)item.getItemType()).andReturn((Object)itemType).anyTimes();
        EasyMock.expect((Object)item.getTotalAmount()).andReturn((Object)new KualiDecimal(total)).anyTimes();
        EasyMock.expect((Object)item.getItemInvoicedTotalAmount()).andReturn((Object)new KualiDecimal(invoiced));
        item.setItemOutstandingEncumberedAmount(new KualiDecimal(total - invoiced));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)item.getItemOutstandingEncumberedAmount()).andReturn((Object)new KualiDecimal(total - invoiced)).anyTimes();
        EasyMock.expect((Object)item.getItemLineNumber()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)item.isItemActiveIndicator()).andReturn((Object)true).anyTimes();
    }

    private PurchaseOrderAccount mockAccountingLine(PurchaseOrderAccount accountingLine, double percent, double amount, Double altAmount) {
        EasyMock.expect((Object)accountingLine.getAccountLinePercent()).andReturn((Object)new BigDecimal(percent)).anyTimes();
        accountingLine.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(amount));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)accountingLine.isEmpty()).andReturn((Object)false).anyTimes();
        accountingLine.setAlternateAmountForGLEntryCreation(new KualiDecimal(amount));
        EasyMock.expectLastCall();
        if (altAmount == null) {
            EasyMock.expect((Object)accountingLine.getAlternateAmountForGLEntryCreation()).andReturn((Object)new KualiDecimal(amount)).anyTimes();
        } else {
            EasyMock.expect((Object)accountingLine.getAlternateAmountForGLEntryCreation()).andReturn((Object)new KualiDecimal(amount));
            accountingLine.setAlternateAmountForGLEntryCreation(new KualiDecimal(altAmount.doubleValue()));
            EasyMock.expectLastCall();
            EasyMock.expect((Object)accountingLine.getAlternateAmountForGLEntryCreation()).andReturn((Object)new KualiDecimal(altAmount.doubleValue())).anyTimes();
        }
        EasyMock.expect((Object)accountingLine.compareTo(EasyMock.isA(PurchaseOrderAccount.class))).andReturn((Object)0).anyTimes();
        return accountingLine;
    }

    @Test
    public void testNoItems() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(items, items, sourceAccountingLines);
        this.execute();
    }

    @Test
    public void testQuantityBasedItem() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        this.mockQuantityBasedItem(this.item, 7, 4, 10.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(this.mockAccountingLine(this.accountingLine1, 100.0, 30.0, 30.0));
        EasyMock.expect((Object)this.item.getSourceAccountingLines()).andReturn(sourceAccountingLines).anyTimes();
        items.add((PurApItem)this.item);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(items, items, glOnlySourceAccountingLines);
        this.execute();
    }

    @Test
    public void testAmountBasedItem() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        this.mockAmountBasedItem(this.item, 70.0, 40.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(this.mockAccountingLine(this.accountingLine1, 100.0, 30.0, 30.0));
        EasyMock.expect((Object)this.item.getSourceAccountingLines()).andReturn(sourceAccountingLines).anyTimes();
        items.add((PurApItem)this.item);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(items, items, glOnlySourceAccountingLines);
        this.execute();
    }

    @Test
    public void testMultipleAccountingLines() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        this.mockAmountBasedItem(this.item, 70.0, 30.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(this.mockAccountingLine(this.accountingLine1, 66.66, 26.66, null));
        sourceAccountingLines.add(this.mockAccountingLine(this.accountingLine2, 33.33, 13.33, 13.34));
        EasyMock.expect((Object)this.item.getSourceAccountingLines()).andReturn(sourceAccountingLines).anyTimes();
        items.add((PurApItem)this.item);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(items, items, glOnlySourceAccountingLines);
        this.execute();
    }

    @Test
    public void testShouldNotCreateGlPEs() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        EasyMock.expect((Object)this.accountingLine1.getAmount()).andReturn((Object)KualiDecimal.ZERO);
        sourceAccountingLines.add((SourceAccountingLine)this.accountingLine1);
        this.baseExpectations(items, items, sourceAccountingLines);
        this.execute();
    }

    @Test
    public void testShouldCreateGLPEs() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        EasyMock.expect((Object)this.accountingLine1.getAmount()).andReturn((Object)new KualiDecimal(100.0));
        sourceAccountingLines.add((SourceAccountingLine)this.accountingLine1);
        this.baseExpectations(items, items, sourceAccountingLines);
        EasyMock.expect((Object)this.generalLedgerPendingEntryService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.po)).andReturn((Object)true);
        ArrayList glpes = new ArrayList();
        EasyMock.expect((Object)this.po.getGeneralLedgerPendingEntries()).andReturn(glpes);
        EasyMock.expect((Object)this.businessObjectService.save(glpes)).andReturn(null);
        this.execute();
    }
}

