/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.TestSubject;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.authorization.PaymentRequestDocumentPresentationController;
import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.AdHocRevoke;
import org.kuali.rice.kew.api.action.AdHocToGroup;
import org.kuali.rice.kew.api.action.AdHocToPrincipal;
import org.kuali.rice.kew.api.action.MovePoint;
import org.kuali.rice.kew.api.action.RequestedActions;
import org.kuali.rice.kew.api.action.ReturnPoint;
import org.kuali.rice.kew.api.action.ValidActions;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;

@RunWith(value=EasyMockRunner.class)
public class PaymentRequestDocumentPresentationControllerTest {
    @TestSubject
    PaymentRequestDocumentPresentationController preqDocPresentationController = new PaymentRequestDocumentPresentationController();
    @Mock
    private static PaymentRequestDocument preq;
    @Mock
    private static DocumentHeader docHeader;

    @BeforeClass
    public static void setUp() throws Exception {
        preq = (PaymentRequestDocument)EasyMock.createMock(PaymentRequestDocument.class);
        docHeader = (DocumentHeader)EasyMock.createMock(DocumentHeader.class);
    }

    @Test
    public void testAddACHSignupInfoModeWhenPREQInFinalState() {
        this.createPREQMock(DocumentStatus.FINAL);
        HashSet editModes = new HashSet();
        this.preqDocPresentationController.addACHSignUpInfoMode((Document)preq, editModes);
        Assert.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    public void testAddACHSignupInfoModeWhenPREQInProcessedState() throws Exception {
        this.createPREQMock(DocumentStatus.PROCESSED);
        HashSet editModes = new HashSet();
        this.preqDocPresentationController.addACHSignUpInfoMode((Document)preq, editModes);
        Assert.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    public void testAddACHSignupInfoModeWhenPREQInDisapprovedState() throws Exception {
        this.createPREQMock(DocumentStatus.DISAPPROVED);
        HashSet editModes = new HashSet();
        this.preqDocPresentationController.addACHSignUpInfoMode((Document)preq, editModes);
        Assert.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    public void testAddACHSignupInfoModeWhenPREQInEnrouteState() throws Exception {
        this.createPREQMock(DocumentStatus.ENROUTE);
        HashSet editModes = new HashSet();
        this.preqDocPresentationController.addACHSignUpInfoMode((Document)preq, editModes);
        Assert.assertTrue((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    private void createPREQMock(DocumentStatus status) {
        StubWorkflowDocument workflowDocument = new StubWorkflowDocument();
        workflowDocument.setDocumentStatus(status);
        EasyMock.expect((Object)docHeader.getWorkflowDocument()).andReturn((Object)workflowDocument);
        EasyMock.replay((Object[])new Object[]{docHeader});
        EasyMock.expect((Object)preq.getDocumentHeader()).andReturn((Object)docHeader);
        EasyMock.replay((Object[])new Object[]{preq});
    }

    public final class StubWorkflowDocument
    implements WorkflowDocument {
        private DocumentStatus documentStatus;

        public void setDocumentStatus(DocumentStatus status) {
            this.documentStatus = status;
        }

        public String getDocumentId() {
            return null;
        }

        public DocumentStatus getStatus() {
            return this.documentStatus;
        }

        public DateTime getDateCreated() {
            return null;
        }

        public DateTime getDateLastModified() {
            return null;
        }

        public DateTime getDateApproved() {
            return null;
        }

        public DateTime getDateFinalized() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public String getApplicationDocumentId() {
            return null;
        }

        public String getInitiatorPrincipalId() {
            return null;
        }

        public String getRoutedByPrincipalId() {
            return null;
        }

        public String getDocumentTypeName() {
            return null;
        }

        public String getDocumentTypeId() {
            return null;
        }

        public String getDocumentHandlerUrl() {
            return null;
        }

        public String getApplicationDocumentStatus() {
            return null;
        }

        public DateTime getApplicationDocumentStatusDate() {
            return null;
        }

        public Map<String, String> getVariables() {
            return null;
        }

        public String getPrincipalId() {
            return null;
        }

        public void switchPrincipal(String principalId) {
        }

        public org.kuali.rice.kew.api.document.Document getDocument() {
            return null;
        }

        public DocumentContent getDocumentContent() {
            return null;
        }

        public String getApplicationContent() {
            return null;
        }

        public void setTitle(String title) {
        }

        public void setApplicationDocumentId(String applicationDocumentId) {
        }

        public void setApplicationDocumentStatus(String applicationDocumentStatus) {
        }

        public void setApplicationContent(String applicationContent) {
        }

        public void setAttributeContent(String attributeContent) {
        }

        public void clearAttributeContent() {
        }

        public String getAttributeContent() {
            return null;
        }

        public void addAttributeDefinition(WorkflowAttributeDefinition attributeDefinition) {
        }

        public void removeAttributeDefinition(WorkflowAttributeDefinition attributeDefinition) {
        }

        public void clearAttributeDefinitions() {
        }

        public List<WorkflowAttributeDefinition> getAttributeDefinitions() {
            return null;
        }

        public void setSearchableContent(String searchableContent) {
        }

        public void addSearchableDefinition(WorkflowAttributeDefinition searchableDefinition) {
        }

        public void removeSearchableDefinition(WorkflowAttributeDefinition searchableDefinition) {
        }

        public void clearSearchableDefinitions() {
        }

        public void clearSearchableContent() {
        }

        public List<WorkflowAttributeDefinition> getSearchableDefinitions() {
            return null;
        }

        public void setVariable(String name, String value) {
        }

        public String getVariableValue(String name) {
            return null;
        }

        public void setReceiveFutureRequests() {
        }

        public void setDoNotReceiveFutureRequests() {
        }

        public void setClearFutureRequests() {
        }

        public String getReceiveFutureRequestsValue() {
            return null;
        }

        public String getDoNotReceiveFutureRequestsValue() {
            return null;
        }

        public String getClearFutureRequestsValue() {
            return null;
        }

        public List<? extends RemotableAttributeErrorContract> validateAttributeDefinition(WorkflowAttributeDefinition attributeDefinition) {
            return null;
        }

        public List<ActionRequest> getRootActionRequests() {
            return null;
        }

        public List<ActionTaken> getActionsTaken() {
            return null;
        }

        public ValidActions getValidActions() {
            return null;
        }

        public RequestedActions getRequestedActions() {
            return null;
        }

        public void saveDocument(String annotation) {
        }

        public void route(String annotation) {
        }

        public void complete(String annotation) {
        }

        public void disapprove(String annotation) {
        }

        public void approve(String annotation) {
        }

        public void cancel(String annotation) {
        }

        public void recall(String annotation, boolean cancel) {
        }

        public void blanketApprove(String annotation) {
        }

        public void blanketApprove(String annotation, String ... nodeNames) {
        }

        public void saveDocumentData() {
        }

        public void acknowledge(String annotation) {
        }

        public void fyi(String annotation) {
        }

        public void fyi() {
        }

        public void delete() {
        }

        public void refresh() {
        }

        public void adHocToPrincipal(ActionRequestType actionRequested, String annotation, String targetPrincipalId, String responsibilityDescription, boolean forceAction) {
        }

        public void adHocToPrincipal(ActionRequestType actionRequested, String nodeName, String annotation, String targetPrincipalId, String responsibilityDescription, boolean forceAction) {
        }

        public void adHocToPrincipal(ActionRequestType actionRequested, String nodeName, String annotation, String targetPrincipalId, String responsibilityDescription, boolean forceAction, String requestLabel) {
        }

        public void adHocToPrincipal(AdHocToPrincipal adHocToPrincipal, String annotation) {
        }

        public void adHocToGroup(ActionRequestType actionRequested, String annotation, String targetGroupId, String responsibilityDescription, boolean forceAction) {
        }

        public void adHocToGroup(ActionRequestType actionRequested, String nodeName, String annotation, String targetGroupId, String responsibilityDescription, boolean forceAction) {
        }

        public void adHocToGroup(ActionRequestType actionRequested, String nodeName, String annotation, String targetGroupId, String responsibilityDescription, boolean forceAction, String requestLabel) {
        }

        public void adHocToGroup(AdHocToGroup adHocToGroup, String annotation) {
        }

        public void revokeAdHocRequestById(String actionRequestId, String annotation) {
        }

        public void revokeAdHocRequests(AdHocRevoke revoke, String annotation) {
        }

        public void revokeAllAdHocRequests(String annotation) {
        }

        public void returnToPreviousNode(String annotation, String nodeName) {
        }

        public void returnToPreviousNode(String annotation, ReturnPoint returnPoint) {
        }

        public void move(MovePoint movePoint, String annotation) {
        }

        public void takeGroupAuthority(String annotation, String groupId) {
        }

        public void releaseGroupAuthority(String annotation, String groupId) {
        }

        public void placeInExceptionRouting(String annotation) {
        }

        public void superUserBlanketApprove(String annotation) {
        }

        public void superUserNodeApprove(String nodeName, String annotation) {
        }

        public void superUserTakeRequestedAction(String actionRequestId, String annotation) {
        }

        public void superUserDisapprove(String annotation) {
        }

        public void superUserCancel(String annotation) {
        }

        public void superUserReturnToPreviousNode(ReturnPoint returnPoint, String annotation) {
        }

        public void logAnnotation(String annotation) {
        }

        public boolean isCompletionRequested() {
            return false;
        }

        public boolean isApprovalRequested() {
            return false;
        }

        public boolean isAcknowledgeRequested() {
            return false;
        }

        public boolean isFYIRequested() {
            return false;
        }

        public boolean isBlanketApproveCapable() {
            return false;
        }

        public boolean isRouteCapable() {
            return false;
        }

        public boolean isValidAction(ActionType actionType) {
            return false;
        }

        public boolean checkStatus(DocumentStatus status) {
            return false;
        }

        public boolean isInitiated() {
            return false;
        }

        public boolean isSaved() {
            return false;
        }

        public boolean isEnroute() {
            return this.documentStatus == DocumentStatus.ENROUTE;
        }

        public boolean isException() {
            return false;
        }

        public boolean isCanceled() {
            return false;
        }

        public boolean isRecalled() {
            return false;
        }

        public boolean isDisapproved() {
            return this.documentStatus == DocumentStatus.DISAPPROVED;
        }

        public boolean isApproved() {
            return this.isProcessed() || this.isFinal();
        }

        public boolean isProcessed() {
            return this.documentStatus == DocumentStatus.PROCESSED;
        }

        public boolean isFinal() {
            return this.documentStatus == DocumentStatus.FINAL;
        }

        public Set<String> getNodeNames() {
            return null;
        }

        public Set<String> getSimpleNodeNames() {
            return null;
        }

        public Set<String> getCurrentNodeNames() {
            return null;
        }

        public Set<String> getCurrentSimpleNodeNames() {
            return null;
        }

        public List<RouteNodeInstance> getActiveRouteNodeInstances() {
            return null;
        }

        public List<RouteNodeInstance> getCurrentRouteNodeInstances() {
            return null;
        }

        public List<RouteNodeInstance> getRouteNodeInstances() {
            return null;
        }

        public List<String> getPreviousNodeNames() {
            return null;
        }

        public DocumentDetail getDocumentDetail() {
            return null;
        }

        public void updateDocumentContent(DocumentContentUpdate documentContentUpdate) {
        }
    }
}

