/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class GenerateEntriesCancelCreditMemoTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private VendorCreditMemoDocument cm;
    private PurchaseOrderDocument po;
    private PaymentRequestDocument preq;
    private PurapAccountingService purapAccountingService;
    private GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private BusinessObjectService businessObjectService;
    private PurchaseOrderService purchaseOrderService;
    private PurapAccountRevisionService purapAccountRevisionService;
    private List<CreditMemoItem> cmItems;
    private List<PurchaseOrderItem> poItems;
    private List<Object> dynamicMocks;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.purapAccountingService = (PurapAccountingService)EasyMock.createMock(PurapAccountingService.class);
        this.purapGeneralLedgerService.setPurapAccountingService(this.purapAccountingService);
        this.generalLedgerPendingEntryService = (GeneralLedgerPendingEntryService)EasyMock.createMock(GeneralLedgerPendingEntryService.class);
        this.purapGeneralLedgerService.setGeneralLedgerPendingEntryService(this.generalLedgerPendingEntryService);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.purapGeneralLedgerService.setBusinessObjectService(this.businessObjectService);
        this.purchaseOrderService = (PurchaseOrderService)EasyMock.createMock(PurchaseOrderService.class);
        this.purapGeneralLedgerService.setPurchaseOrderService(this.purchaseOrderService);
        this.purapAccountRevisionService = (PurapAccountRevisionService)EasyMock.createMock(PurapAccountRevisionService.class);
        this.purapGeneralLedgerService.setPurapAccountRevisionService(this.purapAccountRevisionService);
        this.cm = (VendorCreditMemoDocument)EasyMock.createMock(VendorCreditMemoDocument.class);
        this.po = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        this.preq = (PaymentRequestDocument)EasyMock.createMock(PaymentRequestDocument.class);
        this.cmItems = new ArrayList<CreditMemoItem>();
        this.poItems = new ArrayList<PurchaseOrderItem>();
        this.dynamicMocks = new ArrayList<Object>();
    }

    private void execute() {
        EasyMock.replay((Object[])new Object[]{this.cm, this.po, this.preq, this.purapAccountingService, this.purchaseOrderService, this.generalLedgerPendingEntryService, this.businessObjectService, this.purapAccountRevisionService});
        for (Object mock : this.dynamicMocks) {
            EasyMock.replay((Object[])new Object[]{mock});
        }
        this.purapGeneralLedgerService.generateEntriesCancelAccountsPayableDocument((AccountsPayableDocument)this.cm);
        EasyMock.verify((Object[])new Object[]{this.cm, this.po, this.preq, this.purapAccountingService, this.purchaseOrderService, this.generalLedgerPendingEntryService, this.businessObjectService, this.purapAccountRevisionService});
        for (Object mock : this.dynamicMocks) {
            EasyMock.verify((Object[])new Object[]{mock});
        }
    }

    private void prepareCreditMemo(boolean poSource, boolean preqSource) {
        this.cm.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.cm.getDocumentNumber()).andReturn((Object)"1").anyTimes();
        EasyMock.expect((Object)this.cm.isSourceVendor()).andReturn((Object)(!poSource && !preqSource ? 1 : 0)).anyTimes();
        EasyMock.expect((Object)this.cm.getGeneralLedgerPendingEntries()).andReturn(new ArrayList()).anyTimes();
        EasyMock.expect((Object)this.cm.getItems()).andReturn(this.cmItems).anyTimes();
        EasyMock.expect((Object)this.cm.isSourceDocumentPurchaseOrder()).andReturn((Object)poSource).anyTimes();
        EasyMock.expect((Object)this.cm.isSourceDocumentPaymentRequest()).andReturn((Object)preqSource).anyTimes();
        EasyMock.expect((Object)this.cm.getPostingYearFromPendingGLEntries()).andReturn((Object)2015).anyTimes();
        EasyMock.expect((Object)this.cm.getPostingPeriodCodeFromPendingGLEntries()).andReturn((Object)"01").anyTimes();
    }

    private void prepareBusinessObjectService() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialSystemOriginationCode", "01");
        fieldValues.put("documentNumber", "1");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, fieldValues)).andReturn((Object)2);
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(null);
    }

    private void baseExpectations(boolean poSource, boolean preqSource, List<SummaryAccount> summaryAccounts) {
        this.prepareCreditMemo(poSource, preqSource);
        this.prepareBusinessObjectService();
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.cm)).andReturn(summaryAccounts);
    }

    private void preparePO(String status) {
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(1234))).andReturn((Object)this.po);
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)this.po)).andReturn((Object)this.po);
        EasyMock.expect((Object)this.po.getApplicationDocumentStatus()).andReturn((Object)status);
        EasyMock.expect((Object)this.po.getItems()).andReturn(this.poItems).anyTimes();
    }

    private CreditMemoItem createCmItem(int lineNumber, double totalAmount, double quantity, ItemType type) {
        CreditMemoItem item = (CreditMemoItem)EasyMock.createMock(CreditMemoItem.class);
        EasyMock.expect((Object)item.getItemLineNumber()).andReturn((Object)lineNumber).anyTimes();
        EasyMock.expect((Object)item.getItemType()).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)item.getItemTypeCode()).andReturn((Object)type.getItemTypeCode()).anyTimes();
        EasyMock.expect((Object)item.getTotalAmount()).andReturn((Object)new KualiDecimal(totalAmount)).anyTimes();
        EasyMock.expect((Object)item.getItemQuantity()).andReturn((Object)new KualiDecimal(quantity)).anyTimes();
        this.dynamicMocks.add(item);
        return item;
    }

    private PurchaseOrderItem createPoItem(int lineNumber, double quantity, double amount, double invoicedQuantity, double newInvoicedQuantity, double invoicedAmount, double newInvoicedAmount, double outstandingQuantity, double newOutstandingQuantity, double outstandingAmount, double newOutstandingAmount, double unitPrice, double taxAmount, ItemType type, List<PurApAccountingLine> sourceAccountingLines) {
        ArrayList<PurApAccountingLine> sourceAccountingLinesCopy = new ArrayList<PurApAccountingLine>();
        sourceAccountingLinesCopy.addAll(sourceAccountingLines);
        PurchaseOrderItem item = (PurchaseOrderItem)EasyMock.createMock(PurchaseOrderItem.class);
        EasyMock.expect((Object)item.getItemLineNumber()).andReturn((Object)lineNumber).anyTimes();
        EasyMock.expect((Object)item.getItemType()).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)item.getItemTypeCode()).andReturn((Object)type.getItemTypeCode()).anyTimes();
        EasyMock.expect((Object)item.getItemInvoicedTotalQuantity()).andReturn((Object)new KualiDecimal(invoicedQuantity)).anyTimes();
        EasyMock.expect((Object)item.getItemOutstandingEncumberedQuantity()).andReturn((Object)new KualiDecimal(outstandingQuantity)).anyTimes();
        EasyMock.expect((Object)item.getItemUnitPrice()).andReturn((Object)new BigDecimal(unitPrice)).anyTimes();
        EasyMock.expect((Object)item.getItemTaxAmount()).andReturn((Object)new KualiDecimal(taxAmount)).anyTimes();
        EasyMock.expect((Object)item.getItemQuantity()).andReturn((Object)new KualiDecimal(quantity)).anyTimes();
        EasyMock.expect((Object)item.getItemOutstandingEncumberedAmount()).andReturn((Object)new KualiDecimal(outstandingAmount)).anyTimes();
        EasyMock.expect((Object)item.getItemInvoicedTotalAmount()).andReturn((Object)new KualiDecimal(invoicedAmount)).anyTimes();
        EasyMock.expect((Object)item.getSourceAccountingLines()).andReturn(sourceAccountingLinesCopy).anyTimes();
        EasyMock.expect((Object)item.getTotalAmount()).andReturn((Object)new KualiDecimal(amount)).anyTimes();
        if (type.isQuantityBasedGeneralLedgerIndicator()) {
            item.setItemInvoicedTotalQuantity(new KualiDecimal(newInvoicedQuantity));
            EasyMock.expectLastCall();
            item.setItemOutstandingEncumberedQuantity(new KualiDecimal(newOutstandingQuantity));
            EasyMock.expectLastCall();
        }
        item.setItemOutstandingEncumberedAmount(new KualiDecimal(newOutstandingAmount));
        EasyMock.expectLastCall();
        item.setItemInvoicedTotalAmount(new KualiDecimal(newInvoicedAmount));
        EasyMock.expectLastCall();
        this.dynamicMocks.add(item);
        return item;
    }

    private PurchaseOrderAccount createPoAccountingLine(double percent, double outstandingAmount, double newOutstandingAmount, Double altAmount, String objectCode) {
        SourceAccountingLine acctString = new SourceAccountingLine();
        acctString.setFinancialObjectCode(objectCode);
        PurchaseOrderAccount account = (PurchaseOrderAccount)EasyMock.mock(PurchaseOrderAccount.class);
        EasyMock.expect((Object)account.isEmpty()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)account.getAccountLinePercent()).andReturn((Object)new BigDecimal(percent)).anyTimes();
        EasyMock.expect((Object)account.getItemAccountOutstandingEncumbranceAmount()).andReturn((Object)new KualiDecimal(outstandingAmount));
        EasyMock.expect((Object)account.generateSourceAccountingLine()).andReturn((Object)acctString).anyTimes();
        EasyMock.expect((Object)account.compareTo(EasyMock.isA(PurchaseOrderAccount.class))).andReturn((Object)0).anyTimes();
        account.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(newOutstandingAmount));
        EasyMock.expectLastCall();
        if (altAmount != null) {
            EasyMock.expect((Object)account.getItemAccountOutstandingEncumbranceAmount()).andReturn((Object)new KualiDecimal(newOutstandingAmount));
            account.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(altAmount.doubleValue()));
            EasyMock.expectLastCall();
        }
        this.dynamicMocks.add(account);
        return account;
    }

    private ItemType createItemType(String code, boolean lineItem, boolean quantityBased) {
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode(code);
        itemType.setQuantityBasedGeneralLedgerIndicator(quantityBased);
        itemType.setAdditionalChargeIndicator(!lineItem);
        return itemType;
    }

    private void prepareItem(int lineNumber, double cmAmount, double cmQuantity, double poAmount, double poQuantity, double invoicedQuantity, double newInvoicedQuantity, double invoicedAmount, double newInvoicedAmount, double outstandingQuantity, double newOutstandingQuantity, double outstandingAmount, double newOutstandingAmount, double unitPrice, double taxAmount, ItemType type, List<PurApAccountingLine> sourceAccountingLines) {
        this.cmItems.add(this.createCmItem(lineNumber, cmAmount, cmQuantity, type));
        this.poItems.add(this.createPoItem(lineNumber, poQuantity, poAmount, invoicedQuantity, newInvoicedQuantity, invoicedAmount, newInvoicedAmount, outstandingQuantity, newOutstandingQuantity, outstandingAmount, newOutstandingAmount, unitPrice, taxAmount, type, sourceAccountingLines));
    }

    private void prepareItemsNoAccountingLines() {
        ItemType lineItemQty = this.createItemType("LINEQ", true, true);
        ItemType lineItemAmt = this.createItemType("LINEA", true, false);
        ItemType addlItem = this.createItemType("ADDL", false, false);
        this.prepareItem(1, 2.5, 1.0, 10.0, 4.0, 1.0, 2.0, 2.5, 5.0, 3.0, 2.0, 7.5, 5.0, 2.5, 0.0, lineItemQty, new ArrayList<PurApAccountingLine>());
        this.prepareItem(2, 2.0, 0.0, 10.0, 0.0, 0.0, 0.0, 4.0, 6.0, 0.0, 0.0, 6.0, 4.0, 0.0, 0.0, lineItemAmt, new ArrayList<PurApAccountingLine>());
        this.prepareItem(3, 1.0, 0.0, 10.0, 0.0, 0.0, 0.0, 3.0, 4.0, 0.0, 0.0, 7.0, 6.0, 0.0, 0.0, addlItem, new ArrayList<PurApAccountingLine>());
        this.prepareItem(4, 2.0, 0.0, 10.0, 0.0, 0.0, 0.0, 4.0, 6.0, 0.0, 0.0, 6.0, 4.0, 0.0, 5.0, lineItemAmt, new ArrayList<PurApAccountingLine>());
        this.prepareItem(5, 2.5, 1.0, 10.0, 4.0, 1.0, 2.0, 2.5, 5.0, 3.0, 2.0, 7.8, 5.2, 2.5, 0.4, lineItemQty, new ArrayList<PurApAccountingLine>());
    }

    private void prepareItemsAccountingLines(boolean encumbranceOpen) {
        ItemType lineItemAmt = this.createItemType("LINEA", true, false);
        ArrayList<Object> sourceAccountingLines = new ArrayList<PurApAccountingLine>();
        sourceAccountingLines.add(this.createPoAccountingLine(100.0, 7000.0, 6000.0, 6000.0, "A"));
        this.prepareItem(1, 1000.0, 0.0, 10000.0, 0.0, 0.0, 0.0, 3000.0, 4000.0, 0.0, 0.0, 7000.0, 6000.0, 0.0, 0.0, lineItemAmt, sourceAccountingLines);
        sourceAccountingLines = new ArrayList();
        sourceAccountingLines.add((PurApAccountingLine)this.createPoAccountingLine(50.0, 3500.0, 3000.0, null, "B"));
        sourceAccountingLines.add(this.createPoAccountingLine(50.0, 3500.0, 3000.0, 3000.0, "C"));
        this.prepareItem(2, 1000.0, 0.0, 10000.0, 0.0, 0.0, 0.0, 3000.0, 4000.0, 0.0, 0.0, 7000.0, 6000.0, 0.0, 0.0, lineItemAmt, sourceAccountingLines);
        sourceAccountingLines = new ArrayList();
        sourceAccountingLines.add((PurApAccountingLine)this.createPoAccountingLine(66.66, 4666.2, 3999.6, null, "C"));
        sourceAccountingLines.add(this.createPoAccountingLine(33.33, 2333.8, 2000.5, 2000.4, "D"));
        this.prepareItem(3, 1000.0, 0.0, 10000.0, 0.0, 0.0, 0.0, 3000.0, 4000.0, 0.0, 0.0, 7000.0, 6000.0, 0.0, 0.0, lineItemAmt, sourceAccountingLines);
        if (encumbranceOpen) {
            SourceAccountingLine acctString1 = new SourceAccountingLine();
            acctString1.setFinancialObjectCode("A");
            acctString1.setAmount(new KualiDecimal(1000));
            SourceAccountingLine acctString2 = new SourceAccountingLine();
            acctString2.setFinancialObjectCode("B");
            acctString2.setAmount(new KualiDecimal(500));
            SourceAccountingLine acctString3 = new SourceAccountingLine();
            acctString3.setFinancialObjectCode("C");
            acctString3.setAmount(new KualiDecimal(1166.6));
            SourceAccountingLine acctString4 = new SourceAccountingLine();
            acctString4.setFinancialObjectCode("D");
            acctString4.setAmount(new KualiDecimal(333.4));
            EasyMock.expect((Object)this.cm.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)EasyMock.eq((Object)acctString1), (GeneralLedgerPendingEntrySequenceHelper)EasyMock.anyObject())).andReturn((Object)true);
            EasyMock.expect((Object)this.cm.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)EasyMock.eq((Object)acctString2), (GeneralLedgerPendingEntrySequenceHelper)EasyMock.anyObject())).andReturn((Object)true);
            EasyMock.expect((Object)this.cm.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)EasyMock.eq((Object)acctString3), (GeneralLedgerPendingEntrySequenceHelper)EasyMock.anyObject())).andReturn((Object)true);
            EasyMock.expect((Object)this.cm.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)EasyMock.eq((Object)acctString4), (GeneralLedgerPendingEntrySequenceHelper)EasyMock.anyObject())).andReturn((Object)true);
        }
    }

    @Test
    public void testBaseCase() {
        this.baseExpectations(false, false, null);
        this.execute();
    }

    @Test
    public void testClosedPONoItems() {
        this.baseExpectations(true, false, null);
        this.preparePO("Closed");
        EasyMock.expect((Object)this.cm.getPurchaseOrderIdentifier()).andReturn((Object)1234);
        this.execute();
    }

    @Test
    public void testClosedPOFromPreqNoItems() {
        this.baseExpectations(false, true, null);
        this.preparePO("Closed");
        EasyMock.expect((Object)this.cm.getPaymentRequestDocument()).andReturn((Object)this.preq);
        EasyMock.expect((Object)this.preq.getPurchaseOrderIdentifier()).andReturn((Object)1234);
        this.execute();
    }

    @Test
    public void testClosedPOWithItemsNoAccountingLines() {
        this.prepareItemsNoAccountingLines();
        this.baseExpectations(true, false, null);
        this.preparePO("Closed");
        EasyMock.expect((Object)this.cm.getPurchaseOrderIdentifier()).andReturn((Object)1234);
        this.execute();
    }

    @Test
    public void testOpenPOWithItemsNoAccountingLines() {
        this.prepareItemsNoAccountingLines();
        this.baseExpectations(true, false, null);
        this.preparePO("Open");
        EasyMock.expect((Object)this.cm.getPurchaseOrderIdentifier()).andReturn((Object)1234);
        this.cm.setGenerateEncumbranceEntries(true);
        EasyMock.expectLastCall();
        this.cm.setDebitCreditCodeForGLEntries("D");
        EasyMock.expectLastCall();
        this.execute();
    }

    @Test
    public void testClosedPOAccountingLines() {
        this.prepareItemsAccountingLines(false);
        this.baseExpectations(true, false, null);
        this.preparePO("Closed");
        EasyMock.expect((Object)this.cm.getPurchaseOrderIdentifier()).andReturn((Object)1234);
        this.execute();
    }

    @Test
    public void testOpenPOAccountingLines() {
        this.prepareItemsAccountingLines(true);
        this.baseExpectations(true, false, null);
        this.preparePO("Open");
        EasyMock.expect((Object)this.cm.getPurchaseOrderIdentifier()).andReturn((Object)1234);
        this.cm.setGenerateEncumbranceEntries(true);
        EasyMock.expectLastCall();
        this.cm.setDebitCreditCodeForGLEntries("D");
        EasyMock.expectLastCall();
        this.execute();
    }

    @Test
    public void testSummaryAccountHandling() {
        ArrayList<SummaryAccount> summaryAccounts = new ArrayList<SummaryAccount>();
        SummaryAccount summaryAccount = (SummaryAccount)EasyMock.createMock(SummaryAccount.class);
        SourceAccountingLine account = new SourceAccountingLine();
        EasyMock.expect((Object)summaryAccount.getAccount()).andReturn((Object)account);
        summaryAccounts.add(summaryAccount);
        this.dynamicMocks.add(summaryAccount);
        this.baseExpectations(false, false, summaryAccounts);
        this.cm.setGenerateEncumbranceEntries(false);
        EasyMock.expectLastCall();
        this.cm.setDebitCreditCodeForGLEntries("D");
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.cm.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)EasyMock.eq((Object)account), (GeneralLedgerPendingEntrySequenceHelper)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)this.purapAccountingService.generateUseTaxAccount((PurchasingAccountsPayableDocument)this.cm)).andReturn(new ArrayList());
        this.purapAccountRevisionService.cancelCreditMemoAccountRevisions(new ArrayList(), Integer.valueOf(2015), "01");
        EasyMock.expectLastCall();
        this.execute();
    }
}

