/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl.PurapGeneralLedgerTest;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
public class GenerateEntriesCancelPaymentRequestTest
extends PurapGeneralLedgerTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private PurchaseOrderService purchaseOrderService;
    private PurapAccountingService purapAccountingService;
    private BusinessObjectService businessObjectService;
    private PurapAccountRevisionService purapAccountRevisionService;
    private AccountService accountService;
    private PaymentRequestDocument paymentRequestDocument;
    private PurchaseOrderDocument purchaseOrderDocument;
    private DateTimeService dateTimeService;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.purchaseOrderService = (PurchaseOrderService)EasyMock.createMock(PurchaseOrderService.class);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.purapAccountingService = (PurapAccountingService)EasyMock.createMock(PurapAccountingService.class);
        this.purapAccountRevisionService = (PurapAccountRevisionService)EasyMock.createMock(PurapAccountRevisionService.class);
        this.purapGeneralLedgerService.setPurchaseOrderService(this.purchaseOrderService);
        this.purapGeneralLedgerService.setBusinessObjectService(this.businessObjectService);
        this.purapGeneralLedgerService.setPurapAccountingService(this.purapAccountingService);
        this.purapGeneralLedgerService.setPurapAccountRevisionService(this.purapAccountRevisionService);
        this.paymentRequestDocument = (PaymentRequestDocument)EasyMock.createMock(PaymentRequestDocument.class);
        this.purchaseOrderDocument = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        PowerMock.mockStatic(SpringContext.class);
        this.accountService = (AccountService)EasyMock.createMock(AccountService.class);
        this.dateTimeService = (DateTimeService)EasyMock.createMock(DateTimeService.class);
    }

    @Test
    public void testNoAccountingLines() {
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderIdentifier()).andReturn((Object)1000);
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(1000))).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)this.purchaseOrderDocument)).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1000");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)0);
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderDocument()).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purchaseOrderDocument.getApplicationDocumentStatus()).andReturn((Object)"Cancelled");
        this.paymentRequestDocument.setDebitCreditCodeForGLEntries("D");
        this.paymentRequestDocument.setGenerateEncumbranceEntries(true);
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesCancelAccountsPayableDocument((AccountsPayableDocument)this.paymentRequestDocument);
        this.verifyAll();
    }

    @Test
    public void testItems() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        PurApItem item1 = this.getPaymentRequestItem(this.paymentRequestDocument, 1, KDONE, new BigDecimal("100.00"), "ITEM");
        items.add(item1);
        ArrayList<PurchaseOrderAccount> lines = new ArrayList<PurchaseOrderAccount>();
        lines.add(this.getPurchaseOrderAccount(KDTWO, KDONE));
        item1.setSourceAccountingLines(lines);
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(items).times(1);
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderIdentifier()).andReturn((Object)1000);
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(1000))).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purchaseOrderDocument.getItems()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.isUseTaxIndicator()).andReturn((Object)false).times(2);
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)this.purchaseOrderDocument)).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1000");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)0);
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderDocument()).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purchaseOrderDocument.getApplicationDocumentStatus()).andReturn((Object)"Closed");
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesCancelAccountsPayableDocument((AccountsPayableDocument)this.paymentRequestDocument);
        this.verifyAll();
    }

    @Test
    public void testItemsAccountingLines() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        PurApItem item1 = this.getPaymentRequestItem(this.paymentRequestDocument, 1, KDONE, new BigDecimal("100.00"), "ITEM");
        items.add(item1);
        ArrayList<PurchaseOrderAccount> lines = new ArrayList<PurchaseOrderAccount>();
        lines.add(this.getPurchaseOrderAccount(KDTWO, KDONE));
        item1.setSourceAccountingLines(lines);
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(items).times(2);
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderIdentifier()).andReturn((Object)1000);
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(1000))).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purchaseOrderDocument.getItems()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.isUseTaxIndicator()).andReturn((Object)false).times(2);
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)this.purchaseOrderDocument)).andReturn((Object)this.purchaseOrderDocument);
        ArrayList<SummaryAccount> sas = new ArrayList<SummaryAccount>();
        SummaryAccount sa = new SummaryAccount();
        sa.setAccount(new SourceAccountingLine());
        sas.add(sa);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(sas);
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1000");
        this.paymentRequestDocument.setGenerateEncumbranceEntries(false);
        this.paymentRequestDocument.setDebitCreditCodeForGLEntries("C");
        EasyMock.expect((Object)this.paymentRequestDocument.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)EasyMock.anyObject(), (GeneralLedgerPendingEntrySequenceHelper)EasyMock.anyObject())).andReturn((Object)true);
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)1);
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderDocument()).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purchaseOrderDocument.getApplicationDocumentStatus()).andReturn((Object)"Closed");
        EasyMock.expect((Object)this.purapAccountingService.generateUseTaxAccount((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getPurapDocumentIdentifier()).andReturn((Object)1000);
        this.purapAccountingService.deleteSummaryAccounts(Integer.valueOf(1000), "PREQ");
        EasyMock.expect((Object)SpringContext.getBean(AccountService.class)).andReturn((Object)this.accountService);
        this.accountService.populateAccountingLineChartIfNeeded((AccountingLine)EasyMock.anyObject());
        EasyMock.expect((Object)SpringContext.getBean(DateTimeService.class)).andReturn((Object)this.dateTimeService);
        EasyMock.expect((Object)this.dateTimeService.getCurrentTimestamp()).andReturn((Object)this.getTestTimestamp());
        EasyMock.expect((Object)this.paymentRequestDocument.getPostingYearFromPendingGLEntries()).andReturn((Object)2016);
        EasyMock.expect((Object)this.paymentRequestDocument.getPostingPeriodCodeFromPendingGLEntries()).andReturn((Object)"01");
        EasyMock.expect((Object)this.businessObjectService.save((List)EasyMock.anyObject())).andReturn(null).times(2);
        this.purapAccountRevisionService.cancelPaymentRequestAccountRevisions((List)EasyMock.anyObject(), Integer.valueOf(EasyMock.anyInt()), EasyMock.anyString());
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesCancelAccountsPayableDocument((AccountsPayableDocument)this.paymentRequestDocument);
        this.verifyAll();
    }

    private Timestamp getTestTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        try {
            return new Timestamp(sdf.parse("20160701130000000").getTime());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Bad date string");
        }
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.paymentRequestDocument, this.purapAccountingService, this.businessObjectService, this.purapAccountRevisionService, this.purchaseOrderService, this.purchaseOrderDocument, this.accountService, this.dateTimeService});
        PowerMock.replay((Object[])new Object[]{SpringContext.class});
    }

    private void verifyAll() {
        EasyMock.verify((Object[])new Object[]{this.paymentRequestDocument, this.purapAccountingService, this.businessObjectService, this.purapAccountRevisionService, this.purchaseOrderService, this.purchaseOrderDocument, this.accountService, this.dateTimeService});
        PowerMock.verify((Object[])new Object[]{SpringContext.class});
    }
}

