/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl.PurapGeneralLedgerTest;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
public class GenerateEntriesCreatePaymentRequestTest
extends PurapGeneralLedgerTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private PurchaseOrderService purchaseOrderService;
    private PurapAccountingService purapAccountingService;
    private BusinessObjectService businessObjectService;
    private AccountService accountService;
    private PaymentRequestDocument paymentRequestDocument;
    private PurchaseOrderDocument purchaseOrderDocument;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.purchaseOrderService = (PurchaseOrderService)EasyMock.createMock(PurchaseOrderService.class);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.purapAccountingService = (PurapAccountingService)EasyMock.createMock(PurapAccountingService.class);
        this.purapGeneralLedgerService.setPurchaseOrderService(this.purchaseOrderService);
        this.purapGeneralLedgerService.setBusinessObjectService(this.businessObjectService);
        this.purapGeneralLedgerService.setPurapAccountingService(this.purapAccountingService);
        this.paymentRequestDocument = (PaymentRequestDocument)EasyMock.createMock(PaymentRequestDocument.class);
        this.purchaseOrderDocument = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        PowerMock.mockStatic(SpringContext.class);
        this.accountService = (AccountService)EasyMock.createMock(AccountService.class);
    }

    @Test
    public void testNoItems() {
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderIdentifier()).andReturn((Object)1000);
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(1000))).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)this.purchaseOrderDocument)).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)0);
        this.paymentRequestDocument.setDebitCreditCodeForGLEntries("C");
        this.paymentRequestDocument.setGenerateEncumbranceEntries(true);
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesCreatePaymentRequest(this.paymentRequestDocument);
        this.verifyAll();
    }

    @Test
    public void testItemsNoGLPEsNoAccountingLines() {
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderIdentifier()).andReturn((Object)1000);
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(1000))).andReturn((Object)this.purchaseOrderDocument);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 100, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 1, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 2, null, null, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 3, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 4, KDTWO, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 5, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 6, KDONE, BigDecimal.ZERO, "ITEM"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 7, KDONE, new BigDecimal("2.00"), "ITEM"));
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(preqItems);
        ArrayList<PurApItem> poItems = new ArrayList<PurApItem>();
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 1, null, null, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 2, KDONE, BigDecimal.ZERO, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 3, KDONE, BigDecimal.ZERO, null, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 4, KDONE, BigDecimal.ZERO, KDONE, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 5, KDTWO, BigDecimal.ZERO, KDONE, null, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 6, KDTWO, BigDecimal.ZERO, KDONE, KDONE, null, null, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 7, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "ITEM"));
        EasyMock.expect((Object)this.purchaseOrderDocument.getItems()).andReturn(poItems).times(8);
        EasyMock.expect((Object)this.paymentRequestDocument.isUseTaxIndicator()).andReturn((Object)false).times(7);
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)this.purchaseOrderDocument)).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)0);
        this.paymentRequestDocument.setDebitCreditCodeForGLEntries("C");
        this.paymentRequestDocument.setGenerateEncumbranceEntries(true);
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesCreatePaymentRequest(this.paymentRequestDocument);
        this.verifyAll();
    }

    @Test
    public void testItemsNoGLPEsNoAccountingLinesMisc() {
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderIdentifier()).andReturn((Object)1000);
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(1000))).andReturn((Object)this.purchaseOrderDocument);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 100, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 1, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 2, null, null, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 3, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 4, KDTWO, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 5, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 6, KDONE, BigDecimal.ZERO, "MISC"));
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 7, KDONE, new BigDecimal("2.00"), "MISC"));
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(preqItems);
        ArrayList<PurApItem> poItems = new ArrayList<PurApItem>();
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 1, null, null, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "ITEM"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 2, KDONE, BigDecimal.ZERO, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 3, KDONE, BigDecimal.ZERO, null, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 4, KDONE, BigDecimal.ZERO, KDONE, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 5, KDTWO, BigDecimal.ZERO, KDONE, null, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 6, KDTWO, BigDecimal.ZERO, KDONE, KDONE, KualiDecimal.ZERO, KualiDecimal.ZERO, "MISC"));
        poItems.add(this.getPurchaseOrderItem(this.purchaseOrderDocument, 7, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "MISC"));
        EasyMock.expect((Object)this.purchaseOrderDocument.getItems()).andReturn(poItems).times(8);
        EasyMock.expect((Object)this.paymentRequestDocument.isUseTaxIndicator()).andReturn((Object)false).times(8);
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)this.purchaseOrderDocument)).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)0);
        this.paymentRequestDocument.setDebitCreditCodeForGLEntries("C");
        this.paymentRequestDocument.setGenerateEncumbranceEntries(true);
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesCreatePaymentRequest(this.paymentRequestDocument);
        this.verifyAll();
    }

    @Test
    public void testItemsNoGLPEsAccountingLines() {
        EasyMock.expect((Object)this.paymentRequestDocument.getPurchaseOrderIdentifier()).andReturn((Object)1000);
        EasyMock.expect((Object)this.purchaseOrderService.getCurrentPurchaseOrder(Integer.valueOf(1000))).andReturn((Object)this.purchaseOrderDocument);
        ArrayList<PurApItem> preqItems = new ArrayList<PurApItem>();
        preqItems.add(this.getPaymentRequestItem(this.paymentRequestDocument, 1, KDONE, new BigDecimal("2.00"), "MISC"));
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(preqItems);
        ArrayList<PurchaseOrderItem> poItems = new ArrayList<PurchaseOrderItem>();
        PurchaseOrderItem poItem = (PurchaseOrderItem)this.getPurchaseOrderItem(this.purchaseOrderDocument, 1, KDTWO, BigDecimal.ONE, KDONE, KDONE, new KualiDecimal("0.50"), new KualiDecimal("0.75"), "MISC");
        ArrayList<PurchaseOrderAccount> als = new ArrayList<PurchaseOrderAccount>();
        als.add(this.getPurchaseOrderAccount(new KualiDecimal("10.00"), new KualiDecimal("5.00")));
        poItem.setSourceAccountingLines(als);
        poItems.add(poItem);
        EasyMock.expect((Object)SpringContext.getBean(AccountService.class)).andReturn((Object)this.accountService);
        this.accountService.populateAccountingLineChartIfNeeded((AccountingLine)EasyMock.anyObject());
        EasyMock.expect((Object)this.purchaseOrderDocument.getItems()).andReturn(poItems);
        EasyMock.expect((Object)this.paymentRequestDocument.isUseTaxIndicator()).andReturn((Object)false);
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)this.purchaseOrderDocument)).andReturn((Object)this.purchaseOrderDocument);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1111");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1111");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)0);
        this.paymentRequestDocument.setDebitCreditCodeForGLEntries("C");
        this.paymentRequestDocument.setGenerateEncumbranceEntries(true);
        EasyMock.expect((Object)this.paymentRequestDocument.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)EasyMock.anyObject(), (GeneralLedgerPendingEntrySequenceHelper)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesCreatePaymentRequest(this.paymentRequestDocument);
        this.verifyAll();
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.paymentRequestDocument, this.purchaseOrderService, this.purchaseOrderDocument, this.businessObjectService, this.purapAccountingService, this.accountService});
        PowerMock.replay((Object[])new Object[]{SpringContext.class});
    }

    private void verifyAll() {
        EasyMock.verify((Object[])new Object[]{this.paymentRequestDocument, this.purchaseOrderService, this.purchaseOrderDocument, this.businessObjectService, this.purapAccountingService, this.accountService});
        PowerMock.verify((Object[])new Object[]{SpringContext.class});
    }
}

