/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl.PurapGeneralLedgerTest;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;

public class GenerateEntriesModifyPaymentRequestTest
extends PurapGeneralLedgerTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private PurapAccountingService purapAccountingService;
    private BusinessObjectService businessObjectService;
    private PurapAccountRevisionService purapAccountRevisionService;
    private PaymentRequestDocument paymentRequestDocument;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.purapAccountingService = (PurapAccountingService)EasyMock.createMock(PurapAccountingService.class);
        this.purapAccountRevisionService = (PurapAccountRevisionService)EasyMock.createMock(PurapAccountRevisionService.class);
        this.purapGeneralLedgerService.setBusinessObjectService(this.businessObjectService);
        this.purapGeneralLedgerService.setPurapAccountingService(this.purapAccountingService);
        this.purapGeneralLedgerService.setPurapAccountRevisionService(this.purapAccountRevisionService);
        this.paymentRequestDocument = (PaymentRequestDocument)EasyMock.createMock(PaymentRequestDocument.class);
    }

    @Test
    public void testNoAccountingLines() {
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryWithNoZeroTotalsNoUseTax(new ArrayList())).andReturn(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getPurapDocumentIdentifier()).andReturn((Object)1000);
        EasyMock.expect((Object)this.purapAccountingService.getAccountsPayableSummaryAccounts(Integer.valueOf(1000), "PREQ")).andReturn(new ArrayList());
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1000");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)0);
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesModifyPaymentRequest(this.paymentRequestDocument);
        this.verifyAll();
    }

    @Test
    public void testAccountingLines() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        PurApItem item1 = this.getPaymentRequestItem(this.paymentRequestDocument, 1, KDONE, new BigDecimal("100.00"), "ITEM");
        items.add(item1);
        ArrayList<PurchaseOrderAccount> lines = new ArrayList<PurchaseOrderAccount>();
        lines.add(this.getPurchaseOrderAccount(KDTWO, KDONE));
        item1.setSourceAccountingLines(lines);
        EasyMock.expect((Object)this.paymentRequestDocument.getItems()).andReturn(items).times(2);
        ArrayList<PurchaseOrderAccount> salines = new ArrayList<PurchaseOrderAccount>();
        salines.add(this.getPurchaseOrderAccount(KDTWO, KDONE));
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryWithNoZeroTotalsNoUseTax(items)).andReturn(salines);
        EasyMock.expect((Object)this.paymentRequestDocument.getPurapDocumentIdentifier()).andReturn((Object)1000).times(2);
        EasyMock.expect((Object)this.purapAccountingService.getAccountsPayableSummaryAccounts(Integer.valueOf(1000), "PREQ")).andReturn(new ArrayList());
        this.paymentRequestDocument.setGeneralLedgerPendingEntries(new ArrayList());
        EasyMock.expect((Object)this.paymentRequestDocument.getDocumentNumber()).andReturn((Object)"1000");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        EasyMock.expect((Object)this.businessObjectService.countMatching(GeneralLedgerPendingEntry.class, matcher)).andReturn((Object)0);
        this.paymentRequestDocument.setGenerateEncumbranceEntries(false);
        this.paymentRequestDocument.setDebitCreditCodeForGLEntries("D");
        EasyMock.expect((Object)this.paymentRequestDocument.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)EasyMock.anyObject(), (GeneralLedgerPendingEntrySequenceHelper)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)this.purapAccountingService.generateUseTaxAccount((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocument)).andReturn(new ArrayList());
        this.purapAccountingService.deleteSummaryAccounts(Integer.valueOf(1000), "PREQ");
        EasyMock.expect((Object)this.businessObjectService.save(new ArrayList())).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)this.paymentRequestDocument.getPostingYearFromPendingGLEntries()).andReturn((Object)2016);
        EasyMock.expect((Object)this.paymentRequestDocument.getPostingPeriodCodeFromPendingGLEntries()).andReturn((Object)"01");
        this.purapAccountRevisionService.savePaymentRequestAccountRevisions((List)EasyMock.anyObject(), Integer.valueOf(EasyMock.anyInt()), EasyMock.anyString());
        EasyMock.expect((Object)this.paymentRequestDocument.getGeneralLedgerPendingEntries()).andReturn(new ArrayList());
        this.replayAll();
        this.purapGeneralLedgerService.generateEntriesModifyPaymentRequest(this.paymentRequestDocument);
        this.verifyAll();
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.paymentRequestDocument, this.purapAccountingService, this.businessObjectService, this.purapAccountRevisionService});
    }

    private void verifyAll() {
        EasyMock.verify((Object[])new Object[]{this.paymentRequestDocument, this.purapAccountingService, this.businessObjectService, this.purapAccountRevisionService});
    }
}

