/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import java.sql.Date;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.fixture.PurapTestConstants;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum CreditMemoInitTabFixture {
    WITH_INVOICE_WITH_DATE_WITH_AMOUNT("123456789", PurapTestConstants.PREQInvoice.INVOICE_DATE, PurapTestConstants.PREQInvoice.AMOUNT),
    NO_INVOICE_WITH_DATE_WITH_AMOUNT(null, PurapTestConstants.PREQInvoice.INVOICE_DATE, PurapTestConstants.PREQInvoice.AMOUNT),
    WITH_INVOICE_NO_DATE_WITH_AMOUNT("123456789", null, PurapTestConstants.PREQInvoice.AMOUNT),
    WITH_INVOICE_WITH_DATE_NO_AMOUNT("123456789", PurapTestConstants.PREQInvoice.INVOICE_DATE, null),
    WITH_VENDOR_NUMBER("1000-0"),
    HI_AMOUNT_LO_TOTAL(PurapTestConstants.CMInit.HIGH_AMOUNT, PurapTestConstants.CMInit.LOW_AMOUNT),
    LO_AMOUNT_HI_TOTAL(PurapTestConstants.CMInit.LOW_AMOUNT, PurapTestConstants.CMInit.HIGH_AMOUNT),
    HI_AMOUNT_HI_TOTAL(PurapTestConstants.CMInit.HIGH_AMOUNT, PurapTestConstants.CMInit.HIGH_AMOUNT),
    HI_AMOUNT_ZERO_TOTAL(PurapTestConstants.CMInit.HIGH_AMOUNT, PurapTestConstants.CMInit.ZERO_AMOUNT);

    private String invoice_num;
    private Date invoice_date;
    private KualiDecimal amount;
    private String vendor_num;
    private KualiDecimal total;

    private CreditMemoInitTabFixture(String invoice_num, Date invoice_date, KualiDecimal amount) {
        this.invoice_num = invoice_num;
        this.invoice_date = invoice_date;
        this.amount = amount;
    }

    private CreditMemoInitTabFixture(String vendor_num) {
        this.vendor_num = vendor_num;
    }

    private CreditMemoInitTabFixture(KualiDecimal amount, KualiDecimal total) {
        this.amount = amount;
        this.total = total;
    }

    public VendorCreditMemoDocument populateForRequiredness(VendorCreditMemoDocument cmDocument) {
        cmDocument.setCreditMemoNumber(this.invoice_num);
        cmDocument.setCreditMemoDate(this.invoice_date);
        cmDocument.setCreditMemoAmount(this.amount);
        return cmDocument;
    }

    public VendorCreditMemoDocument populateForReferenceNumbers(VendorCreditMemoDocument cmDocument) {
        cmDocument.setVendorNumber(this.vendor_num);
        return cmDocument;
    }

    public VendorCreditMemoDocument populateForAmounts(VendorCreditMemoDocument cmDocument) {
        cmDocument.setCreditMemoAmount(this.amount);
        cmDocument.setGrandTotal(this.total);
        return cmDocument;
    }
}

