/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service;

import java.io.File;
import java.io.FileWriter;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceInputFileType;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceStep;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoad;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.fixture.ElectronicInvoiceHelperServiceFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceHelperService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.dataaccess.UnitTestSqlDao;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.kew.api.document.DocumentStatus;

@ConfigureContext
public class ElectronicInvoiceHelperServiceTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(ElectronicInvoiceHelperServiceTest.class);
    private ElectronicInvoiceInputFileType electronicInvoiceInputFileType;
    private UnitTestSqlDao unitTestSqlDao;

    protected void setUp() throws Exception {
        super.setUp();
        this.electronicInvoiceInputFileType = (ElectronicInvoiceInputFileType)SpringContext.getBean(ElectronicInvoiceInputFileType.class);
        TestUtils.setSystemParameter(ElectronicInvoiceStep.class, (String)"FILE_MOVE_AFTER_LOAD_IND", (String)"yes");
        FileUtils.cleanDirectory((File)new File(this.electronicInvoiceInputFileType.getDirectoryPath()));
        this.unitTestSqlDao = (UnitTestSqlDao)SpringContext.getBean(UnitTestSqlDao.class);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testNothing() {
    }

    @ConfigureContext(session=UserNameFixture.kfs, shouldCommitTransactions=true)
    public void PATCHFIX_testRejectDocumentCreationInvalidData() throws Exception {
        String rejectFile = "reject.xml";
        PurchaseOrderDocument poDocument = this.createPODoc(null);
        String vendorDUNS = poDocument.getVendorDetail().getVendorDunsNumber();
        String poNumber = poDocument.getPurapDocumentIdentifier().toString();
        String xmlChunk = ElectronicInvoiceHelperServiceFixture.getCXMLForRejectDocCreation(vendorDUNS, poNumber);
        this.writeXMLFile(xmlChunk, rejectFile);
        String schemaLocation = this.electronicInvoiceInputFileType.getSchemaLocation();
        int beginIndex = schemaLocation.indexOf("static");
        String newSchemaLocation = "https://test.kuali.org/kfs-reg/" + schemaLocation.substring(beginIndex);
        this.electronicInvoiceInputFileType.setSchemaLocation(newSchemaLocation);
        ElectronicInvoiceLoad load = ((ElectronicInvoiceHelperService)SpringContext.getBean(ElectronicInvoiceHelperService.class)).loadElectronicInvoices();
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)load.containsRejects());
        ElectronicInvoiceRejectDocument rejectDoc = (ElectronicInvoiceRejectDocument)load.getRejectDocuments().get(0);
        ElectronicInvoiceHelperServiceTest.assertNotNull((Object)rejectDoc);
        ElectronicInvoiceHelperServiceTest.assertEquals((String)rejectDoc.getInvoiceFileName(), (String)rejectFile);
        ElectronicInvoiceHelperServiceTest.assertEquals((int)5, (int)rejectDoc.getInvoiceRejectReasons().size());
        File rejectedFileInRejectDir = new File(this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator + "reject" + File.separator + rejectFile);
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)rejectedFileInRejectDir.exists());
    }

    @ConfigureContext(session=UserNameFixture.kfs, shouldCommitTransactions=true)
    public void PATCHFIX_testRejectDocumentCreationCorruptXML() throws Exception {
        String corruptFile = "corrupt.xml";
        PurchaseOrderDocument poDocument = this.createPODoc(null);
        String vendorDUNS = poDocument.getVendorDetail().getVendorDunsNumber();
        String poNumber = poDocument.getPurapDocumentIdentifier().toString();
        String xmlChunk = ElectronicInvoiceHelperServiceFixture.getCorruptedCXML(vendorDUNS, poNumber);
        this.writeXMLFile(xmlChunk, corruptFile);
        ElectronicInvoiceLoad load = ((ElectronicInvoiceHelperService)SpringContext.getBean(ElectronicInvoiceHelperService.class)).loadElectronicInvoices();
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)load.containsRejects());
        ElectronicInvoiceRejectDocument rejectDoc = (ElectronicInvoiceRejectDocument)load.getRejectDocuments().get(0);
        ElectronicInvoiceHelperServiceTest.assertNotNull((Object)rejectDoc);
        ElectronicInvoiceHelperServiceTest.assertEquals((String)rejectDoc.getInvoiceFileName(), (String)corruptFile);
        ElectronicInvoiceHelperServiceTest.assertEquals((int)1, (int)rejectDoc.getInvoiceRejectReasons().size());
        ElectronicInvoiceHelperServiceTest.assertEquals((String)"INFF", (String)((ElectronicInvoiceRejectReason)rejectDoc.getInvoiceRejectReasons().get(0)).getInvoiceRejectReasonTypeCode());
        File corruptedFileInRejectDir = new File(this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator + "reject" + File.separator + corruptFile);
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)corruptedFileInRejectDir.exists());
    }

    @ConfigureContext(session=UserNameFixture.kfs, shouldCommitTransactions=false)
    public void PATCHFIX_testPaymentRequestDocumentCreation() throws Exception {
        String acceptFile = "accept.xml";
        this.changeCurrentUser(UserNameFixture.khuntley);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
        AccountingDocumentTestUtils.testRouteDocument((FinancialSystemTransactionalDocument)reqDoc, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        Integer reqId = reqDoc.getPurapDocumentIdentifier();
        this.changeCurrentUser(UserNameFixture.kfs);
        PurchaseOrderDocument poDocument = this.createPODoc(reqId);
        String vendorDUNS = RandomUtils.nextInt() + "";
        if (StringUtils.isEmpty((CharSequence)poDocument.getVendorDetail().getVendorDunsNumber())) {
            VendorDetail vd = ((VendorService)SpringContext.getBean(VendorService.class)).getByVendorNumber(poDocument.getVendorNumber());
            vd.setVendorDunsNumber(vendorDUNS);
            ((VendorService)SpringContext.getBean(VendorService.class)).saveVendorHeader(vd);
        } else {
            vendorDUNS = poDocument.getVendorDetail().getVendorDunsNumber();
        }
        String poNumber = poDocument.getPurapDocumentIdentifier().toString();
        this.createItemMappingsRecords(poDocument.getVendorHeaderGeneratedIdentifier() + "", poDocument.getVendorDetailAssignedIdentifier() + "");
        this.updateUnitPriceVariance();
        String xmlChunk = ElectronicInvoiceHelperServiceFixture.getCXMLForPaymentDocCreation(vendorDUNS, poNumber);
        this.writeXMLFile(xmlChunk, acceptFile);
        ElectronicInvoiceLoad load = ((ElectronicInvoiceHelperService)SpringContext.getBean(ElectronicInvoiceHelperService.class)).loadElectronicInvoices();
        ElectronicInvoiceHelperServiceTest.assertFalse((boolean)load.containsRejects());
        File acceptedFileInAcceptDir = new File(this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator + "accept" + File.separator + acceptFile);
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)acceptedFileInAcceptDir.exists());
    }

    private PurchaseOrderDocument createPODoc(Integer reqId) throws Exception {
        PurchaseOrderDocument poDocument = PurchaseOrderDocumentFixture.EINVOICE_PO.createPurchaseOrderDocument();
        if (reqId != null) {
            poDocument.setRequisitionIdentifier(reqId);
        }
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        poDocument.prepareForSave();
        ElectronicInvoiceHelperServiceTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)poDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)poDocument, (String)"saving copy source document", null, (DocumentService)documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)poDocument.getDocumentNumber());
        ElectronicInvoiceHelperServiceTest.assertTrue((String)"Document should now be final.", (boolean)poDocument.getDocumentHeader().getWorkflowDocument().isFinal());
        return poDocument;
    }

    private void createItemMappingsRecords(String vendorHeaderGeneratedId, String vendorDetailAssignedId) {
        this.unitTestSqlDao.sqlCommand("truncate table AP_ELCTRNC_INV_MAP_T");
        this.createItemMappingsRecord("1", vendorHeaderGeneratedId, vendorDetailAssignedId, "ITEM", ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_ITEM);
        this.createItemMappingsRecord("2", vendorHeaderGeneratedId, vendorDetailAssignedId, "TAX", ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_TAX);
        this.createItemMappingsRecord("3", vendorHeaderGeneratedId, vendorDetailAssignedId, "SPHD", ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING);
        this.createItemMappingsRecord("4", vendorHeaderGeneratedId, vendorDetailAssignedId, "SHIP", ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SHIPPING);
        this.createItemMappingsRecord("5", vendorHeaderGeneratedId, vendorDetailAssignedId, "DISC", ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT);
    }

    private void createItemMappingsRecord(String invId, String vendorHeaderGeneratedIdentifier, String vendorDetailAssignedIdentifier, String invoiceItemTypeCode, String itemTypeCode) {
        String objId = UUID.randomUUID().toString();
        String sqlPart1 = "INSERT INTO AP_ELCTRNC_INV_MAP_T (AP_ELCTRNC_INV_MAP_ID,OBJ_ID,VER_NBR,VNDR_HDR_GNRTD_ID,VNDR_DTL_ASND_ID,INV_ITM_TYP_CD,ITM_TYP_CD) VALUES (";
        String sqlPart2 = invId + ",'" + objId + "',1," + vendorHeaderGeneratedIdentifier + "," + vendorDetailAssignedIdentifier + ",'" + invoiceItemTypeCode + "','" + itemTypeCode + "')";
        this.unitTestSqlDao.sqlCommand(sqlPart1 + sqlPart2);
    }

    private void updateUnitPriceVariance() {
        String query = "update PUR_PO_CST_SRC_T set ITM_UNIT_PRC_UPR_VAR_PCT=10,ITM_UNIT_PRC_LWR_VAR_PCT=10 where PO_CST_SRC_CD='EST'";
        this.unitTestSqlDao.sqlCommand(query);
    }

    private void writeXMLFile(String xmlChunk, String fileName) throws Exception {
        FileWriter fileWriter = new FileWriter(new File(this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator + fileName));
        fileWriter.write(xmlChunk);
        fileWriter.flush();
        fileWriter.close();
    }
}

