/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap;

import org.kuali.kfs.kns.question.QuestionBase;

import java.util.ArrayList;

/**
 * Support the SingleConfirmationQuestion that displays a window with an OK button.
 */
public class SingleConfirmationQuestion extends QuestionBase {

    public static final String OK = "0";

    public SingleConfirmationQuestion() {
        // this should be set by question form
        super("Confirmed", new ArrayList(1));
        this.getButtons().add("ok");
    }

}
