/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.impl.DocumentServiceImpl;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocumentTest;
import org.kuali.kfs.module.purap.document.CreditMemoDocumentTest;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocumentTest;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderCloseDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;

@ConfigureContext(session=UserNameFixture.khuntley)
public class PurapFullProcessDocumentTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(DocumentServiceImpl.class);
    private static final String SUB_ACCOUNT_REVIEW = "SubAccount";
    private static final String ACCOUNT_REVIEW = "Account";
    private static final String ORG_REVIEW = "AccountingOrganizationHierarchy";
    protected static DocumentService documentService = null;

    protected void setUp() throws Exception {
        documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    public void testNothing() {
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void PATCHFIX_testFullProcess() throws Exception {
        ContractManagerAssignmentDocumentTest acmDocTest = new ContractManagerAssignmentDocumentTest();
        String reqNumber = acmDocTest.testRouteDocument2();
        RequisitionDocument reqDoc = (RequisitionDocument)documentService.getByDocumentHeaderId(reqNumber);
        String poNumber = ((PurchaseOrderView)reqDoc.getRelatedViews().getRelatedPurchaseOrderViews().get(0)).getDocumentNumber();
        PurchaseOrderDocument poDoc = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(poNumber);
        poDoc.setReceivingDocumentRequiredIndicator(false);
        poDoc.setPurchaseOrderVendorChoiceCode("LPRC");
        documentService.routeDocument((Document)poDoc, "Test routing as parke", null);
        poDoc = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(poNumber);
        PaymentRequestDocument preqDoc = this.routePREQDocumentToFinal(poDoc);
        this.changeCurrentUser(UserNameFixture.appleton);
        CreditMemoDocumentTest cmDocTest = new CreditMemoDocumentTest();
        VendorCreditMemoDocument cmDoc = cmDocTest.routeDocument(preqDoc);
        this.changeCurrentUser(UserNameFixture.parke);
        PurchaseOrderAmendmentDocument amendDoc = (PurchaseOrderAmendmentDocument)((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).createAndSavePotentialChangeDocument(poNumber, "POA", "Pending Amendment");
        documentService.routeDocument((Document)amendDoc, "Test routing as parke", null);
        WorkflowTestUtils.waitForDocumentApproval((String)amendDoc.getDocumentNumber());
        this.changeCurrentUser(UserNameFixture.parke);
        PurchaseOrderCloseDocument closeDoc = (PurchaseOrderCloseDocument)((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).createAndSavePotentialChangeDocument(poNumber, "POC", "Pending Close");
        documentService.routeDocument((Document)closeDoc, "Test routing as parke", null);
        WorkflowTestUtils.waitForDocumentApproval((String)closeDoc.getDocumentNumber());
        LOG.info((Object)("Requisition document: " + reqDoc.getDocumentNumber()));
        LOG.info((Object)("PO document: " + poDoc.getDocumentNumber()));
        LOG.info((Object)("PREQ document: " + preqDoc.getDocumentNumber()));
        LOG.info((Object)("CM document: " + cmDoc.getDocumentNumber()));
        LOG.info((Object)("Amend PO document: " + amendDoc.getDocumentNumber()));
        LOG.info((Object)("Close PO document: " + closeDoc.getDocumentNumber()));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final PaymentRequestDocument routePREQDocumentToFinal(PurchaseOrderDocument POdoc) throws Exception {
        PaymentRequestDocumentTest preqDocTest = new PaymentRequestDocumentTest();
        PaymentRequestDocument paymentRequestDocument = preqDocTest.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, POdoc, true, new KualiDecimal[]{new KualiDecimal(100)});
        String docId = paymentRequestDocument.getDocumentNumber();
        AccountingDocumentTestUtils.routeDocument((AccountingDocument)paymentRequestDocument, (DocumentService)documentService);
        WorkflowTestUtils.waitForNodeChange((WorkflowDocument)paymentRequestDocument.getDocumentHeader().getWorkflowDocument(), (String)ACCOUNT_REVIEW);
        this.changeCurrentUser(UserNameFixture.ferland);
        paymentRequestDocument = (PaymentRequestDocument)documentService.getByDocumentHeaderId(docId);
        PurapFullProcessDocumentTest.assertTrue((String)"At incorrect node.", (boolean)WorkflowTestUtils.isAtNode((Document)paymentRequestDocument, (String)ACCOUNT_REVIEW));
        PurapFullProcessDocumentTest.assertTrue((String)"Document should be enroute.", (boolean)paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isEnroute());
        PurapFullProcessDocumentTest.assertTrue((String)"ferland should have an approve request.", (boolean)paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
        documentService.approveDocument((Document)paymentRequestDocument, "Test approving as ferland", null);
        WorkflowTestUtils.waitForDocumentApproval((String)paymentRequestDocument.getDocumentNumber());
        paymentRequestDocument = (PaymentRequestDocument)documentService.getByDocumentHeaderId(docId);
        PurapFullProcessDocumentTest.assertTrue((String)"Document should now be final.", (boolean)paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isFinal());
        return paymentRequestDocument;
    }

    private UserNameFixture getInitialUserName() {
        return UserNameFixture.khuntley;
    }

    protected UserNameFixture getTestUserName() {
        return UserNameFixture.khuntley;
    }
}

