/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service;

import java.lang.reflect.Method;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocumentTest;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.dataaccess.PaymentRequestDao;
import org.kuali.kfs.module.purap.document.service.NegativePaymentRequestApprovalLimitService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.impl.PaymentRequestServiceImpl;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.appleton)
public class PaymentRequestServiceTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(PaymentRequestServiceTest.class);
    private DocumentService documentService;
    private KualiDecimal defaultMinimumLimit;
    private ParameterService parameterService;
    private NegativePaymentRequestApprovalLimitService npras;
    private PaymentRequestService paymentRequestService;
    private PaymentRequestDocumentTest preqDocTest;
    private PaymentRequestDao paymentRequestDao;

    public void setUp() throws Exception {
        super.setUp();
        if (null == this.documentService) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        if (null == this.parameterService) {
            this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
            String samt = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "DEFAULT_POS_APRVL_LMT");
            this.defaultMinimumLimit = new KualiDecimal(samt);
        }
        if (null == this.npras) {
            this.npras = (NegativePaymentRequestApprovalLimitService)SpringContext.getBean(NegativePaymentRequestApprovalLimitService.class);
        }
        if (null == this.paymentRequestService) {
            this.paymentRequestService = (PaymentRequestService)SpringContext.getBean(PaymentRequestService.class);
        }
        if (null == this.preqDocTest) {
            this.preqDocTest = new PaymentRequestDocumentTest();
        }
        if (null == this.paymentRequestDao) {
            this.paymentRequestDao = (PaymentRequestDao)SpringContext.getBean(PaymentRequestDao.class);
        }
    }

    private void cancelDocument(Document document) throws WorkflowException {
        this.documentService.cancelDocument(document, "testing complete");
    }

    private PaymentRequestDocument createBasicDocument() throws Exception {
        return this.createBasicDocument(this.preqDocTest.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, false));
    }

    private PaymentRequestDocument createBasicDocument(PurchaseOrderDocument po) throws Exception {
        PaymentRequestDocument preq = this.preqDocTest.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, po, true, new KualiDecimal[]{new KualiDecimal(100)});
        return preq;
    }

    public void testGetPaymentRequestDocNumberForAutoApprove() throws Exception {
        Date todayAtMidnight = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDateMidnight();
        PaymentRequestDocument preqShouldAutoApprove = this.createBasicDocument();
        preqShouldAutoApprove.setApplicationDocumentStatus("Awaiting Fiscal Officer Approval");
        preqShouldAutoApprove.setPaymentRequestPayDate(todayAtMidnight);
        this.documentService.saveDocument((Document)preqShouldAutoApprove);
        String docIdShouldAutoApprove = preqShouldAutoApprove.getDocumentNumber();
        PaymentRequestDocument preqShouldNotAutoApprove = this.createBasicDocument();
        preqShouldNotAutoApprove.setApplicationDocumentStatus("In Process");
        preqShouldNotAutoApprove.setPaymentRequestPayDate(todayAtMidnight);
        this.documentService.saveDocument((Document)preqShouldNotAutoApprove);
        String docIdShouldNotAutoApprove = preqShouldNotAutoApprove.getDocumentNumber();
        PaymentRequestServiceImpl prsi = new PaymentRequestServiceImpl();
        prsi.setDateTimeService((DateTimeService)SpringContext.getBean(DateTimeService.class));
        prsi.setPaymentRequestDao((PaymentRequestDao)SpringContext.getBean(PaymentRequestDao.class));
        Method method = PaymentRequestServiceImpl.class.getDeclaredMethod("getPaymentRequestDocNumberForAutoApprove", null);
        method.setAccessible(true);
        List docIds = (List)method.invoke((Object)prsi, null);
        PaymentRequestServiceTest.assertTrue((boolean)docIds.contains(docIdShouldAutoApprove));
        PaymentRequestServiceTest.assertTrue((!docIds.contains(docIdShouldNotAutoApprove) ? 1 : 0) != 0);
    }

    public void testGetPaymentRequestsByStatusAndPurchaseOrderId() throws Exception {
        Map result = this.paymentRequestService.getPaymentRequestsByStatusAndPurchaseOrderId("In Process", Integer.valueOf(0));
        PaymentRequestServiceTest.assertEquals((String)"N", (String)((String)result.get("hasInProcess")));
        PaymentRequestServiceTest.assertEquals((String)"N", (String)((String)result.get("checkInProcess")));
        PaymentRequestDocument preq2 = this.createBasicDocument();
        preq2.setApplicationDocumentStatus("In Process");
        this.documentService.saveDocument((Document)preq2);
        result = this.paymentRequestService.getPaymentRequestsByStatusAndPurchaseOrderId("In Process", preq2.getPurchaseOrderIdentifier());
        PaymentRequestServiceTest.assertEquals((String)"Y", (String)((String)result.get("hasInProcess")));
        PaymentRequestServiceTest.assertEquals((String)"N", (String)((String)result.get("checkInProcess")));
        PaymentRequestDocument preq1 = this.createBasicDocument(preq2.getPurchaseOrderDocument());
        preq1.setApplicationDocumentStatus("Awaiting Fiscal Officer Approval");
        this.documentService.saveDocument((Document)preq1);
        result = this.paymentRequestService.getPaymentRequestsByStatusAndPurchaseOrderId("In Process", preq2.getPurchaseOrderIdentifier());
        PaymentRequestServiceTest.assertEquals((String)"Y", (String)((String)result.get("hasInProcess")));
        PaymentRequestServiceTest.assertEquals((String)"Y", (String)((String)result.get("checkInProcess")));
        preq2.setApplicationDocumentStatus("Awaiting Fiscal Officer Approval");
        this.documentService.saveDocument((Document)preq2);
        result = this.paymentRequestService.getPaymentRequestsByStatusAndPurchaseOrderId("In Process", preq2.getPurchaseOrderIdentifier());
        PaymentRequestServiceTest.assertEquals((String)"N", (String)((String)result.get("hasInProcess")));
        PaymentRequestServiceTest.assertEquals((String)"Y", (String)((String)result.get("checkInProcess")));
    }
}

