/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.util.ThresholdCriteria;
import org.kuali.kfs.module.purap.util.ThresholdField;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.dataaccess.UnitTestSqlDao;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;

@ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=false)
public class ThresholdTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(ThresholdTest.class);
    private UnitTestSqlDao unitTestSqlDao;

    protected void setUp() throws Exception {
        super.setUp();
        this.unitTestSqlDao = (UnitTestSqlDao)SpringContext.getBean(UnitTestSqlDao.class);
    }

    private void insertThresholdRecord(Map<ThresholdField, Object> field2Values, KualiDecimal thresholdAmount) {
        this.unitTestSqlDao.sqlCommand("delete from PUR_THRSHLD_T");
        String objId = UUID.randomUUID().toString();
        StringBuffer sqlPart1 = new StringBuffer();
        StringBuffer sqlPart2 = new StringBuffer();
        sqlPart1.append("insert into PUR_THRSHLD_T(PUR_THRSHLD_ID,OBJ_ID,VER_NBR,DOBJ_MAINT_CD_ACTV_IND,PUR_THRSHLD_AMT");
        sqlPart2.append(" values(1,'" + objId + "',1,'Y'," + thresholdAmount.floatValue());
        for (ThresholdField field : ThresholdField.getEnumList()) {
            if (field2Values.get(field) == null) continue;
            sqlPart1.append("," + this.getDBColumnName(field));
            if (field2Values.get(field) instanceof Number) {
                sqlPart2.append("," + ((Number)field2Values.get(field)).floatValue());
                continue;
            }
            sqlPart2.append(",'" + field2Values.get(field) + "'");
        }
        sqlPart1.append(")");
        sqlPart2.append(")");
        sqlPart1.append(sqlPart2);
        this.unitTestSqlDao.sqlCommand(sqlPart1.toString());
    }

    public final void testReceivingRequiredFlagWithChart() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        this.checkReceivingFlagInPO(poDocument, map, true, ThresholdCriteria.CHART);
    }

    public final void testReceivingRequiredFlagWithChartNegTest() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        this.checkReceivingFlagInPO(poDocument, map, false, ThresholdCriteria.CHART);
    }

    public final void testReceivingRequiredFlagWithFund() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String accTypeCode = ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getAccountTypeCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.ACCOUNT_TYPE_CODE, accTypeCode);
        this.checkReceivingFlagInPO(poDocument, map, true, ThresholdCriteria.CHART_AND_ACCOUNTTYPE);
    }

    public final void testReceivingRequiredFlagWithFundNegativeTest() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String accTypeCode = ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getAccountTypeCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.ACCOUNT_TYPE_CODE, accTypeCode);
        this.checkReceivingFlagInPO(poDocument, map, false, ThresholdCriteria.CHART_AND_ACCOUNTTYPE);
    }

    public final void testReceivingRequiredFlagWithSubFund() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String subFundGroupCode = ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getSubFundGroupCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.SUBFUND_GROUP_CODE, subFundGroupCode);
        this.checkReceivingFlagInPO(poDocument, map, true, ThresholdCriteria.CHART_AND_SUBFUND);
    }

    public final void testReceivingRequiredFlagWithSubFundNegativeTest() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String subFundGroupCode = ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getSubFundGroupCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.SUBFUND_GROUP_CODE, subFundGroupCode);
        this.checkReceivingFlagInPO(poDocument, map, false, ThresholdCriteria.CHART_AND_SUBFUND);
    }

    public final void testReceivingRequiredFlagWithObjectCode() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String objectCode = ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getFinancialObjectCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.FINANCIAL_OBJECT_CODE, objectCode);
        this.checkReceivingFlagInPO(poDocument, map, true, ThresholdCriteria.CHART_AND_OBJECTCODE);
    }

    public final void testReceivingRequiredFlagWithObjectCodeNegativeTest() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String objectCode = ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getFinancialObjectCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.FINANCIAL_OBJECT_CODE, objectCode);
        this.checkReceivingFlagInPO(poDocument, map, false, ThresholdCriteria.CHART_AND_OBJECTCODE);
    }

    public final void testReceivingRequiredFlagWithOrgCode() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String orgCode = ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getOrganizationCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.ORGANIZATION_CODE, orgCode);
        this.checkReceivingFlagInPO(poDocument, map, true, ThresholdCriteria.CHART_AND_ORGANIZATIONCODE);
    }

    public final void testReceivingRequiredFlagWithOrgCodeNegativeTest() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String orgCode = ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getOrganizationCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.ORGANIZATION_CODE, orgCode);
        this.checkReceivingFlagInPO(poDocument, map, false, ThresholdCriteria.CHART_AND_ORGANIZATIONCODE);
    }

    public final void testReceivingRequiredFlagWithVendor() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        Integer vendorGeneratedId = poDocument.getVendorHeaderGeneratedIdentifier();
        Integer vendorAssignedId = poDocument.getVendorDetailAssignedIdentifier();
        HashMap<ThresholdField, Object> map = new HashMap<ThresholdField, Object>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.VENDOR_HEADER_GENERATED_ID, vendorGeneratedId);
        map.put(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID, vendorAssignedId);
        this.checkReceivingFlagInPO(poDocument, map, true, ThresholdCriteria.CHART_AND_VENDOR);
    }

    public final void testReceivingRequiredFlagWithVendorNegativeTest() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        Integer vendorGeneratedId = poDocument.getVendorHeaderGeneratedIdentifier();
        Integer vendorAssignedId = poDocument.getVendorDetailAssignedIdentifier();
        HashMap<ThresholdField, Object> map = new HashMap<ThresholdField, Object>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.VENDOR_HEADER_GENERATED_ID, vendorGeneratedId);
        map.put(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID, vendorAssignedId);
        this.checkReceivingFlagInPO(poDocument, map, false, ThresholdCriteria.CHART_AND_VENDOR);
    }

    public final void testReceivingRequiredFlagWithCommodityCode() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String commodityCode = ((PurchaseOrderItem)poDocument.getItem(0)).getPurchasingCommodityCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.COMMODITY_CODE, commodityCode);
        this.checkReceivingFlagInPO(poDocument, map, true, ThresholdCriteria.CHART_AND_COMMODITYCODE);
    }

    public final void testReceivingRequiredFlagWithCommodityCodeNegativeTest() throws Exception {
        PurchaseOrderDocument poDocument = this.buildSimplePODocument();
        String commodityCode = ((PurchaseOrderItem)poDocument.getItem(0)).getPurchasingCommodityCode();
        HashMap<ThresholdField, String> map = new HashMap<ThresholdField, String>();
        map.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, ((PurApAccountingLine)poDocument.getItem(0).getSourceAccountingLines().get(0)).getAccount().getChartOfAccountsCode());
        map.put(ThresholdField.COMMODITY_CODE, commodityCode);
        this.checkReceivingFlagInPO(poDocument, map, false, ThresholdCriteria.CHART_AND_COMMODITYCODE);
    }

    private void checkReceivingFlagInPO(PurchaseOrderDocument poDocument, Map thresholdCriteriaFieldValues, boolean isPositiveTest, ThresholdCriteria thresholdCriteria) throws Exception {
    }

    private PurchaseOrderDocument routePO(PurchaseOrderDocument poDocument) throws Exception {
        String docId = poDocument.getDocumentNumber();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        poDocument.prepareForSave();
        ThresholdTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)poDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)poDocument, (String)"saving copy source document", null, (DocumentService)documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)poDocument.getDocumentNumber());
        PurchaseOrderDocument result = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(docId);
        return result;
    }

    public PurchaseOrderDocument buildSimplePODocument() {
        PurchaseOrderDocument poDocument = PurchaseOrderDocumentFixture.PO_FOR_THRESHOLD_CHECK.createPurchaseOrderDocument();
        ThresholdTest.assertEquals((String)"PO should have only one item for Threshold test", (int)1, (int)poDocument.getItems().size());
        ThresholdTest.assertEquals((String)"PO Item should have only one account for Threshold test", (int)1, (int)poDocument.getItem(0).getSourceAccountingLines().size());
        return poDocument;
    }

    private String getDBColumnName(ThresholdField field) {
        if (field == ThresholdField.CHART_OF_ACCOUNTS_CODE) {
            return "FIN_COA_CD";
        }
        if (field == ThresholdField.ACCOUNT_TYPE_CODE) {
            return "ACCT_TYP_CD";
        }
        if (field == ThresholdField.SUBFUND_GROUP_CODE) {
            return "SUB_FUND_GRP_CD";
        }
        if (field == ThresholdField.FINANCIAL_OBJECT_CODE) {
            return "FIN_OBJECT_CD";
        }
        if (field == ThresholdField.ORGANIZATION_CODE) {
            return "ORG_CD";
        }
        if (field == ThresholdField.VENDOR_DETAIL_ASSIGNED_ID) {
            return "VNDR_DTL_ASND_ID";
        }
        if (field == ThresholdField.VENDOR_HEADER_GENERATED_ID) {
            return "VNDR_HDR_GNRTD_ID";
        }
        if (field == ThresholdField.COMMODITY_CODE) {
            return "PUR_COMM_CD";
        }
        return null;
    }
}

