/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Map;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.MaintenanceDocumentBase;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignmentDetail;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.validation.PurapRuleTestBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderAssignSensitiveDataValidation;
import org.kuali.kfs.module.purap.document.validation.impl.SensitiveDataRule;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.SensitiveDataFixture;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class SensitiveDataRuleTest
extends PurapRuleTestBase {
    private SensitiveDataRule sensitiveDataRule;
    private Map<String, GenericValidation> validations;
    PurchaseOrderDocument po;

    protected void setUp() throws Exception {
        super.setUp();
        this.sensitiveDataRule = new SensitiveDataRule();
        this.validations = SpringContext.getBeansOfType(GenericValidation.class);
        this.po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
    }

    private MaintenanceDocumentBase getMaintenanceDocument(SensitiveDataFixture oldSDFixture, SensitiveDataFixture newSDFixture) {
        MaintenanceDocumentBase doc = null;
        try {
            doc = (MaintenanceDocumentBase)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("PMSN");
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Document creation failed.");
        }
        doc.getDocumentHeader().setExplanation("JUnit test document");
        Maintainable oldObj = doc.getOldMaintainableObject();
        Maintainable newObj = doc.getNewMaintainableObject();
        oldObj.setBusinessObject((PersistableBusinessObject)oldSDFixture.getSensitiveDataBO());
        newObj.setBusinessObject((PersistableBusinessObject)newSDFixture.getSensitiveDataBO());
        return doc;
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public final void testAssignSensitiveDataReasonEmpty() {
        ArrayList<SensitiveData> sds = new ArrayList<SensitiveData>();
        sds.add(SensitiveDataFixture.SENSITIVE_DATA_ACTIVE.getSensitiveDataBO());
        PurchaseOrderAssignSensitiveDataValidation validation = (PurchaseOrderAssignSensitiveDataValidation)this.validations.get("PurchaseOrder-assignSensitiveDataValidation-test");
        validation.setAccountingDocumentForValidation(this.po);
        validation.setSensitiveDataAssignmentReason(null);
        validation.setSensitiveDatasAssigned(sds);
        SensitiveDataRuleTest.assertFalse((boolean)validation.validate(null));
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public final void testAssignSensitiveDataInactive() {
        ArrayList<SensitiveData> sds = new ArrayList<SensitiveData>();
        sds.add(SensitiveDataFixture.SENSITIVE_DATA_INACTIVE.getSensitiveDataBO());
        PurchaseOrderAssignSensitiveDataValidation validation = (PurchaseOrderAssignSensitiveDataValidation)this.validations.get("PurchaseOrder-assignSensitiveDataValidation-test");
        validation.setAccountingDocumentForValidation(this.po);
        validation.setSensitiveDatasAssigned(sds);
        SensitiveDataRuleTest.assertFalse((boolean)validation.validate(null));
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public final void testAssignSensitiveDataIDuplicate() {
        ArrayList<SensitiveData> sds = new ArrayList<SensitiveData>();
        sds.add(SensitiveDataFixture.SENSITIVE_DATA_ACTIVE.getSensitiveDataBO());
        sds.add(SensitiveDataFixture.SENSITIVE_DATA_ACTIVE.getSensitiveDataBO());
        PurchaseOrderAssignSensitiveDataValidation validation = (PurchaseOrderAssignSensitiveDataValidation)this.validations.get("PurchaseOrder-assignSensitiveDataValidation-test");
        validation.setAccountingDocumentForValidation(this.po);
        validation.setSensitiveDatasAssigned(sds);
        SensitiveDataRuleTest.assertFalse((boolean)validation.validate(null));
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public final void testSensitiveDataInactivationBlocking() {
        SensitiveData sdNew;
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        if (boService.retrieve((PersistableBusinessObject)(sdNew = SensitiveDataFixture.SENSITIVE_DATA_TO_INACTIVATE.getSensitiveDataBO())) == null) {
            boService.save((PersistableBusinessObject)sdNew);
        }
        ArrayList<SensitiveData> sds = new ArrayList<SensitiveData>();
        sds.add(sdNew);
        SensitiveDataService sdService = (SensitiveDataService)SpringContext.getBean(SensitiveDataService.class);
        Integer poId = this.po.getPurapDocumentIdentifier();
        if (poId == null) {
            poId = new Integer(1000);
        }
        Date currentDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        SensitiveDataAssignment sda = new SensitiveDataAssignment();
        sda.setPurapDocumentIdentifier(poId);
        sda.setSensitiveDataAssignmentReasonText("test");
        sda.setSensitiveDataAssignmentChangeDate((java.util.Date)currentDate);
        sda.setSensitiveDataAssignmentPersonIdentifier("parke");
        sdService.saveSensitiveDataAssignment(sda);
        Integer sdaId = sdService.getLastSensitiveDataAssignmentId(poId);
        ArrayList<SensitiveDataAssignmentDetail> sdads = new ArrayList<SensitiveDataAssignmentDetail>();
        for (SensitiveData sensitiveData : sds) {
            SensitiveDataAssignmentDetail sdad = new SensitiveDataAssignmentDetail();
            sdad.setSensitiveDataAssignmentIdentifier(sdaId);
            sdad.setSensitiveDataCode(sensitiveData.getSensitiveDataCode());
            sdads.add(sdad);
        }
        sdService.saveSensitiveDataAssignmentDetails(sdads);
        sdService.deletePurchaseOrderSensitiveDatas(poId);
        ArrayList<PurchaseOrderSensitiveData> posds = new ArrayList<PurchaseOrderSensitiveData>();
        for (SensitiveData sd : sds) {
            PurchaseOrderSensitiveData posd = new PurchaseOrderSensitiveData();
            posd.setPurapDocumentIdentifier(poId);
            posd.setRequisitionIdentifier(this.po.getRequisitionIdentifier());
            posd.setSensitiveDataCode(sd.getSensitiveDataCode());
            posds.add(posd);
        }
        sdService.deletePurchaseOrderSensitiveDatas(poId);
        sdService.savePurchaseOrderSensitiveDatas(posds);
        GlobalVariables.getUserSession().setBackdoorUser("khuntley");
        MaintenanceDocumentBase maintenanceDocumentBase = this.getMaintenanceDocument(SensitiveDataFixture.SENSITIVE_DATA_TO_INACTIVATE, SensitiveDataFixture.SENSITIVE_DATA_INACTIVATED);
        this.sensitiveDataRule.setupBaseConvenienceObjects((MaintenanceDocument)maintenanceDocumentBase);
        SensitiveDataRuleTest.assertFalse((boolean)this.sensitiveDataRule.processCustomRouteDocumentBusinessRules((MaintenanceDocument)maintenanceDocumentBase));
        SensitiveDataRuleTest.assertFalse((boolean)this.sensitiveDataRule.processCustomApproveDocumentBusinessRules((MaintenanceDocument)maintenanceDocumentBase));
        GlobalVariables.getUserSession().clearBackdoorUser();
    }
}

