/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.HashMap;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemState;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemType;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.web.struts.PurchaseOrderForm;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingActionBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingFormBase;
import org.kuali.kfs.module.purap.document.web.struts.RequisitionForm;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.mockito.Mockito;

@ConfigureContext(session=UserNameFixture.khuntley)
public class PurchasingActionBaseTest
extends KualiTestBase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPurchaseOrderRequiresCalculateSalesTaxDisabled() {
        PurchasingActionBase purchasingActionBase = new PurchasingActionBase();
        PurchasingFormBase purForm = this.setupPurchasingFormBase(false);
        TestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)"ENABLE_SALES_TAX_IND", (String)"N");
        PurchasingActionBaseTest.assertTrue((boolean)purchasingActionBase.requiresCalculate(purForm));
    }

    public void testPurchaseOrderRequiresCalculateSalesTaxEnabled() {
        PurchasingActionBase purchasingActionBase = new PurchasingActionBase();
        PurchasingFormBase purForm = this.setupPurchasingFormBase(false);
        TestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)"ENABLE_SALES_TAX_IND", (String)"Y");
        PurchasingActionBaseTest.assertTrue((boolean)purchasingActionBase.requiresCalculate(purForm));
    }

    public void testRequisitionRequiresCalculateSalesTaxDisabled() {
        PurchasingActionBase purchasingActionBase = new PurchasingActionBase();
        PurchasingFormBase purForm = this.setupPurchasingFormBase(true);
        TestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)"ENABLE_SALES_TAX_IND", (String)"N");
        PurchasingActionBaseTest.assertTrue((boolean)purchasingActionBase.requiresCalculate(purForm));
    }

    public void testRequisitionRequiresCalculateSalesTaxEnabled() {
        PurchasingActionBase purchasingActionBase = new PurchasingActionBase();
        PurchasingFormBase purForm = this.setupPurchasingFormBase(true);
        TestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)"ENABLE_SALES_TAX_IND", (String)"Y");
        PurchasingActionBaseTest.assertTrue((boolean)purchasingActionBase.requiresCalculate(purForm));
    }

    public void testValidateCapitalAssetSystemStateAllowed_success() {
        CapitalAssetSystemType capitalAssetSystemType = (CapitalAssetSystemType)Mockito.mock(CapitalAssetSystemType.class);
        CapitalAssetSystemState capitalAssetSystemState = (CapitalAssetSystemState)Mockito.mock(CapitalAssetSystemState.class);
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeCode()).thenReturn((Object)"IND");
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeDescription()).thenReturn((Object)"doesn't matter A");
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD;NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"MOD");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateDescription()).thenReturn((Object)"doesn't matter B");
        PurchasingActionBaseTest.assertTrue((boolean)PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState));
    }

    public void testValidateCapitalAssetSystemStateAllowed_failure_type_individual() {
        CapitalAssetSystemType capitalAssetSystemType = (CapitalAssetSystemType)Mockito.mock(CapitalAssetSystemType.class);
        CapitalAssetSystemState capitalAssetSystemState = (CapitalAssetSystemState)Mockito.mock(CapitalAssetSystemState.class);
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeCode()).thenReturn((Object)"IND");
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeDescription()).thenReturn((Object)"doesn't matter A");
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateDescription()).thenReturn((Object)"doesn't matter B");
        PurchasingActionBaseTest.assertFalse((boolean)PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState));
    }

    public void testValidateCapitalAssetSystemStateAllowed_failure_type_multiple() {
        CapitalAssetSystemType capitalAssetSystemType = (CapitalAssetSystemType)Mockito.mock(CapitalAssetSystemType.class);
        CapitalAssetSystemState capitalAssetSystemState = (CapitalAssetSystemState)Mockito.mock(CapitalAssetSystemState.class);
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeCode()).thenReturn((Object)"MUL");
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeDescription()).thenReturn((Object)"doesn't matter A");
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateDescription()).thenReturn((Object)"doesn't matter B");
        PurchasingActionBaseTest.assertFalse((boolean)PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState));
    }

    private PurchasingFormBase setupPurchasingFormBase(boolean isRequisition) {
        Object purForm = isRequisition ? new RequisitionForm() : new PurchaseOrderForm();
        HashMap<String, String> documentActions = new HashMap<String, String>();
        documentActions.put("canEdit", "true");
        purForm.setDocumentActions(documentActions);
        purForm.setCalculated(false);
        if (isRequisition) {
            RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_VALID.createRequisitionDocument();
            purForm.setDocument((Document)requisitionDocument);
        }
        return purForm;
    }
}

