/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.fixture.PurapAccountingServiceFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.kfs)
public class PurapAccountingServiceTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(PurapAccountingServiceTest.class);
    private PurapAccountingService purapAccountingService;
    private PurapService purapService;
    private ParameterService parameterService;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.purapAccountingService == null) {
            this.purapAccountingService = (PurapAccountingService)SpringContext.getBean(PurapAccountingService.class);
        }
        if (this.purapService == null) {
            this.purapService = (PurapService)SpringContext.getBean(PurapService.class);
        }
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void comparePercentages(List<PurApAccountingLine> distributedAccounts, List<BigDecimal> correctPercents) {
        for (int i = 0; i < distributedAccounts.size(); ++i) {
            PurApAccountingLine line = distributedAccounts.get(i);
            BigDecimal percent = line.getAccountLinePercent();
            PurapAccountingServiceTest.assertTrue((percent.floatValue() == correctPercents.get(i).floatValue() ? 1 : 0) != 0);
        }
    }

    public void testGenerateAccountDistributionForProration_OneAcctGood() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_ONE_ACCOUNT;
        List distributedAccounts = this.purapAccountingService.generateAccountDistributionForProration(fixture.getSourceAccountingLineList(), fixture.getTotalAmount(), fixture.getPercentScale(), fixture.getAccountClass());
        ArrayList<BigDecimal> correctPercents = new ArrayList<BigDecimal>();
        correctPercents.add(0, new BigDecimal("100"));
        PurapAccountingServiceTest.assertEquals((int)distributedAccounts.size(), (int)correctPercents.size());
        this.comparePercentages(distributedAccounts, correctPercents);
    }

    public void testGenerateAccountDistributionForProration_TwoAcctGood() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_TWO_ACCOUNTS;
        List distributedAccounts = this.purapAccountingService.generateAccountDistributionForProration(fixture.getSourceAccountingLineList(), fixture.getTotalAmount(), fixture.getPercentScale(), fixture.getAccountClass());
        ArrayList<BigDecimal> correctPercents = new ArrayList<BigDecimal>();
        correctPercents.add(0, new BigDecimal("50"));
        correctPercents.add(1, new BigDecimal("50"));
        PurapAccountingServiceTest.assertEquals((int)distributedAccounts.size(), (int)correctPercents.size());
        this.comparePercentages(distributedAccounts, correctPercents);
    }

    public void testGenerateAccountDistributionForProration_ThreeAccountGood() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_THIRDS;
        List distributedAccounts = this.purapAccountingService.generateAccountDistributionForProration(fixture.getSourceAccountingLineList(), fixture.getTotalAmount(), fixture.getPercentScale(), fixture.getAccountClass());
        ArrayList<BigDecimal> correctPercents = new ArrayList<BigDecimal>();
        correctPercents.add(0, new BigDecimal("33"));
        correctPercents.add(1, new BigDecimal("33"));
        correctPercents.add(2, new BigDecimal("34"));
        PurapAccountingServiceTest.assertEquals((int)distributedAccounts.size(), (int)correctPercents.size());
        this.comparePercentages(distributedAccounts, correctPercents);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public void testGenerateAccountDistributionForProrationWithZeroTotal_OneAcct() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_ONE_ACCOUNT_ZERO_TOTAL;
        PaymentRequestDocument preq = fixture.generatePaymentRequestDocument_OneItem();
        List distributedAccounts = null;
        try {
            distributedAccounts = this.purapAccountingService.generateAccountDistributionForProrationWithZeroTotal((PurchasingAccountsPayableDocument)preq);
        }
        catch (RuntimeException re) {
            PurapAccountingServiceTest.fail((String)re.toString());
        }
        ArrayList<BigDecimal> correctPercents = new ArrayList<BigDecimal>();
        correctPercents.add(0, new BigDecimal("100"));
        PurapAccountingServiceTest.assertEquals((int)distributedAccounts.size(), (int)correctPercents.size());
        this.comparePercentages(distributedAccounts, correctPercents);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public void testGenerateAccountDistributionForProrationWithZeroTotal_TwoAcct() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_TWO_ACCOUNTS_ZERO_TOTAL;
        PaymentRequestDocument preq = fixture.generatePaymentRequestDocument_OneItem();
        List distributedAccounts = null;
        try {
            distributedAccounts = this.purapAccountingService.generateAccountDistributionForProrationWithZeroTotal((PurchasingAccountsPayableDocument)preq);
        }
        catch (RuntimeException re) {
            PurapAccountingServiceTest.fail((String)re.toString());
        }
        ArrayList<BigDecimal> correctPercents = new ArrayList<BigDecimal>();
        correctPercents.add(0, new BigDecimal("50"));
        correctPercents.add(1, new BigDecimal("50"));
        PurapAccountingServiceTest.assertEquals((int)distributedAccounts.size(), (int)correctPercents.size());
        this.comparePercentages(distributedAccounts, correctPercents);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public void testGenerateAccountDistributionForProrationWithZeroTotal_ThreeAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_THIRDS_ZERO_TOTAL;
        PaymentRequestDocument preq = fixture.generatePaymentRequestDocument_OneItem();
        List distributedAccounts = null;
        try {
            distributedAccounts = this.purapAccountingService.generateAccountDistributionForProrationWithZeroTotal((PurchasingAccountsPayableDocument)preq);
        }
        catch (RuntimeException re) {
            PurapAccountingServiceTest.fail((String)re.toString());
        }
        ArrayList<BigDecimal> correctPercents = new ArrayList<BigDecimal>();
        correctPercents.add(0, new BigDecimal("33.33"));
        correctPercents.add(1, new BigDecimal("33.33"));
        correctPercents.add(2, new BigDecimal("33.34"));
        PurapAccountingServiceTest.assertEquals((int)distributedAccounts.size(), (int)correctPercents.size());
        this.comparePercentages(distributedAccounts, correctPercents);
    }

    private void makePerAccountComparisons(PurapAccountingServiceFixture fixture, PurchasingAccountsPayableDocument doc) {
        int itemCount = doc.getItems().size();
        List accounts = this.purapAccountingService.generateSummaryAccounts(doc);
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        PurapAccountingServiceTest.assertEquals((int)accounts.size(), (int)originalSourceAccounts.size());
        for (int i = 0; i < originalSourceAccounts.size(); ++i) {
            SummaryAccount account = (SummaryAccount)accounts.get(i);
            SourceAccountingLine sourceAccount = account.getAccount();
            this.compareSourceAccounts(sourceAccount, originalSourceAccounts.get(i));
            List summaryItems = account.getItems();
            PurapAccountingServiceTest.assertTrue((summaryItems.size() <= itemCount ? 1 : 0) != 0);
        }
    }

    private void compareSourceAccounts(SourceAccountingLine sourceAccount, SourceAccountingLine correctSourceAccount) {
        Map source = sourceAccount.getValuesMap();
        Map correct = correctSourceAccount.getValuesMap();
        PurapAccountingServiceTest.assertEquals(source.get("chartOfAccountsCode"), correct.get("chartOfAccountsCode"));
        PurapAccountingServiceTest.assertEquals(source.get("accountNumber"), correct.get("accountNumber"));
        PurapAccountingServiceTest.assertEquals(source.get("subAccountNumber"), correct.get("subAccountNumber"));
        PurapAccountingServiceTest.assertEquals(source.get("financialObjectCode"), correct.get("financialObjectCode"));
        PurapAccountingServiceTest.assertEquals(source.get("financialSubObjectCode"), correct.get("financialSubObjectCode"));
        PurapAccountingServiceTest.assertEquals(source.get("projectCode"), correct.get("projectCode"));
        PurapAccountingServiceTest.assertEquals(source.get("organizationReferenceId"), correct.get("organizationReferenceId"));
        PurapAccountingServiceTest.assertEquals(source.get("organizationDocumentNumber"), correct.get("organizationDocumentNumber"));
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testGenerateSummaryAccounts_OneRequisitionAccountOneItemWithPositiveTotal() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_PRORATION_ONE_ACCOUNT;
        RequisitionDocument doc = fixture.generateRequisitionDocument_OneItem();
        this.makePerAccountComparisons(fixture, (PurchasingAccountsPayableDocument)doc);
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testGenerateSummaryAccounts_OneRequisitionAccountTwoItemsWithPositiveTotal() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_PRORATION_ONE_ACCOUNT;
        RequisitionDocument doc = fixture.generateRequisitionDocument_TwoItems();
        this.makePerAccountComparisons(fixture, (PurchasingAccountsPayableDocument)doc);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public void testGenerateSummaryAccounts_OnePREQAccountOneItemWithPositiveTotal() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_ONE_ACCOUNT;
        PaymentRequestDocument doc = fixture.generatePaymentRequestDocument_OneItem();
        this.makePerAccountComparisons(fixture, (PurchasingAccountsPayableDocument)doc);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public void testGenerateSummaryAccounts_OnePREQAccountTwoItemsWithPositiveTotal() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_ONE_ACCOUNT;
        PaymentRequestDocument doc = fixture.generatePaymentRequestDocument_TwoItems();
        this.makePerAccountComparisons(fixture, (PurchasingAccountsPayableDocument)doc);
    }

    private void checkAccountConsolidation(List<SourceAccountingLine> sourceLines, List<SourceAccountingLine> originalSourceAccounts) {
        for (int i = 0; i < sourceLines.size(); ++i) {
            SourceAccountingLine originalSourceAccount = originalSourceAccounts.get(i);
            boolean containsOneAccount = false;
            for (SourceAccountingLine sourceAccount : sourceLines) {
                if (!StringUtils.equals((CharSequence)sourceAccount.getAccountNumber(), (CharSequence)originalSourceAccount.getAccountNumber())) continue;
                if (!containsOneAccount) {
                    containsOneAccount = true;
                    continue;
                }
                PurapAccountingServiceTest.fail();
            }
            PurapAccountingServiceTest.assertTrue((boolean)containsOneAccount);
        }
    }

    public void testGenerateSummary_OneItem_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_ONE_ITEM_ONE_ACCOUNT;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        List sourceLines = this.purapAccountingService.generateSummary(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummary_OneItem_TwoAccounts() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_ONE_ITEM_TWO_ACCOUNTS;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        List sourceLines = this.purapAccountingService.generateSummary(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummary_TwoItems_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_TWO_ITEMS_ONE_ACCOUNT;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        List sourceLines = this.purapAccountingService.generateSummary(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotals_OneItem_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_ONE_ITEM_ONE_ACCOUNT;
        PurchaseOrderDocument podoc = new PurchaseOrderDocument();
        for (PurApItem item : fixture.getItems()) {
            item.setPurapDocument((PurchasingAccountsPayableDocument)podoc);
        }
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotals(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotals_OneItem_TwoAccounts() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_ONE_ITEM_TWO_ACCOUNTS;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotals(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotals_TwoItems_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_TWO_ITEMS_ONE_ACCOUNT;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotals(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotalsNoUseTax_OneItem_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_ONE_ITEM_ONE_ACCOUNT;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        RequisitionDocumentFixture reqFixture = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS;
        RequisitionDocument req = reqFixture.createRequisitionDocument();
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        for (PurApItem item : items) {
            item.setPurapDocument((PurchasingAccountsPayableDocument)req);
        }
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotalsNoUseTax(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotalsNoUseTax_OneItem_TwoAccounts() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_ONE_ITEM_TWO_ACCOUNTS;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        RequisitionDocumentFixture reqFixture = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS;
        RequisitionDocument req = reqFixture.createRequisitionDocument();
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        for (PurApItem item : items) {
            item.setPurapDocument((PurchasingAccountsPayableDocument)req);
        }
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotalsNoUseTax(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotalsNoUseTax_TwoItems_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_TWO_ITEMS_ONE_ACCOUNT;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        RequisitionDocumentFixture reqFixture = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS;
        RequisitionDocument req = reqFixture.createRequisitionDocument();
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        for (PurApItem item : items) {
            item.setPurapDocument((PurchasingAccountsPayableDocument)req);
        }
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotalsNoUseTax(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotalsUsingAlternateAmount_OneItem_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_ONE_ITEM_ONE_ACCOUNT;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        RequisitionDocumentFixture reqFixture = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS;
        RequisitionDocument req = reqFixture.createRequisitionDocument();
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        for (PurApItem item : items) {
            item.setPurapDocument((PurchasingAccountsPayableDocument)req);
        }
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotalsUsingAlternateAmount_OneItem_TwoAccounts() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_ONE_ITEM_TWO_ACCOUNTS;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        RequisitionDocumentFixture reqFixture = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS;
        RequisitionDocument req = reqFixture.createRequisitionDocument();
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        for (PurApItem item : items) {
            item.setPurapDocument((PurchasingAccountsPayableDocument)req);
        }
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    public void testGenerateSummaryWithNoZeroTotalsUsingAlternateAmount_TwoItems_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_SUMMARY_TWO_ITEMS_ONE_ACCOUNT;
        List<SourceAccountingLine> originalSourceAccounts = fixture.getSourceAccountingLineList();
        List<PurApItem> items = fixture.getItems();
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        RequisitionDocumentFixture reqFixture = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS;
        RequisitionDocument req = reqFixture.createRequisitionDocument();
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        for (PurApItem item : items) {
            item.setPurapDocument((PurchasingAccountsPayableDocument)req);
        }
        List sourceLines = this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(items);
        PurapAccountingServiceTest.assertEquals((int)sourceLines.size(), (int)originalSourceAccounts.size());
        this.checkAccountConsolidation(sourceLines, originalSourceAccounts);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public void testUpdateAccountAmounts_BeforeFullEntry_PercentToAmount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_THIRDS;
        PaymentRequestDocument preq = fixture.generatePaymentRequestDocument_OneItem();
        this.purapAccountingService.updateAccountAmounts((PurchasingAccountsPayableDocument)preq);
        PurapAccountingServiceTest.assertFalse((boolean)((PurApItem)preq.getItems().get(0)).getTotalAmount().isZero());
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public void testUpdateAccountAmounts_BeforeFullEntry_AmountNotToPercent() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_THIRDS;
        PaymentRequestDocument preq = fixture.generatePaymentRequestDocument_OneItem();
        this.purapAccountingService.updateAccountAmounts((PurchasingAccountsPayableDocument)preq);
        PurApItem item = (PurApItem)preq.getItems().get(0);
        int i = 0;
        boolean orResult = false;
        for (PurApAccountingLine correctLine : fixture.getPurApAccountingLineList()) {
            PurApAccountingLine line = (PurApAccountingLine)item.getSourceAccountingLines().get(i++);
            if (line.getAccountLinePercent().equals(correctLine.getAccountLinePercent())) continue;
            orResult = true;
            break;
        }
        PurapAccountingServiceTest.assertFalse((boolean)orResult);
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public void testUpdateAccountAmounts_AfterFullEntry_AmountToPercent() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_THIRDS;
        PaymentRequestDocument preq = fixture.generatePaymentRequestDocument_OneItem();
        preq.setApplicationDocumentStatus("Department-Approved");
        this.purapAccountingService.updateAccountAmounts((PurchasingAccountsPayableDocument)preq);
        PurApItem item = (PurApItem)preq.getItems().get(0);
        int i = 0;
        for (PurApAccountingLine correctLine : fixture.getPurApAccountingLineList()) {
            PurApAccountingLine line = (PurApAccountingLine)item.getSourceAccountingLines().get(i++);
            PurapAccountingServiceTest.assertTrue((boolean)line.getAccountLinePercent().equals(correctLine.getAccountLinePercent()));
        }
    }

    @ConfigureContext(session=UserNameFixture.appleton)
    public void testUpdateAccountAmounts_AfterFullEntry_PercentNotToAmount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_THIRDS;
        PaymentRequestDocument preq = fixture.generatePaymentRequestDocument_OneItem();
        preq.setApplicationDocumentStatus("Department-Approved");
        ((PurApItem)preq.getItems().get(0)).setExtendedPrice(KualiDecimal.ZERO);
        this.purapAccountingService.updateAccountAmounts((PurchasingAccountsPayableDocument)preq);
        PurapAccountingServiceTest.assertTrue((boolean)((PurApItem)preq.getItems().get(0)).getTotalAmount().isZero());
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public void testUpdateItemAccountAmounts_OneAccount() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_PRORATION_ONE_ACCOUNT;
        RequisitionDocument req = fixture.generateRequisitionDocument_OneItem();
        RequisitionItem item = (RequisitionItem)req.getItems().get(0);
        KualiDecimal total = item.getTotalAmount();
        this.purapAccountingService.updateItemAccountAmounts((PurApItem)item);
        PurApAccountingLine line = (PurApAccountingLine)item.getSourceAccountingLines().get(0);
        PurapAccountingServiceTest.assertTrue((line.getAmount().compareTo((AbstractKualiDecimal)total) == 0 ? 1 : 0) != 0);
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public void testUpdateItemAccountAmounts_TwoAccounts() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_PRORATION_TWO_ACCOUNTS;
        RequisitionDocument req = fixture.generateRequisitionDocument_OneItem();
        RequisitionItem item = (RequisitionItem)req.getItems().get(0);
        KualiDecimal total = item.getTotalAmount();
        this.purapAccountingService.updateItemAccountAmounts((PurApItem)item);
        PurApAccountingLine line = (PurApAccountingLine)item.getSourceAccountingLines().get(0);
        PurapAccountingServiceTest.assertTrue((line.getAmount().compareTo(total.divide((AbstractKualiDecimal)new KualiDecimal(2))) == 0 ? 1 : 0) != 0);
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public void testUpdateItemAccountAmounts_ThreeAccounts() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_PRORATION_THIRDS;
        RequisitionDocument req = fixture.generateRequisitionDocument_OneItem();
        RequisitionItem item = (RequisitionItem)req.getItems().get(0);
        KualiDecimal total = item.getTotalAmount();
        this.purapAccountingService.updateItemAccountAmounts((PurApItem)item);
        PurApAccountingLine line1 = (PurApAccountingLine)item.getSourceAccountingLines().get(0);
        PurapAccountingServiceTest.assertTrue((line1.getAmount().compareTo(total.divide((AbstractKualiDecimal)new KualiDecimal(3))) == 0 ? 1 : 0) != 0);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public void testDeleteSummaryAccounts_PaymentRequest() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.PREQ_PRORATION_ONE_ACCOUNT;
        PaymentRequestDocument preq = fixture.generatePaymentRequestDocument_OneItem();
        List summaryAccounts = this.purapAccountingService.generateSummaryAccounts((PurchasingAccountsPayableDocument)preq);
        PurapAccountingServiceTest.assertNotNull((Object)summaryAccounts);
        this.purapAccountingService.deleteSummaryAccounts(preq.getPurapDocumentIdentifier(), "PREQ");
        PurapAccountingServiceTest.assertNull((Object)this.purapAccountingService.getAccountsPayableSummaryAccounts(preq.getPurapDocumentIdentifier(), "PREQ"));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public void testDeleteSummaryAccounts_CreditMemo() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.CREDIT_MEMO_ONE_ACCOUNT;
        VendorCreditMemoDocument vcm = fixture.generateVendorCreditMemoDocument_OneItem();
        List summaryAccounts = this.purapAccountingService.generateSummaryAccounts((PurchasingAccountsPayableDocument)vcm);
        PurapAccountingServiceTest.assertNotNull((Object)summaryAccounts);
        this.purapAccountingService.deleteSummaryAccounts(vcm.getPurapDocumentIdentifier(), "PREQ");
        PurapAccountingServiceTest.assertNull((Object)this.purapAccountingService.getAccountsPayableSummaryAccounts(vcm.getPurapDocumentIdentifier(), "PREQ"));
    }
}

