/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.document.service.impl.PurchasingAccountsPayableModuleServiceImpl;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PurchasingAccountsPayableModuleServiceImplTest {
    private static final Integer REQUISITION_IDENTIFIER = new Integer(12345);
    private static final String REQUISITION_INITIATOR = "mbaxter";
    private PurchasingAccountsPayableModuleServiceImpl cut = new PurchasingAccountsPayableModuleServiceImpl();
    @Mock
    private Document documentMock;
    @Mock
    private DocumentHeader documentHeaderMock;
    @Mock
    private PaymentRequestDocument paymentRequestDocumentMock;
    @Mock
    private PurchaseOrderDocument purchaseOrderDocumentMock;
    @Mock
    private RequisitionDocument requisitionDocumentMock;
    @Mock
    private RequisitionService requisitionSvcMock;
    @Mock
    private VendorCreditMemoDocument vendorCreditMemoDocumentMock;
    @Mock
    private WorkflowDocument workflowDocumentMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getRequisitionIdentifier()).thenReturn((Object)REQUISITION_IDENTIFIER);
        Mockito.when((Object)this.requisitionSvcMock.getRequisitionById(REQUISITION_IDENTIFIER)).thenReturn((Object)this.requisitionDocumentMock);
        Mockito.when((Object)this.requisitionDocumentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.workflowDocumentMock.getInitiatorPrincipalId()).thenReturn((Object)REQUISITION_INITIATOR);
        this.cut.setRequisitionService(this.requisitionSvcMock);
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_NoRelatedREQ() {
        Assert.assertNull((Object)this.cut.determineRelatedRequisitionInitiatorPrincipalId(this.documentMock));
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_PREQ_HasRelatedREQ() {
        String principalId = this.cut.determineRelatedRequisitionInitiatorPrincipalId((Document)this.paymentRequestDocumentMock);
        Assert.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_CM_HasRelatedREQ() {
        String principalId = this.cut.determineRelatedRequisitionInitiatorPrincipalId((Document)this.vendorCreditMemoDocumentMock);
        Assert.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_PO_HasRelatedREQ() {
        String principalId = this.cut.determineRelatedRequisitionInitiatorPrincipalId((Document)this.purchaseOrderDocumentMock);
        Assert.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_REQS_NoRelatedREQ() {
        Assert.assertNull((Object)this.cut.determineRelatedRequisitionInitiatorPrincipalId((Document)this.requisitionDocumentMock));
    }
}

