/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.math.BigDecimal;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.exception.ItemParserException;
import org.kuali.kfs.module.purap.util.ItemParser;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.util.AutoPopulatingList;

@ConfigureContext(session=UserNameFixture.parke)
public class ItemParserTest
extends KualiTestBase {
    PurchasingDocument purDoc;
    ItemParser parser;
    Class<? extends PurApItem> itemClass;
    String documentNumber;

    protected void setUp() throws Exception {
        super.setUp();
        this.purDoc = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument(RequisitionDocument.class);
        this.parser = this.purDoc.getItemParser();
        this.itemClass = this.purDoc.getItemClass();
        this.documentNumber = this.purDoc.getDocumentNumber();
    }

    private static void assertWrongPropertyNumber(ItemParserException e, int propertyNumber) {
        ItemParserTest.assertEquals((String)e.getErrorKey(), (String)"error.itemParser.wrongPropertyNumber");
        ItemParserTest.assertEquals((String)e.getErrorParameters()[1], (String)("" + propertyNumber));
    }

    private static void assertInvalidNumericValue(ItemParserException e, String propertyName, String propertyValue) {
        ItemParserTest.assertEquals((String)e.getErrorKey(), (String)"error.itemParser.itemProperty");
        String errorPath = "document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*";
        String errorKey = "error.itemParser.invalidNumericValue";
        ItemParserTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey(errorKey));
        AutoPopulatingList params = GlobalVariables.getMessageMap().getMessages(errorPath);
        for (int i = 0; i < params.size(); ++i) {
            ErrorMessage errmsg = (ErrorMessage)params.get(i);
            if (!errmsg.getErrorKey().equals(errorKey)) continue;
            ItemParserTest.assertEquals((String)errmsg.getMessageParameters()[0], (String)propertyValue);
            ItemParserTest.assertEquals((String)errmsg.getMessageParameters()[1], (String)propertyName);
        }
    }

    public void testParseQuantityReqItem() {
        String itemLine = "3,BX,123,,paper,6";
        try {
            PurApItem item = this.parser.parseItem(itemLine, this.itemClass, this.documentNumber);
            ItemParserTest.assertEquals((int)item.getItemQuantity().compareTo((AbstractKualiDecimal)new KualiDecimal(3)), (int)0);
            ItemParserTest.assertEquals((String)item.getItemUnitOfMeasureCode(), (String)"BX");
            ItemParserTest.assertEquals((String)item.getItemCatalogNumber(), (String)"123");
            ItemParserTest.assertEquals((String)item.getItemDescription(), (String)"paper");
            ItemParserTest.assertEquals((int)item.getItemUnitPrice().compareTo(new BigDecimal(6)), (int)0);
            ItemParserTest.assertEquals((String)item.getItemTypeCode(), (String)"ITEM");
            ItemParserTest.assertTrue((boolean)(item instanceof RequisitionItem));
            ItemParserTest.assertFalse((boolean)((RequisitionItem)item).isItemRestrictedIndicator());
        }
        catch (ItemParserException e) {
            ItemParserTest.fail((String)"Caught ItemParserException with valid quantity-driven requisition item.");
        }
    }

    public void testParseNonQuantityPOItem() throws Exception {
        this.purDoc = (PurchaseOrderDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument(PurchaseOrderDocument.class);
        this.parser = this.purDoc.getItemParser();
        this.itemClass = this.purDoc.getItemClass();
        this.documentNumber = this.purDoc.getDocumentNumber();
        String itemLine = ",,100,,cleaning service,50";
        try {
            PurApItem item = this.parser.parseItem(itemLine, this.itemClass, this.documentNumber);
            ItemParserTest.assertEquals((Object)item.getItemQuantity(), null);
            ItemParserTest.assertEquals((String)item.getItemUnitOfMeasureCode(), null);
            ItemParserTest.assertEquals((String)item.getItemCatalogNumber(), (String)"100");
            ItemParserTest.assertEquals((String)item.getItemDescription(), (String)"cleaning service");
            ItemParserTest.assertEquals((int)item.getItemUnitPrice().compareTo(new BigDecimal(50)), (int)0);
            ItemParserTest.assertEquals((String)item.getItemTypeCode(), (String)"SRVC");
            ItemParserTest.assertTrue((boolean)(item instanceof PurchaseOrderItem));
            ItemParserTest.assertEquals((String)((PurchaseOrderItem)item).getDocumentNumber(), (String)this.documentNumber);
        }
        catch (ItemParserException e) {
            ItemParserTest.fail((String)"Caught ItemParserException with valid nonquantity-driven purchase order item.");
        }
    }

    public void testParseWrongPropertyNumberItem() {
        PurApItem item;
        String itemLine;
        try {
            itemLine = "2.5,BX,123,,paper,5.99,blahblah";
            item = this.parser.parseItem(itemLine, this.itemClass, this.documentNumber);
            ItemParserTest.fail((String)"Fail to throw ItemParserException with extra item property fields.");
        }
        catch (ItemParserException e) {
            ItemParserTest.assertWrongPropertyNumber(e, 7);
        }
        try {
            itemLine = "BX,123,paper,,5.99";
            item = this.parser.parseItem(itemLine, this.itemClass, this.documentNumber);
            ItemParserTest.fail((String)"Fail to throw ItemParserException with missing item property fields.");
        }
        catch (ItemParserException e) {
            ItemParserTest.assertWrongPropertyNumber(e, 5);
        }
    }

    public void testParseInvalidNumericItem() {
        String itemLine = "2.5,BX,123,,paper,blahblah";
        try {
            PurApItem item = this.parser.parseItem(itemLine, this.itemClass, this.documentNumber);
            ItemParserTest.fail((String)"Fail to throw ItemParserException with invalid numeric values for item property fields.");
        }
        catch (ItemParserException e) {
            ItemParserTest.assertInvalidNumericValue(e, this.parser.getItemFormat()[5], "blahblah");
        }
    }
}

