/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on Mar 9, 2005
 *
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;

import java.util.LinkedHashMap;

public class ElectronicInvoiceRejectReason extends PersistableBusinessObjectBase {

    private Integer invoiceRejectReasonIdentifier;
    private Integer purapDocumentIdentifier;
    private String invoiceFileName;
    private String invoiceRejectReasonTypeCode;
    private String invoiceRejectReasonDescription;
    private ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument;
    private ElectronicInvoiceRejectReasonType invoiceRejectReasonType;

    public ElectronicInvoiceRejectReason() {
        super();
    }

    public ElectronicInvoiceRejectReason(String electronicInvoiceRejectTypeCode, String invoiceFileName, String description) {
        super();
        this.invoiceRejectReasonTypeCode = electronicInvoiceRejectTypeCode;
        this.invoiceFileName = invoiceFileName;
        this.invoiceRejectReasonDescription = description;
    }

    public ElectronicInvoiceRejectReason(ElectronicInvoiceRejectDocument eir, String electronicInvoiceRejectTypeCode, String invoiceFileName, String description) {
        super();
        this.electronicInvoiceRejectDocument = eir;
        this.invoiceRejectReasonTypeCode = electronicInvoiceRejectTypeCode;
        this.invoiceFileName = invoiceFileName;
        this.invoiceRejectReasonDescription = description;
    }

    public ElectronicInvoiceRejectReason(Integer purapDocumentIdentifier, String electronicInvoiceRejectTypeCode, String invoiceFileName, String description) {
        super();
        this.purapDocumentIdentifier = purapDocumentIdentifier;
        this.invoiceRejectReasonTypeCode = electronicInvoiceRejectTypeCode;
        this.invoiceFileName = invoiceFileName;
        this.invoiceRejectReasonDescription = description;
    }

    public ElectronicInvoiceRejectDocument getElectronicInvoiceRejectDocument() {
        return electronicInvoiceRejectDocument;
    }

    public void setElectronicInvoiceRejectDocument(ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument) {
        this.electronicInvoiceRejectDocument = electronicInvoiceRejectDocument;
    }

    public String getInvoiceRejectReasonTypeCode() {
        return invoiceRejectReasonTypeCode;
    }

    public void setInvoiceRejectReasonTypeCode(String electronicInvoiceRejectTypeCode) {
        this.invoiceRejectReasonTypeCode = electronicInvoiceRejectTypeCode;
    }

    public Integer getInvoiceRejectReasonIdentifier() {
        return invoiceRejectReasonIdentifier;
    }

    public void setInvoiceRejectReasonIdentifier(Integer id) {
        this.invoiceRejectReasonIdentifier = id;
    }

    public String getInvoiceFileName() {
        return invoiceFileName;
    }

    public void setInvoiceFileName(String invoiceFileName) {
        this.invoiceFileName = invoiceFileName;
    }

    public String getInvoiceRejectReasonDescription() {
        return invoiceRejectReasonDescription;
    }

    public void setInvoiceRejectReasonDescription(String invoiceRejectReasonDescription) {
        this.invoiceRejectReasonDescription = invoiceRejectReasonDescription;
    }

    public ElectronicInvoiceRejectReasonType getInvoiceRejectReasonType() {
        return invoiceRejectReasonType;
    }

    public void setInvoiceRejectReasonType(ElectronicInvoiceRejectReasonType invoiceRejectReasonType) {
        this.invoiceRejectReasonType = invoiceRejectReasonType;
    }

    public Integer getPurapDocumentIdentifier() {
        return purapDocumentIdentifier;
    }

    public void setPurapDocumentIdentifier(Integer rejectHeaderId) {
        this.purapDocumentIdentifier = rejectHeaderId;
    }

    /**
     * @see org.kuali.rice.krad.bo.BusinessObjectBase#toStringMapper()
     */
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {

        LinkedHashMap m = new LinkedHashMap();
        m.put("invoiceRejectReasonIdentifier", this.invoiceRejectReasonIdentifier);
        return m;
    }

}
