/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document.service;

import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.module.purap.document.PurchasingDocument;

public interface PurchasingService {

    void setupCapitalAssetItems(PurchasingDocument purDoc);

    void deleteCapitalAssetItems(PurchasingDocument purDoc, Integer itemIdentifier);

    void setupCapitalAssetSystem(PurchasingDocument purDoc);

    String getDefaultAssetTypeCodeNotThisFiscalYear();

    /**
     * @param purDoc
     * @return boolean indicating the default value for use tax
     */
    boolean getDefaultUseTaxIndicatorValue(PurchasingDocument purDoc);

    boolean checkCapitalAssetLocation(CapitalAssetLocation location);

    boolean checkValidRoomNumber(CapitalAssetLocation location);

}
