/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.identity;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.kim.role.RoleTypeServiceBase;

import java.util.Arrays;
import java.util.Map;

public class SensitiveDataRoleTypeServiceImpl extends RoleTypeServiceBase {

    protected boolean performMatch(Map<String, String> qualification, Map<String, String> roleQualifier) {
        if (qualification == null) {
            return false;
        }
        String[] codes = StringUtils.split(qualification.get(PurapKimAttributes.SENSITIVE_DATA_CODE), ';');
        if (codes == null) {
            return false;
        }
        return Arrays.asList(codes).contains(roleQualifier.get(PurapKimAttributes.SENSITIVE_DATA_CODE));
    }
}
