/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.service;

/**
 * Image Service Interface.
 */
public interface ImageService {

    /**
     * Get the purchasing director signature image. This will get the image from webdav and copy it to a temp directory.
     *
     * @param key        Key for use in filename to make it unique
     * @param campusCode Campus code for image
     * @param location   location of where image resides
     * @return Full path on the local box for image file name
     */
    String getPurchasingDirectorImage(String key, String campusCode, String location);

    /**
     * Get the contract manager signature image. This will get the image from webdav and copy it to a temp directory.
     *
     * @param key               Key for use in filename to make it unique
     * @param contractManagerId Contract manager ID for image
     * @param location          location of where image resides
     * @return Full path on the local box for image file name
     */
    String getContractManagerImage(String key, Integer contractManagerId, String location);

    /**
     * Get the campus logo image. This will get the image from webdav and copy it to a temp directory.
     *
     * @param key        Key for use in filename to make it unique
     * @param campusCode Campus code for image
     * @param location   location of where image resides
     * @return Full path on the local box for image file name
     */
    String getLogo(String key, String campusCode, String location);

}
