/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.service;

import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignmentDetail;

import java.util.List;

public interface SensitiveDataService {

    List<SensitiveData> getSensitiveDatasAssignedByRelatedDocId(Integer accountsPayablePurchasingDocumentLinkIdentifier);

    /**
     * @param sensitiveDataCode the code of the sensitive data
     * @return the sensitive data object with the given code
     */
    SensitiveData getSensitiveDataByCode(String sensitiveDataCode);

    /**
     * @return a list of all sensitive data objects stored in the business object table.
     */
    List<SensitiveData> getAllSensitiveDatas();

    /**
     * @param poId the ID of the specified purchase order
     * @return a list of sensitive data entries assigned to the specified purchase order.
     */
    List<SensitiveData> getSensitiveDatasAssignedByPoId(Integer poId);

    /**
     * @param reqId the ID of the requisition that's associated with the purchase order
     * @return a list of sensitive data entries assigned to the specified purchase order.
     */
    List<SensitiveData> getSensitiveDatasAssignedByReqId(Integer reqId);

    /**
     * Deletes all sensitive data entries assigned to the specified purchase order.
     *
     * @param poId the ID of the PO
     */
    void deletePurchaseOrderSensitiveDatas(Integer poId);

    /**
     * Saves the specified list of PurchaseOrderSensitiveData objects into the database.
     *
     * @param posds the PurchaseOrderSensitiveData objects to be saved
     */
    void savePurchaseOrderSensitiveDatas(List<PurchaseOrderSensitiveData> posds);

    /**
     * @param poId the ID of the specified PO
     * @return the latest sensitive data assignment for the specified purchase order.
     */
    SensitiveDataAssignment getLastSensitiveDataAssignment(Integer poId);

    /**
     * @param poId the ID of the specified PO
     * @return the latest sensitive data assignment ID for the specified purchase order.
     */
    Integer getLastSensitiveDataAssignmentId(Integer poId);

    /**
     * Saves the specified SensitiveDataAssignment object into the database.
     *
     * @param sda the SensitiveDataAssignment object to be saved
     */
    void saveSensitiveDataAssignment(SensitiveDataAssignment sda);

    /**
     * @param poId the ID of the specified PO
     * @return the latest sensitive data assignment details for the specified purchase order.
     */
    List<SensitiveDataAssignmentDetail> getLastSensitiveDataAssignmentDetails(Integer poId);

    /**
     * Saves the specified list of SensitiveDataAssignmentDetail objects into the database.
     *
     * @param sdads the SensitiveDataAssignmentDetail objects to be saved
     */
    void saveSensitiveDataAssignmentDetails(List<SensitiveDataAssignmentDetail> sdads);

}
