/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.fixture.BulkReceivingDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class BulkReceivingDocumentTest
extends KualiTestBase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testRouteDocument() throws Exception {
        BulkReceivingDocument doc = BulkReceivingDocumentFixture.SIMPLE_DOCUMENT.createBulkReceivingDocument();
        doc.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.routeDocument((Document)doc, "routing bulk receiving document", documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)doc.getDocumentNumber());
        Document document = documentService.getByDocumentHeaderId(doc.getDocumentNumber());
        BulkReceivingDocumentTest.assertTrue((String)"Document should now be final.", (boolean)document.getDocumentHeader().getWorkflowDocument().isFinal());
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testRouteDocumentWithPO() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS.createPurchaseOrderDocument();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        po.prepareForSave();
        AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)po, (String)"saving copy source document", null, (DocumentService)documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)po.getDocumentNumber());
        PurchaseOrderDocument poResult = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(po.getDocumentNumber());
        BulkReceivingDocument doc = BulkReceivingDocumentFixture.SIMPLE_DOCUMENT_FOR_PO.createBulkReceivingDocument(poResult);
        doc.prepareForSave();
        this.routeDocument((Document)doc, "routing bulk receiving document", documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)doc.getDocumentNumber());
        Document document = documentService.getByDocumentHeaderId(doc.getDocumentNumber());
        BulkReceivingDocumentTest.assertTrue((String)"Document should now be final.", (boolean)document.getDocumentHeader().getWorkflowDocument().isFinal());
    }

    private void routeDocument(Document document, String annotation, DocumentService documentService) throws WorkflowException {
        try {
            documentService.routeDocument(document, annotation, null);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            BulkReceivingDocumentTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
    }
}

