/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceInputFileType;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceStep;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoad;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.fixture.ElectronicInvoiceHelperServiceFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceHelperService;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceHelperServiceImpl;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.mockito.Mockito;

@ConfigureContext(session=UserNameFixture.kfs)
public class ElectronicInvoiceHelperServiceTest
extends KualiTestBase {
    private ElectronicInvoiceInputFileType electronicInvoiceInputFileType;
    protected ElectronicInvoiceHelperServiceImpl cut;

    protected void setUp() throws Exception {
        super.setUp();
        this.electronicInvoiceInputFileType = (ElectronicInvoiceInputFileType)SpringContext.getBean(ElectronicInvoiceInputFileType.class);
        TestUtils.setSystemParameter(ElectronicInvoiceStep.class, (String)"FILE_MOVE_AFTER_LOAD_IND", (String)"yes");
        FileUtils.cleanDirectory((File)new File(this.electronicInvoiceInputFileType.getDirectoryPath()));
        this.cut = (ElectronicInvoiceHelperServiceImpl)SpringContext.getBean(ElectronicInvoiceHelperService.class);
        DocumentService documentServiceMock = (DocumentService)Mockito.mock(DocumentService.class);
        Mockito.when((Object)documentServiceMock.createNoteFromDocument((Document)Mockito.any(ElectronicInvoiceRejectDocument.class), Mockito.anyString())).thenReturn(Mockito.mock(Note.class));
        this.cut.setDocumentService(documentServiceMock);
        ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument = (ElectronicInvoiceRejectDocument)Mockito.spy(ElectronicInvoiceRejectDocument.class);
        Mockito.when((Object)documentServiceMock.getNewDocument("EIRT")).thenReturn((Object)electronicInvoiceRejectDocument);
        Mockito.when((Object)electronicInvoiceRejectDocument.getDocumentHeader()).thenReturn(Mockito.mock(DocumentHeader.class));
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)Mockito.spy(PaymentRequestDocument.class);
        Mockito.when((Object)documentServiceMock.getNewDocument("PREQ")).thenReturn((Object)paymentRequestDocument);
        ((PaymentRequestDocument)Mockito.doNothing().when((Object)paymentRequestDocument)).updateAndSaveAppDocStatus(Mockito.anyString());
        ((PaymentRequestDocument)Mockito.doNothing().when((Object)paymentRequestDocument)).populatePaymentRequestFromPurchaseOrder((PurchaseOrderDocument)Mockito.any(PurchaseOrderDocument.class), (HashMap)Mockito.any(HashMap.class));
        Mockito.when((Object)paymentRequestDocument.getDocumentHeader()).thenReturn(Mockito.mock(DocumentHeader.class));
        AttachmentService attachmentService = (AttachmentService)Mockito.mock(AttachmentService.class);
        Attachment attachment = (Attachment)Mockito.mock(Attachment.class);
        Mockito.when((Object)attachmentService.createAttachment((PersistableBusinessObject)Mockito.any(), Mockito.anyString(), Mockito.anyString(), Mockito.anyInt(), (InputStream)Mockito.any(InputStream.class), (String)Mockito.any())).thenReturn((Object)attachment);
        this.cut.setAttachmentService(attachmentService);
        NoteService noteService = (NoteService)Mockito.mock(NoteService.class);
        this.cut.setNoteService(noteService);
        BankService bankService = (BankService)Mockito.mock(BankService.class);
        this.cut.setBankService(bankService);
        PaymentRequestService paymentRequestService = (PaymentRequestService)Mockito.mock(PaymentRequestService.class);
        this.cut.setPaymentRequestService(paymentRequestService);
        KualiRuleService kualiRuleService = (KualiRuleService)Mockito.mock(KualiRuleService.class);
        this.cut.setKualiRuleService(kualiRuleService);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRejectDocumentCreationInvalidData() throws Exception {
        String rejectFile = "reject.xml";
        PurchaseOrderDocument poDocument = this.createPODoc(null);
        String vendorDUNS = poDocument.getVendorDetail().getVendorDunsNumber();
        String poNumber = poDocument.getPurapDocumentIdentifier().toString();
        String xmlChunk = ElectronicInvoiceHelperServiceFixture.getCXMLForRejectDocCreation(vendorDUNS, poNumber);
        this.writeXMLFile(xmlChunk, rejectFile);
        ElectronicInvoiceLoad load = this.cut.loadElectronicInvoices();
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)load.containsRejects());
        ElectronicInvoiceRejectDocument rejectDoc = (ElectronicInvoiceRejectDocument)load.getRejectDocuments().get(0);
        ElectronicInvoiceHelperServiceTest.assertNotNull((Object)rejectDoc);
        ElectronicInvoiceHelperServiceTest.assertEquals((String)rejectFile, (String)rejectDoc.getInvoiceFileName());
        ElectronicInvoiceHelperServiceTest.assertEquals((int)1, (int)rejectDoc.getInvoiceRejectReasons().size());
        File rejectedFileInRejectDir = new File(this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator + "reject" + File.separator + rejectFile);
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)rejectedFileInRejectDir.exists());
    }

    public void testRejectDocumentCreationCorruptXML() throws Exception {
        String corruptFile = "corrupt.xml";
        PurchaseOrderDocument poDocument = this.createPODoc(null);
        String vendorDUNS = poDocument.getVendorDetail().getVendorDunsNumber();
        String poNumber = poDocument.getPurapDocumentIdentifier().toString();
        String xmlChunk = ElectronicInvoiceHelperServiceFixture.getCorruptedCXML(vendorDUNS, poNumber);
        this.writeXMLFile(xmlChunk, corruptFile);
        ElectronicInvoiceLoad load = this.cut.loadElectronicInvoices();
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)load.containsRejects());
        ElectronicInvoiceRejectDocument rejectDoc = (ElectronicInvoiceRejectDocument)load.getRejectDocuments().get(0);
        ElectronicInvoiceHelperServiceTest.assertNotNull((Object)rejectDoc);
        ElectronicInvoiceHelperServiceTest.assertEquals((String)rejectDoc.getInvoiceFileName(), (String)corruptFile);
        ElectronicInvoiceHelperServiceTest.assertEquals((int)1, (int)rejectDoc.getInvoiceRejectReasons().size());
        ElectronicInvoiceHelperServiceTest.assertEquals((String)"INFF", (String)((ElectronicInvoiceRejectReason)rejectDoc.getInvoiceRejectReasons().get(0)).getInvoiceRejectReasonTypeCode());
        File corruptedFileInRejectDir = new File(this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator + "reject" + File.separator + corruptFile);
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)corruptedFileInRejectDir.exists());
    }

    public void testPaymentRequestDocumentCreation() throws Exception {
        String acceptFile = "accept.xml";
        this.changeCurrentUser(UserNameFixture.khuntley);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
        AccountingDocumentTestUtils.testRouteDocument((FinancialSystemTransactionalDocument)reqDoc, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        Integer reqId = reqDoc.getPurapDocumentIdentifier();
        this.changeCurrentUser(UserNameFixture.kfs);
        PurchaseOrderDocument poDocument = this.createPODoc(reqId);
        String vendorDUNS = RandomUtils.nextInt() + "";
        if (StringUtils.isEmpty((CharSequence)poDocument.getVendorDetail().getVendorDunsNumber())) {
            VendorDetail vd = ((VendorService)SpringContext.getBean(VendorService.class)).getByVendorNumber(poDocument.getVendorNumber());
            vd.setVendorDunsNumber(vendorDUNS);
            ((VendorService)SpringContext.getBean(VendorService.class)).saveVendorHeader(vd);
        } else {
            vendorDUNS = poDocument.getVendorDetail().getVendorDunsNumber();
        }
        String poNumber = poDocument.getPurapDocumentIdentifier().toString();
        String xmlChunk = ElectronicInvoiceHelperServiceFixture.getCXMLForPaymentDocCreation(vendorDUNS, poNumber);
        this.writeXMLFile(xmlChunk, acceptFile);
        ElectronicInvoiceLoad load = this.cut.loadElectronicInvoices();
        ElectronicInvoiceHelperServiceTest.assertFalse((boolean)load.containsRejects());
        File acceptedFileInAcceptDir = new File(this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator + "accept" + File.separator + acceptFile);
        ElectronicInvoiceHelperServiceTest.assertTrue((boolean)acceptedFileInAcceptDir.exists());
    }

    private PurchaseOrderDocument createPODoc(Integer reqId) throws Exception {
        PurchaseOrderDocument poDocument = PurchaseOrderDocumentFixture.EINVOICE_PO.createPurchaseOrderDocument();
        if (reqId != null) {
            poDocument.setRequisitionIdentifier(reqId);
        }
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        poDocument.prepareForSave();
        ElectronicInvoiceHelperServiceTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)poDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)poDocument, (String)"saving copy source document", null, (DocumentService)documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)poDocument.getDocumentNumber());
        ElectronicInvoiceHelperServiceTest.assertTrue((String)"Document should now be final.", (boolean)poDocument.getDocumentHeader().getWorkflowDocument().isFinal());
        return poDocument;
    }

    private void writeXMLFile(String xmlChunk, String fileName) throws Exception {
        String filepathAndName = this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator + fileName;
        FileWriter fileWriter = new FileWriter(new File(filepathAndName));
        fileWriter.write(xmlChunk);
        fileWriter.flush();
        fileWriter.close();
        String doneFileName = filepathAndName.replace(".xml", ".done");
        File doneFile = new File(doneFileName);
        doneFile.createNewFile();
    }
}

