/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class GenerateEntriesReopenPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurchaseOrderDocument poMock;
    @Mock
    private PurchaseOrderItem itemMock;
    @Mock
    private PurchaseOrderAccount accountingLineMock1;
    @Mock
    private PurchaseOrderAccount accountingLineMock2;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
    }

    private void execute() {
        this.cut.generateEntriesReopenPurchaseOrder(this.poMock);
        ((PurchaseOrderDocument)Mockito.verify((Object)this.poMock, (VerificationMode)Mockito.times((int)2))).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.poMock)).getItemsActiveOnly();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.poMock, (VerificationMode)Mockito.times((int)2))).setGlOnlySourceAccountingLines(ArgumentMatchers.anyList());
        ((PurchaseOrderDocument)Mockito.verify((Object)this.poMock)).getGlOnlySourceAccountingLines();
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryWithNoZeroTotalsUsingAlternateAmount(ArgumentMatchers.anyList());
    }

    private void baseExpectations(List<PurApItem> items, List<PurApItem> activeItems, List<SourceAccountingLine> sourceAccountingLines) {
        Mockito.when((Object)this.poMock.getItems()).thenReturn(items);
        Mockito.when((Object)this.poMock.getItemsActiveOnly()).thenReturn(activeItems);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(activeItems)).thenReturn(sourceAccountingLines);
        this.poMock.setGlOnlySourceAccountingLines(sourceAccountingLines);
        Mockito.when((Object)this.poMock.getGlOnlySourceAccountingLines()).thenReturn(sourceAccountingLines);
    }

    private void mockQuantityBasedItem(PurchaseOrderItem item, int original, int invoiced, double unitPrice) {
        int remaining = original - invoiced;
        double outstandingAmount = unitPrice * (double)remaining;
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        Mockito.when((Object)item.getItemType()).thenReturn((Object)itemType);
        Mockito.when((Object)item.getItemQuantity()).thenReturn((Object)new KualiDecimal(original));
        Mockito.when((Object)item.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(invoiced));
        item.setItemOutstandingEncumberedQuantity(new KualiDecimal(remaining));
        ((PurchaseOrderItem)Mockito.verify((Object)item)).setItemOutstandingEncumberedQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)item.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(remaining));
        Mockito.when((Object)item.getItemUnitPrice()).thenReturn((Object)new BigDecimal(unitPrice));
        item.setItemOutstandingEncumberedAmount(new KualiDecimal(outstandingAmount));
        ((PurchaseOrderItem)Mockito.verify((Object)item)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)item.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(outstandingAmount));
        Mockito.when((Object)item.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item.isItemActiveIndicator()).thenReturn((Object)true);
    }

    private void mockAmountBasedItem(PurchaseOrderItem item, double total, double invoiced) {
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(false);
        Mockito.when((Object)item.getItemType()).thenReturn((Object)itemType);
        Mockito.when((Object)item.getTotalAmount()).thenReturn((Object)new KualiDecimal(total));
        Mockito.when((Object)item.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(invoiced));
        item.setItemOutstandingEncumberedAmount(new KualiDecimal(total - invoiced));
        ((PurchaseOrderItem)Mockito.verify((Object)item)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)item.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(total - invoiced));
        Mockito.when((Object)item.getItemLineNumber()).thenReturn((Object)1);
        Mockito.when((Object)item.isItemActiveIndicator()).thenReturn((Object)true);
    }

    private PurchaseOrderAccount mockAccountingLine(PurchaseOrderAccount accountingLine, double percent, double amount, Double altAmount) {
        Mockito.when((Object)accountingLine.getAccountLinePercent()).thenReturn((Object)new BigDecimal(percent));
        accountingLine.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(amount));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountingLine)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        Mockito.when((Object)accountingLine.isEmpty()).thenReturn((Object)false);
        accountingLine.setAlternateAmountForGLEntryCreation(new KualiDecimal(amount));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountingLine)).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        if (altAmount == null) {
            Mockito.when((Object)accountingLine.getAlternateAmountForGLEntryCreation()).thenReturn((Object)new KualiDecimal(amount));
        } else {
            Mockito.when((Object)accountingLine.getAlternateAmountForGLEntryCreation()).thenReturn((Object)new KualiDecimal(amount));
            accountingLine.setAlternateAmountForGLEntryCreation(new KualiDecimal(altAmount.doubleValue()));
            ((PurchaseOrderAccount)Mockito.verify((Object)accountingLine, (VerificationMode)Mockito.times((int)2))).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
            Mockito.when((Object)accountingLine.getAlternateAmountForGLEntryCreation()).thenReturn((Object)new KualiDecimal(altAmount.doubleValue()));
        }
        Mockito.when((Object)accountingLine.compareTo(ArgumentMatchers.isA(PurchaseOrderAccount.class))).thenReturn((Object)0);
        return accountingLine;
    }

    @Test
    public void testNoItems() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(items, items, sourceAccountingLines);
        this.execute();
    }

    @Test
    public void testQuantityBasedItem() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        this.mockQuantityBasedItem(this.itemMock, 7, 4, 10.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(this.mockAccountingLine(this.accountingLineMock1, 100.0, 30.0, 30.0));
        Mockito.when((Object)this.itemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        items.add((PurApItem)this.itemMock);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(items, items, glOnlySourceAccountingLines);
        this.execute();
    }

    @Test
    public void testAmountBasedItem() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        this.mockAmountBasedItem(this.itemMock, 70.0, 40.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(this.mockAccountingLine(this.accountingLineMock1, 100.0, 30.0, 30.0));
        Mockito.when((Object)this.itemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        items.add((PurApItem)this.itemMock);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(items, items, glOnlySourceAccountingLines);
        this.execute();
    }

    @Test
    public void testMultipleAccountingLines() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        this.mockAmountBasedItem(this.itemMock, 70.0, 30.0);
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        sourceAccountingLines.add(this.mockAccountingLine(this.accountingLineMock1, 66.66, 26.66, null));
        sourceAccountingLines.add(this.mockAccountingLine(this.accountingLineMock2, 33.33, 13.33, 13.34));
        Mockito.when((Object)this.itemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        items.add((PurApItem)this.itemMock);
        ArrayList<SourceAccountingLine> glOnlySourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.baseExpectations(items, items, glOnlySourceAccountingLines);
        this.execute();
    }

    @Test
    public void testShouldNotCreateGlPEs() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        Mockito.when((Object)this.accountingLineMock1.getAmount()).thenReturn((Object)KualiDecimal.ZERO);
        sourceAccountingLines.add((SourceAccountingLine)this.accountingLineMock1);
        this.baseExpectations(items, items, sourceAccountingLines);
        this.execute();
    }

    @Test
    public void testShouldCreateGLPEs() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        Mockito.when((Object)this.accountingLineMock1.getAmount()).thenReturn((Object)new KualiDecimal(100.0));
        sourceAccountingLines.add((SourceAccountingLine)this.accountingLineMock1);
        this.baseExpectations(items, items, sourceAccountingLines);
        Mockito.when((Object)this.glPendingEntrySvcMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.poMock)).thenReturn((Object)true);
        ArrayList glpes = new ArrayList();
        Mockito.when((Object)this.poMock.getGeneralLedgerPendingEntries()).thenReturn(glpes);
        Mockito.when((Object)this.boServiceMock.save(glpes)).thenReturn(null);
        this.execute();
    }
}

