/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Date;
import org.apache.commons.io.IOUtils;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceInputFileType;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestHeader;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.fixture.ElectronicInvoiceParserFixture;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=false)
public class ElectronicInvoiceParserTest
extends KualiTestBase {
    private ElectronicInvoice eInvoice;
    private final String eInvoiceXMLFile = ".." + File.separator + "fixture" + File.separator + "electronicInvoiceFixture.xml";

    public void testEInvoiceXMLParsing() throws Exception {
        this.loadInvoiceXML();
        ElectronicInvoiceParserTest.assertNotNull((Object)this.eInvoice);
        this.validateCXMLAttributes();
        this.validateHeaderElement();
        this.validateInvoiceDetailRequestElement();
    }

    private void validateInvoiceDetailRequestElement() {
        this.validateInvoiceDetailRequestHeader();
        this.validateInvoiceDetailOrder();
        this.validateInvoiceDetailSummary();
    }

    private void loadInvoiceXML() throws Exception {
        ElectronicInvoiceInputFileType eInvoiceInputFileType = (ElectronicInvoiceInputFileType)SpringContext.getBean(ElectronicInvoiceInputFileType.class);
        BatchInputFileService batchInputFileService = (BatchInputFileService)SpringContext.getBean(BatchInputFileService.class);
        BufferedInputStream fileStream = new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream(this.eInvoiceXMLFile));
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileStream);
        this.eInvoice = (ElectronicInvoice)batchInputFileService.parse((BatchInputFileType)eInvoiceInputFileType, fileByteContent);
    }

    private void validateCXMLAttributes() {
        ElectronicInvoiceParserTest.assertEquals((String)"200807260401062080.964@eai002", (String)this.eInvoice.getPayloadID());
        ElectronicInvoiceParserTest.assertEquals((String)"2008-07-26T04:01:06-08:00", (String)this.eInvoice.getTimestamp());
        ElectronicInvoiceParserTest.assertEquals((String)"1.2.014", (String)this.eInvoice.getVersion());
        ElectronicInvoiceParserTest.assertEquals((String)"en", (String)this.eInvoice.getLocale());
        ElectronicInvoiceParserTest.assertEquals((String)"production", (String)this.eInvoice.getDeploymentMode());
    }

    private void validateHeaderElement() {
        ElectronicInvoiceParserTest.assertEquals((String)"DUNS", (String)this.eInvoice.getCxmlHeader().getFromDomain());
        ElectronicInvoiceParserTest.assertEquals((String)"121212", (String)this.eInvoice.getCxmlHeader().getFromIdentity());
        ElectronicInvoiceParserTest.assertEquals((String)"NetworkId", (String)this.eInvoice.getCxmlHeader().getToDomain());
        ElectronicInvoiceParserTest.assertEquals((String)"IUHIGHERM", (String)this.eInvoice.getCxmlHeader().getToIdentity());
        ElectronicInvoiceParserTest.assertEquals((String)"DUNS", (String)this.eInvoice.getCxmlHeader().getSenderDomain());
        ElectronicInvoiceParserTest.assertEquals((String)"121212", (String)this.eInvoice.getCxmlHeader().getSenderIdentity());
        ElectronicInvoiceParserTest.assertEquals((String)"fisherscipass", (String)this.eInvoice.getCxmlHeader().getSenderSharedSecret());
        ElectronicInvoiceParserTest.assertEquals((String)"IUPUI", (String)this.eInvoice.getCxmlHeader().getSenderUserAgent());
    }

    private void validateInvoiceDetailRequestHeader() {
        String invoiceDate = this.eInvoice.getInvoiceDetailRequestHeader().getInvoiceDateString();
        Date date = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        ElectronicInvoiceParserTest.assertEquals((String)"2008-07-25T00:00:00-08:00", (String)invoiceDate);
        ElectronicInvoiceParserTest.assertEquals((String)date.toString(), (String)this.eInvoice.getInvoiceDetailRequestHeader().getInvoiceDate().toString());
        ElectronicInvoiceParserTest.assertEquals((String)"133", (String)this.eInvoice.getInvoiceDetailRequestHeader().getInvoiceId());
        ElectronicInvoiceParserTest.assertEquals((String)"new", (String)this.eInvoice.getInvoiceDetailRequestHeader().getOperation());
        ElectronicInvoiceParserTest.assertEquals((String)"standard", (String)this.eInvoice.getInvoiceDetailRequestHeader().getPurpose());
        ElectronicInvoiceParserTest.assertTrue((boolean)this.eInvoice.getInvoiceDetailRequestHeader().isInformationOnly());
        ElectronicInvoiceParserTest.assertTrue((boolean)this.eInvoice.getInvoiceDetailRequestHeader().isHeaderInvoiceIndicator());
        ElectronicInvoiceParserTest.assertTrue((boolean)this.eInvoice.getInvoiceDetailRequestHeader().isTaxInLine());
        ElectronicInvoiceParserTest.assertTrue((boolean)this.eInvoice.getInvoiceDetailRequestHeader().isSpecialHandlingInLine());
        ElectronicInvoiceParserTest.assertTrue((boolean)this.eInvoice.getInvoiceDetailRequestHeader().isShippingInLine());
        ElectronicInvoiceParserTest.assertTrue((boolean)this.eInvoice.getInvoiceDetailRequestHeader().isDiscountInLine());
        this.validateInvoicePartners();
        this.validateShippingDetail();
        this.validatePaymentTermElement();
    }

    private void validateInvoicePartners() {
        this.validateBillToContact();
        this.validateRemitToContact();
    }

    private void validateBillToContact() {
        ElectronicInvoiceDetailRequestHeader requestHeader = this.eInvoice.getInvoiceDetailRequestHeader();
        ElectronicInvoiceContact contact = requestHeader.getCxmlContactByRoleID("billTo");
        ElectronicInvoiceParserTest.assertNotNull((Object)contact);
        ElectronicInvoiceParserTest.assertEquals((String)"", (String)contact.getAddressID());
        ElectronicInvoiceParserTest.assertEquals((String)"billTo", (String)contact.getRole());
        ElectronicInvoiceParserTest.assertEquals((int)1, (int)contact.getPostalAddresses().size());
        ElectronicInvoiceParserTest.assertEquals((String)"ACCOUNTING DEPT", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine1());
        ElectronicInvoiceParserTest.assertEquals((String)"620 UNION DR", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine2());
        ElectronicInvoiceParserTest.assertEquals((String)"RM 443", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine3());
        ElectronicInvoiceParserTest.assertEquals((String)"INDIANAPOLIS", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCityName());
        ElectronicInvoiceParserTest.assertEquals((String)"IN", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getStateCode());
        ElectronicInvoiceParserTest.assertEquals((String)"United States", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCountryName());
        ElectronicInvoiceParserTest.assertEquals((String)"US", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCountryCode());
    }

    private void validateRemitToContact() {
        ElectronicInvoiceDetailRequestHeader requestHeader = this.eInvoice.getInvoiceDetailRequestHeader();
        ElectronicInvoiceContact contact = requestHeader.getCxmlContactByRoleID("remitTo");
        ElectronicInvoiceParserTest.assertNotNull((Object)contact);
        ElectronicInvoiceParserTest.assertEquals((String)"004321519", (String)contact.getAddressID());
        ElectronicInvoiceParserTest.assertEquals((String)"remitTo", (String)contact.getRole());
        ElectronicInvoiceParserTest.assertEquals((int)1, (int)contact.getPostalAddresses().size());
        ElectronicInvoiceParserTest.assertEquals((String)"13551 COLLECTIONS CTR DR", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine1());
        ElectronicInvoiceParserTest.assertEquals((String)ElectronicInvoiceParserFixture.RemitToContact.street2, (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine2());
        ElectronicInvoiceParserTest.assertEquals((String)ElectronicInvoiceParserFixture.RemitToContact.street3, (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine3());
        ElectronicInvoiceParserTest.assertEquals((String)"CHICAGO", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCityName());
        ElectronicInvoiceParserTest.assertEquals((String)"IL", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getStateCode());
        ElectronicInvoiceParserTest.assertEquals((String)"United States", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCountryName());
        ElectronicInvoiceParserTest.assertEquals((String)"US", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCountryCode());
    }

    private void validateShippingDetail() {
        ElectronicInvoiceDetailRequestHeader requestHeader = this.eInvoice.getInvoiceDetailRequestHeader();
        ElectronicInvoiceParserTest.assertEquals((String)"2008-07-25T00:00:00-08:00", (String)requestHeader.getShippingDateString());
        ElectronicInvoiceContact contact = requestHeader.getCxmlContactByRoleID("shipTo");
        ElectronicInvoiceParserTest.assertNotNull((Object)contact);
        ElectronicInvoiceParserTest.assertEquals((String)"387520002", (String)contact.getAddressID());
        ElectronicInvoiceParserTest.assertEquals((String)"shipTo", (String)contact.getRole());
        ElectronicInvoiceParserTest.assertEquals((int)1, (int)contact.getPostalAddresses().size());
        ElectronicInvoiceParserTest.assertEquals((String)"950 W WALNUT ST", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine1());
        ElectronicInvoiceParserTest.assertEquals((String)"ROOM #451", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine2());
        ElectronicInvoiceParserTest.assertEquals((String)ElectronicInvoiceParserFixture.ShipToContact.street3, (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getLine3());
        ElectronicInvoiceParserTest.assertEquals((String)"INDIANAPOLIS", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCityName());
        ElectronicInvoiceParserTest.assertEquals((String)"IN", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getStateCode());
        ElectronicInvoiceParserTest.assertEquals((String)"United States", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCountryName());
        ElectronicInvoiceParserTest.assertEquals((String)"US", (String)((ElectronicInvoicePostalAddress)contact.getPostalAddresses().get(0)).getCountryCode());
        String emailName1 = (String)contact.getEmailAddresses().get("test1");
        String emailName2 = (String)contact.getEmailAddresses().get("test2");
        ElectronicInvoiceParserTest.assertNotNull((Object)emailName1);
        ElectronicInvoiceParserTest.assertNotNull((Object)emailName2);
        ElectronicInvoiceParserTest.assertEquals((String)"abc@efg.com", (String)emailName1);
        ElectronicInvoiceParserTest.assertEquals((String)"efg@hij.com", (String)emailName2);
        String phoneNumber = (String)contact.getPhoneNumbers().get("testPhone");
        ElectronicInvoiceParserTest.assertNotNull((Object)phoneNumber);
        ElectronicInvoiceParserTest.assertEquals((String)"12099545333", (String)phoneNumber);
        String faxNumber = (String)contact.getPhoneNumbers().get("testFax");
        ElectronicInvoiceParserTest.assertNotNull((Object)faxNumber);
        ElectronicInvoiceParserTest.assertEquals((String)"12099545331", (String)faxNumber);
        String url = (String)contact.getWebAddresses().get(0);
        ElectronicInvoiceParserTest.assertNotNull((Object)url);
        ElectronicInvoiceParserTest.assertEquals((String)"www.abc.com", (String)url);
    }

    private void validatePaymentTermElement() {
        ElectronicInvoiceParserTest.assertEquals((int)30, (int)this.eInvoice.getInvoiceDetailRequestHeader().getPayInNumberOfDays());
        ElectronicInvoiceParserTest.assertEquals((String)"0", (String)this.eInvoice.getInvoiceDetailRequestHeader().getPercentageRate());
    }

    private void validateInvoiceDetailOrder() {
        ElectronicInvoiceParserTest.assertEquals((int)1, (int)this.eInvoice.getInvoiceDetailOrders().size());
        ElectronicInvoiceOrder order = (ElectronicInvoiceOrder)this.eInvoice.getInvoiceDetailOrders().get(0);
        ElectronicInvoiceParserTest.assertEquals((String)"2008-07-25T00:00:00-08:00", (String)order.getOrderReferenceOrderDateString());
        ElectronicInvoiceParserTest.assertEquals((String)"1085", (String)order.getOrderReferenceOrderID());
        ElectronicInvoiceParserTest.assertEquals((String)"", (String)order.getOrderReferenceDocumentRefPayloadID());
        ElectronicInvoiceParserTest.assertEquals((int)1, (int)order.getInvoiceItems().size());
        ElectronicInvoiceItem item = (ElectronicInvoiceItem)order.getInvoiceItems().get(0);
        ElectronicInvoiceParserTest.assertEquals((String)"1", (String)item.getInvoiceLineNumber());
        ElectronicInvoiceParserTest.assertEquals((String)"10", (String)item.getQuantity());
        ElectronicInvoiceParserTest.assertEquals((String)"BG", (String)item.getUnitOfMeasure());
        ElectronicInvoiceParserTest.assertEquals((String)"11", (String)item.getUnitPrice());
        ElectronicInvoiceParserTest.assertEquals((String)"1", (String)item.getReferenceLineNumber());
        ElectronicInvoiceParserTest.assertEquals((String)"1212", (String)item.getReferenceItemIDSupplierPartID());
        ElectronicInvoiceParserTest.assertEquals((String)"LABCOAT UNISEX LONG XL WHT", (String)item.getReferenceDescription());
        ElectronicInvoiceParserTest.assertEquals((Object)110.0, (Object)item.getInvoiceLineSubTotalAmountBigDecimal().doubleValue());
        ElectronicInvoiceParserTest.assertEquals((Object)2.0, (Object)item.getInvoiceLineTaxAmountBigDecimal().doubleValue());
        ElectronicInvoiceParserTest.assertEquals((String)"Sales Tax", (String)item.getTaxDescription());
        ElectronicInvoiceParserTest.assertEquals((Object)10.0, (Object)item.getInvoiceLineShippingAmountBigDecimal().doubleValue());
        ElectronicInvoiceParserTest.assertEquals((Object)5.0, (Object)item.getInvoiceLineSpecialHandlingAmountBigDecimal().doubleValue());
    }

    private void validateInvoiceDetailSummary() {
        ElectronicInvoiceDetailRequestSummary summary = this.eInvoice.getInvoiceDetailRequestSummary();
        ElectronicInvoiceParserTest.assertNotNull((Object)summary);
        ElectronicInvoiceParserTest.assertEquals((String)"1.00", (String)summary.getSubTotalAmount());
        ElectronicInvoiceParserTest.assertEquals((String)"2.00", (String)summary.getTaxAmount());
        ElectronicInvoiceParserTest.assertEquals((String)"Total Tax", (String)summary.getTaxDescription());
        ElectronicInvoiceParserTest.assertEquals((String)"3.00", (String)summary.getSpecialHandlingAmount());
        ElectronicInvoiceParserTest.assertEquals((String)"4.00", (String)summary.getShippingAmount());
        ElectronicInvoiceParserTest.assertEquals((String)"6.00", (String)summary.getDiscountAmount());
        ElectronicInvoiceParserTest.assertEquals((String)"5.00", (String)summary.getGrossAmount());
        ElectronicInvoiceParserTest.assertEquals((String)"7.00", (String)summary.getNetAmount());
        ElectronicInvoiceParserTest.assertEquals((String)"8.00", (String)summary.getDepositAmount());
        ElectronicInvoiceParserTest.assertEquals((String)"9.00", (String)summary.getDueAmount());
    }
}

