/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.batch;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.purap.batch.service.AutoClosePurchaseOrderService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

import java.util.Date;

/**
 * Step used to auto approve purchase orders that meet a certain criteria
 */
public class AutoCloseRecurringOrdersStep extends AbstractStep {
    private static final Logger LOG = LogManager.getLogger(AutoCloseRecurringOrdersStep.class);

    private AutoClosePurchaseOrderService autoClosePurchaseOrderService;

    public AutoCloseRecurringOrdersStep() {
        super();
    }

    /**
     * Calls service method to approve recurring purchase orders
     */
    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        return autoClosePurchaseOrderService.autoCloseRecurringOrders();
    }

    /**
     * Invoke execute method
     *
     * @return
     * @throws InterruptedException
     */
    public boolean execute() throws InterruptedException {
        try {
            return execute(null, SpringContext.getBean(DateTimeService.class).getCurrentDate());
        } catch (InterruptedException e) {
            LOG.error("Exception occured executing step", e);
            throw e;
        } catch (RuntimeException e) {
            LOG.error("Exception occured executing step", e);
            throw e;
        }
    }

    public void setAutoClosePurchaseOrderService(AutoClosePurchaseOrderService autoClosePurchaseOrderService) {
        this.autoClosePurchaseOrderService = autoClosePurchaseOrderService;
    }

}
