/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on Feb 13, 2006
 *
 */
package org.kuali.kfs.module.purap.businessobject;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.kfs.module.purap.PurapConstants;

import java.math.BigDecimal;

public class ElectronicInvoiceDetailRequestSummary {

    // has money xml node
    private String subTotalAmount;
    private String subTotalAmountCurrency;
    // has money xml node  (not all tax fields are stored as tax should never occur)
    private String taxAmount;
    private String taxAmountCurrency;
    private String taxDescription;
    // has money xml node
    private String specialHandlingAmount;
    private String specialHandlingAmountCurrency;
    private String specialHandlingAmountDescription;
    // has money xml node
    private String shippingAmount;
    private String shippingAmountCurrency;
    // grossAmount should = subTotalAmount + taxAmount + specialHandlingAmount + shippingAmount
    private String grossAmount;
    private String grossAmountCurrency;
    // has money xml node
    private String discountAmount;
    private String discountAmountCurrency;
    // netAmount should = grossAmount - discountAmount
    // has money xml node
    private String netAmount;
    private String netAmountCurrency;
    // has money xml node
    private String depositAmount;
    private String depositAmountCurrency;
    // dueAmount should = newAmount - depositAmount
    // has money xml node
    private String dueAmount;
    private String dueAmountCurrency;

    private String taxCategory;
    private String taxPurpose;
    private String taxPercentageRate;

    public ElectronicInvoiceDetailRequestSummary() {
        super();
    }

    public String getShippingDescription() {
        if (this.shippingAmount != null) {
            try {
                if (BigDecimal.ZERO.compareTo(this.getInvoiceShippingAmount()) != 0) {
                    return PurapConstants.ElectronicInvoice.DEFAULT_SHIPPING_DESCRIPTION;
                } else {
                    return null;
                }
            } catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public BigDecimal getInvoiceSubTotalAmount() {
        if (this.subTotalAmount == null || "".equals(this.subTotalAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.subTotalAmount);
        }
    }

    public BigDecimal getInvoiceTaxAmount() {
        if (this.taxAmount == null || "".equals(this.taxAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.taxAmount);
        }
    }

    public BigDecimal getInvoiceSpecialHandlingAmount() {
        if (this.specialHandlingAmount == null || "".equals(this.specialHandlingAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.specialHandlingAmount);
        }
    }

    public BigDecimal getInvoiceShippingAmount() {
        if (this.shippingAmount == null || "".equals(this.shippingAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.shippingAmount);
        }
    }

    public BigDecimal getInvoiceGrossAmount() {
        if (this.grossAmount == null || "".equals(this.grossAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.grossAmount);
        }
    }

    public BigDecimal getInvoiceDiscountAmount() {
        if (this.discountAmount == null || "".equals(this.discountAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.discountAmount);
        }
    }

    public BigDecimal getInvoiceNetAmount() {
        if (this.netAmount == null || "".equals(this.netAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.netAmount);
        }
    }

    public BigDecimal getInvoiceDepositAmount() {
        if (this.depositAmount == null || "".equals(this.depositAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.depositAmount);
        }
    }

    public BigDecimal getInvoiceDueAmount() {
        if (this.dueAmount == null || "".equals(this.dueAmount)) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(this.dueAmount);
        }
    }

    public String getDepositAmount() {
        return depositAmount;
    }

    public void setDepositAmount(String depositAmount) {
        this.depositAmount = depositAmount;
    }

    public String getDepositAmountCurrency() {
        return depositAmountCurrency;
    }

    public void setDepositAmountCurrency(String depositAmountCurrency) {
        this.depositAmountCurrency = depositAmountCurrency;
    }

    public String getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getDiscountAmountCurrency() {
        return discountAmountCurrency;
    }

    public void setDiscountAmountCurrency(String discountAmountCurrency) {
        this.discountAmountCurrency = discountAmountCurrency;
    }

    public String getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(String dueAmount) {
        this.dueAmount = dueAmount;
    }

    public String getDueAmountCurrency() {
        return dueAmountCurrency;
    }

    public void setDueAmountCurrency(String dueAmountCurrency) {
        this.dueAmountCurrency = dueAmountCurrency;
    }

    public String getGrossAmount() {
        return grossAmount;
    }

    public void setGrossAmount(String grossAmount) {
        this.grossAmount = grossAmount;
    }

    public String getGrossAmountCurrency() {
        return grossAmountCurrency;
    }

    public void setGrossAmountCurrency(String grossAmountCurrency) {
        this.grossAmountCurrency = grossAmountCurrency;
    }

    public String getNetAmount() {
        return netAmount;
    }

    public void setNetAmount(String netAmount) {
        this.netAmount = netAmount;
    }

    public String getNetAmountCurrency() {
        return netAmountCurrency;
    }

    public void setNetAmountCurrency(String netAmountCurrency) {
        this.netAmountCurrency = netAmountCurrency;
    }

    public String getShippingAmount() {
        return shippingAmount;
    }

    public void setShippingAmount(String shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    public String getShippingAmountCurrency() {
        return shippingAmountCurrency;
    }

    public void setShippingAmountCurrency(String shippingAmountCurrency) {
        this.shippingAmountCurrency = shippingAmountCurrency;
    }

    public String getSpecialHandlingAmount() {
        return specialHandlingAmount;
    }

    public void setSpecialHandlingAmount(String specialHandlingAmount) {
        this.specialHandlingAmount = specialHandlingAmount;
    }

    public String getSpecialHandlingAmountCurrency() {
        return specialHandlingAmountCurrency;
    }

    public void setSpecialHandlingAmountCurrency(String specialHandlingAmountCurrency) {
        this.specialHandlingAmountCurrency = specialHandlingAmountCurrency;
    }

    public String getSpecialHandlingAmountDescription() {
        if (this.specialHandlingAmount != null) {
            try {
                if (BigDecimal.ZERO.compareTo(this.getInvoiceSpecialHandlingAmount()) != 0) {
                    return PurapConstants.ElectronicInvoice.DEFAULT_SPECIAL_HANDLING_DESCRIPTION;
                } else {
                    return null;
                }
            } catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public void setSpecialHandlingAmountDescription(String specialHandlingAmountDescription) {
        this.specialHandlingAmountDescription = specialHandlingAmountDescription;
    }

    public String getSubTotalAmount() {
        return subTotalAmount;
    }

    public void setSubTotalAmount(String subTotalAmount) {
        this.subTotalAmount = subTotalAmount;
    }

    public String getSubTotalAmountCurrency() {
        return subTotalAmountCurrency;
    }

    public void setSubTotalAmountCurrency(String subTotalAmountCurrency) {
        this.subTotalAmountCurrency = subTotalAmountCurrency;
    }

    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getTaxAmountCurrency() {
        return taxAmountCurrency;
    }

    public void setTaxAmountCurrency(String taxAmountCurrency) {
        this.taxAmountCurrency = taxAmountCurrency;
    }

    public String getTaxDescription() {
        return taxDescription;
    }

    public void setTaxDescription(String taxDescription) {
        this.taxDescription = taxDescription;
    }

    public String getTaxCategory() {
        return taxCategory;
    }

    public void setTaxCategory(String taxCategory) {
        this.taxCategory = taxCategory;
    }

    public String getTaxPercentageRate() {
        return taxPercentageRate;
    }

    public void setTaxPercentageRate(String taxPercentageRate) {
        this.taxPercentageRate = taxPercentageRate;
    }

    public String getTaxPurpose() {
        return taxPurpose;
    }

    public void setTaxPurpose(String taxPurpose) {
        this.taxPurpose = taxPurpose;
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder(this);
        toString.append("subTotalAmount", getSubTotalAmount());
        toString.append("subTotalAmountCurrency", getSubTotalAmountCurrency());
        toString.append("taxAmount", getTaxAmount());
        toString.append("taxAmountCurrency", getTaxAmountCurrency());
        toString.append("taxDescription", getTaxDescription());
        toString.append("taxPercentageRate", getTaxPercentageRate());
        toString.append("taxPurpose", getTaxPurpose());
        toString.append("taxCategory", getTaxCategory());
        toString.append("specialHandlingAmount", getSpecialHandlingAmount());
        toString.append("specialHandlingAmountCurrency", getSpecialHandlingAmountCurrency());
        toString.append("specialHandlingAmountDescription", getSpecialHandlingAmountDescription());
        toString.append("shippingAmount", getShippingAmount());
        toString.append("shippingAmountCurrency", getShippingAmountCurrency());
        toString.append("grossAmount", getGrossAmount());
        toString.append("grossAmountCurrency", getGrossAmountCurrency());
        toString.append("discountAmount", getDiscountAmount());
        toString.append("discountAmountCurrency", getDiscountAmountCurrency());
        toString.append("netAmount", getNetAmount());
        toString.append("netAmountCurrency", getNetAmountCurrency());
        toString.append("depositAmount", getDepositAmount());
        toString.append("depositAmountCurrency", getDepositAmountCurrency());
        toString.append("dueAmount", getDueAmount());
        toString.append("dueAmountCurrency", getDueAmountCurrency());
        return toString.toString();
    }

}
