/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on Mar 7, 2006
 *
 */
package org.kuali.kfs.module.purap.businessobject;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.ArrayList;
import java.util.List;

public class ElectronicInvoicePostalAddress {

    // no deliverTo attributes currently
    private String type;
    private String line1 = "";
    private String line2 = "";
    private String line3 = "";
    private String cityName;
    private String stateCode;
    private String postalCode;
    private String countryCode;
    private String countryName;

    private List names = new ArrayList();

    private List<String> street = new ArrayList<>();

    public ElectronicInvoicePostalAddress() {
        super();
    }

    public void addName(String name) {
        this.names.add(name);
    }

    /**
     * @return first name found in names list
     */
    public String getName() {
        if (names.isEmpty()) {
            return "";
        } else {
            return (String) names.get(0);
        }
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getLine1() {
        if (street.size() > 0) {
            return street.get(0);
        } else {
            return null;
        }
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public String getLine2() {
        if (street.size() > 1) {
            return street.get(1);
        } else {
            return null;
        }
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public String getLine3() {
        if (street.size() > 2) {
            return street.get(2);
        } else {
            return null;
        }
    }

    public void setLine3(String line3) {
        this.line3 = line3;
    }

    public List getNames() {
        return names;
    }

    public void setNames(List names) {
        this.names = names;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getStateCode() {
        return stateCode;
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addStreet(String street) {
        this.street.add(street);
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder(this);
        toString.append("type", getType());
        toString.append("line1", getLine1());
        toString.append("line2", getLine2());
        toString.append("line3", getLine3());
        toString.append("cityName", getCityName());
        toString.append("stateCode", getStateCode());
        toString.append("postalCode", getPostalCode());
        toString.append("countryCode", getCountryCode());
        toString.append("countryName", getCountryName());
        toString.append("Names(DeliverTo)", getNames());
        return toString.toString();
    }
}
