/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.apache.ojb.broker.PersistenceBrokerAware;
import org.kuali.kfs.integration.purap.ExternalPurApItem;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.math.BigDecimal;
import java.util.List;

public interface PurApItem extends PersistableBusinessObject, PersistenceBrokerAware, PurapEnterableItem,
        ExternalPurApItem {

    Integer getItemIdentifier();

    void setItemIdentifier(Integer ItemIdentifier);

    Integer getItemLineNumber();

    void setItemLineNumber(Integer itemLineNumber);

    String getItemUnitOfMeasureCode();

    void setItemUnitOfMeasureCode(String itemUnitOfMeasureCode);

    String getItemCatalogNumber();

    void setItemCatalogNumber(String itemCatalogNumber);

    String getItemDescription();

    void setItemDescription(String itemDescription);

    BigDecimal getItemUnitPrice();

    void setItemUnitPrice(BigDecimal itemUnitPrice);

    String getItemTypeCode();

    void setItemTypeCode(String itemTypeCode);

    String getItemAuxiliaryPartIdentifier();

    void setItemAuxiliaryPartIdentifier(String itemAuxiliaryPartIdentifier);

    String getExternalOrganizationB2bProductReferenceNumber();

    void setExternalOrganizationB2bProductReferenceNumber(String externalOrganizationB2bProductReferenceNumber);

    String getExternalOrganizationB2bProductTypeName();

    void setExternalOrganizationB2bProductTypeName(String externalOrganizationB2bProductTypeName);

    boolean getItemAssignedToTradeInIndicator();

    void setItemAssignedToTradeInIndicator(boolean itemAssignedToTradeInIndicator);

    ItemType getItemType();

    /**
     * @deprecated
     */
    void setItemType(ItemType itemType);

    /**
     * This method resets the transient new account method
     */
    void resetAccount();

    KualiDecimal getExtendedPrice();

    KualiDecimal getTotalAmount();

    void setTotalAmount(KualiDecimal totalAmount);

    /**
     * gets the total amount to remit to a vendor
     *
     * @return pre tax total if use tax post tax if sales
     */
    KualiDecimal getTotalRemitAmount();

    KualiDecimal calculateExtendedPrice();

    void setExtendedPrice(KualiDecimal extendedPrice);

    KualiDecimal getItemTaxAmount();

    void setItemTaxAmount(KualiDecimal itemTaxAmount);

    PurApAccountingLine getNewSourceLine();

    void setNewSourceLine(PurApAccountingLine newAccountingLine);

    Class getAccountingLineClass();

    Class getUseTaxClass();

    List<PurApAccountingLine> getSourceAccountingLines();

    void setSourceAccountingLines(List<PurApAccountingLine> purapAccountingLines);

    List<PurApAccountingLine> getBaselineSourceAccountingLines();

    List<PurApItemUseTax> getUseTaxItems();

    void setUseTaxItems(List<PurApItemUseTax> useTaxItems);

    KualiDecimal getItemQuantity();

    void setItemQuantity(KualiDecimal itemQuantity);

    String getItemIdentifierString();

    PurApSummaryItem getSummaryItem();

    <T extends PurchasingAccountsPayableDocument> T getPurapDocument();

    void setPurapDocument(PurchasingAccountsPayableDocument purapDoc);

    Integer getPurapDocumentIdentifier();

    void setPurapDocumentIdentifier(Integer purapDocumentIdentifier);

    void fixAccountReferences();
}
