/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.integration.purap.ItemCapitalAsset;

public class PurchaseOrderCapitalAssetSystem extends PurchasingCapitalAssetSystemBase {

    private String documentNumber;

    public PurchaseOrderCapitalAssetSystem() {
        super();
    }

    public PurchaseOrderCapitalAssetSystem(CapitalAssetSystem originalSystem) {
        super();
        if (originalSystem != null) {
            this.setCapitalAssetSystemDescription(originalSystem.getCapitalAssetSystemDescription());
            this.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(
                    originalSystem.isCapitalAssetNotReceivedCurrentFiscalYearIndicator());
            this.setCapitalAssetTypeCode(originalSystem.getCapitalAssetTypeCode());
            this.setCapitalAssetManufacturerName(originalSystem.getCapitalAssetManufacturerName());
            this.setCapitalAssetModelDescription(originalSystem.getCapitalAssetModelDescription());
            this.setCapitalAssetNoteText(originalSystem.getCapitalAssetNoteText());
            populatePurchaseOrderItemCapitalAssets(originalSystem);
            populateCapitalAssetLocations(originalSystem);
            this.setCapitalAssetCountAssetNumber(originalSystem.getCapitalAssetCountAssetNumber());
        }
    }

    private void populatePurchaseOrderItemCapitalAssets(CapitalAssetSystem originalSystem) {
        for (ItemCapitalAsset reqAsset : originalSystem.getItemCapitalAssets()) {
            PurchaseOrderItemCapitalAsset poAsset = new PurchaseOrderItemCapitalAsset(
                    reqAsset.getCapitalAssetNumber());
            this.getItemCapitalAssets().add(poAsset);
        }
    }

    private void populateCapitalAssetLocations(CapitalAssetSystem originalSystem) {
        for (CapitalAssetLocation reqLocation : originalSystem.getCapitalAssetLocations()) {
            PurchaseOrderCapitalAssetLocation poLocation = new PurchaseOrderCapitalAssetLocation();
            poLocation.setItemQuantity(reqLocation.getItemQuantity());
            poLocation.setCampusCode(reqLocation.getCampusCode());
            poLocation.setOffCampusIndicator(reqLocation.isOffCampusIndicator());
            poLocation.setBuildingCode(reqLocation.getBuildingCode());
            poLocation.setBuildingRoomNumber(reqLocation.getBuildingRoomNumber());
            poLocation.setCapitalAssetLine1Address(reqLocation.getCapitalAssetLine1Address());
            poLocation.setCapitalAssetCityName(reqLocation.getCapitalAssetCityName());
            poLocation.setCapitalAssetStateCode(reqLocation.getCapitalAssetStateCode());
            poLocation.setCapitalAssetPostalCode(reqLocation.getCapitalAssetPostalCode());
            poLocation.setCapitalAssetCountryCode(reqLocation.getCapitalAssetCountryCode());
            this.getCapitalAssetLocations().add(poLocation);
        }
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public Class getCapitalAssetLocationClass() {
        return PurchaseOrderCapitalAssetLocation.class;
    }

    @Override
    public Class getItemCapitalAssetClass() {
        return PurchaseOrderItemCapitalAsset.class;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

}
