/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.options;

import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.krad.service.KeyValuesService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Value Finder for Item Types.
 */
public class ItemTypeValuesFinder extends KeyValuesBase {

    public List<KeyValue> getKeyValues() {
        KeyValuesService boService = SpringContext.getBean(KeyValuesService.class);
        Collection<ItemType> itemTypes = boService.findAll(ItemType.class);
        List<KeyValue> labels = new ArrayList<>();
        for (ItemType itemType : itemTypes) {
            //exclude certain item types from the list
            if (itemType.isLineItemIndicator()
                    && !PurapConstants.ItemTypeCodes.EXCLUDED_ITEM_TYPES.contains(itemType.getItemTypeCode())) {
                labels.add(new ConcreteKeyValue(itemType.getItemTypeCode(), itemType.getItemTypeDescription()));
            }
        }

        return labels;
    }
}
