/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.document.validation.BranchingValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchaseOrderAmendmentProcessAccountValidation extends BranchingValidation {

    protected final String PROCESS_ACCOUNT_VALIDATION = "processAccountValidation";
    protected PurApItem itemForValidation;

    /**
     * Overrides the method in PurchasingProcessAccountValidation to provide additional validation condition. If the
     * accounts on the item are editable in the amendment document then we should continue doing the
     * processAccountValidation in the superclass, otherwise we should just return true so that the account won't be
     * validated, because if the items contain accounts that aren't editable, it doesn't make sense to give the user
     * account validation errors.
     */
    @Override
    protected String determineBranch(AttributedDocumentEvent event) {
        PurchaseOrderDocument document = (PurchaseOrderDocument) event.getDocument();
        PurchaseOrderItem itemLine = (PurchaseOrderItem) getItemForValidation();
        if (itemLine.isItemActiveIndicator() && !(document.getContainsUnpaidPaymentRequestsOrCreditMemos()
                && itemLine.getItemInvoicedTotalAmount() != null)) {
            // This means the accounts on the item are editable, so we'll call super's processAccountValidation.
            return PROCESS_ACCOUNT_VALIDATION;
        } else {
            // This means the accounts on the item are not editable, so we'll return true so that it won't do any
            // further validations on the accounts.
            return null;
        }
    }

    public PurApItem getItemForValidation() {
        return itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

}
