/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingAddCapitalAssetLocationValidation extends GenericValidation {

    protected CapitalAssetLocation location;
    protected ParameterService parameterService;
    protected PurchasingService purchasingService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = getPurchasingService().checkCapitalAssetLocation(getLocation());
        valid &= getPurchasingService().checkValidRoomNumber(getLocation());
        return valid;
    }

    public CapitalAssetLocation getLocation() {
        return location;
    }

    public void setLocation(CapitalAssetLocation location) {
        this.location = location;
    }

    protected ParameterService getParameterService() {
        if (parameterService == null) {
            parameterService = SpringContext.getBean(ParameterService.class);
        }
        return parameterService;
    }

    protected PurchasingService getPurchasingService() {
        if (parameterService == null) {
            purchasingService = SpringContext.getBean(PurchasingService.class);
        }
        return purchasingService;
    }

}
