/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util;

import org.apache.commons.lang3.EnumUtils;
import org.kuali.kfs.module.purap.PurapPropertyConstants;

import java.util.List;

public enum ThresholdField {

    CHART_OF_ACCOUNTS_CODE(PurapPropertyConstants.CHART_OF_ACCOUNTS_CODE),
    ORGANIZATION_CODE(PurapPropertyConstants.ORGANIZATION_CODE),
    ACCOUNT_TYPE_CODE(PurapPropertyConstants.ACCOUNT_TYPE_CODE),
    SUBFUND_GROUP_CODE(PurapPropertyConstants.SUB_FUND_GROUP_CODE),
    FINANCIAL_OBJECT_CODE(PurapPropertyConstants.FINANCIAL_OBJECT_CODE),
    COMMODITY_CODE(PurapPropertyConstants.ITEM_COMMODITY_CODE),
    VENDOR_HEADER_GENERATED_ID(PurapPropertyConstants.VENDOR_HEADER_GENERATED_ID),
    VENDOR_DETAIL_ASSIGNED_ID(PurapPropertyConstants.VENDOR_DETAIL_ASSIGNED_ID),
    VENDOR_NUMBER(PurapPropertyConstants.VENDOR_NUMBER, false),
    ACTIVE(PurapPropertyConstants.BO_ACTIVE, true);

    private String name;

    /**
     * Indicates that a field is available in DB or not
     */
    private boolean isPersistedField;

    ThresholdField(String name) {
        this(name, true);
    }

    ThresholdField(String name, boolean isPersistedField) {
        this.name = name;
        this.isPersistedField = isPersistedField;
    }

    public String getName() {
        return name;
    }

    public static List<ThresholdField> getEnumList() {
        return EnumUtils.getEnumList(ThresholdField.class);
    }

    public boolean isPersistedField() {
        return isPersistedField;
    }
}
