/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on Mar 10, 2005
 *
 */
package org.kuali.kfs.module.purap.util.cxml;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class CxmlHeader {

    private String fromIdentity;
    private String fromDomain;
    private String fromType;
    private String toIdentity;
    private String toDomain;
    private String toType;
    private String senderIdentity;
    private String senderDomain;
    private String senderType;
    private String senderUserAgent;

    private String fromSharedSecret;
    private String toSharedSecret;
    private String senderSharedSecret;

    public CxmlHeader() {
        super();
    }

    public void setFrom(String domain, String identity) {
        this.setFrom(domain, identity, null);
    }

    public void setFrom(String domain, String identity, String type) {
        this.fromDomain = domain;
        this.fromIdentity = identity;
        this.fromType = type;
    }

    public void setTo(String domain, String identity) {
        this.setTo(domain, identity, null);
    }

    public void setTo(String domain, String identity, String type) {
        this.toDomain = domain;
        this.toIdentity = identity;
        this.toType = type;
    }

    public void setSender(String domain, String identity) {
        this.setSender(domain, identity, null);
    }

    public void setSender(String domain, String identity, String type) {
        this.senderDomain = domain;
        this.senderIdentity = identity;
        this.senderType = type;
    }

    public String getFromDomain() {
        return fromDomain;
    }

    public void setFromDomain(String fromDomain) {
        this.fromDomain = fromDomain;
    }

    public String getFromIdentity() {
        return fromIdentity;
    }

    public void setFromIdentity(String fromIdentity) {
        this.fromIdentity = fromIdentity;
    }

    public String getFromType() {
        return fromType;
    }

    public void setFromType(String fromType) {
        this.fromType = fromType;
    }

    public String getSenderDomain() {
        return senderDomain;
    }

    public void setSenderDomain(String senderDomain) {
        this.senderDomain = senderDomain;
    }

    public String getSenderIdentity() {
        return senderIdentity;
    }

    public void setSenderIdentity(String senderIdentity) {
        this.senderIdentity = senderIdentity;
    }

    public String getSenderType() {
        return senderType;
    }

    public void setSenderType(String senderType) {
        this.senderType = senderType;
    }

    public String getSenderUserAgent() {
        return senderUserAgent;
    }

    public void setSenderUserAgent(String senderUserAgent) {
        this.senderUserAgent = senderUserAgent;
    }

    public String getToDomain() {
        return toDomain;
    }

    public void setToDomain(String toDomain) {
        this.toDomain = toDomain;
    }

    public String getToIdentity() {
        return toIdentity;
    }

    public void setToIdentity(String toIdentity) {
        this.toIdentity = toIdentity;
    }

    public String getToType() {
        return toType;
    }

    public void setToType(String toType) {
        this.toType = toType;
    }

    public String getSenderSharedSecret() {
        return senderSharedSecret;
    }

    public void setSenderSharedSecret(String senderSharedSecret) {
        this.senderSharedSecret = senderSharedSecret;
    }

    public String getFromSharedSecret() {
        return fromSharedSecret;
    }

    public void setFromSharedSecret(String fromSharedSecret) {
        this.fromSharedSecret = fromSharedSecret;
    }

    public String getToSharedSecret() {
        return toSharedSecret;
    }

    public void setToSharedSecret(String toSharedSecret) {
        this.toSharedSecret = toSharedSecret;
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder(this);

        toString.append("FromDomain", getFromDomain());
        toString.append("FromIdentity", getFromIdentity());
        toString.append("FromSharedSecret", getFromSharedSecret());
        toString.append("FromType", getFromType());

        toString.append("ToDomain", getToDomain());
        toString.append("ToIdentity", getToIdentity());
        toString.append("ToSharedSecret", getToSharedSecret());
        toString.append("ToType", getToType());

        toString.append("SenderDomain", getSenderDomain());
        toString.append("SenderIdentity", getSenderIdentity());
        toString.append("SenderType", getSenderType());
        toString.append("SenderSharedSecret", getSenderSharedSecret());
        toString.append("SenderUserAgent", getSenderUserAgent());

        return toString.toString();
    }

}
