/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.dataaccess.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItemMapping;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoadSummary;
import org.kuali.kfs.module.purap.dataaccess.ElectronicInvoicingDao;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class ElectronicInvoicingDaoOjb
extends PlatformAwareDaoBaseOjb
implements ElectronicInvoicingDao {
    private static final Logger LOG = LogManager.getLogger(ElectronicInvoicingDaoOjb.class);

    @Override
    public ElectronicInvoiceLoadSummary getElectronicInvoiceLoadSummary(Integer loadId, String vendorDunsNumber) {
        LOG.debug("getElectronicInvoiceLoadSummary() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("id", (Object)loadId);
        criteria.addEqualTo("vendorDunsNumber", (Object)vendorDunsNumber);
        return (ElectronicInvoiceLoadSummary)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(ElectronicInvoiceLoadSummary.class, criteria)));
    }

    @Override
    public List getPendingElectronicInvoices() {
        LOG.debug("getPendingElectronicInvoices() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("status.code", (Object)"Pending Route Electronic Invoice");
        criteria.addEqualTo("isElectronicInvoice", (Object)Boolean.TRUE);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PaymentRequestDocument.class, criteria));
    }

    @Override
    public Map getDefaultItemMappingMap() {
        LOG.debug("getDefaultItemMappingMap() started");
        Criteria criteria = new Criteria();
        criteria.addIsNull("vendorHeaderGeneratedIdentifier");
        criteria.addIsNull("vendorDetailAssignedIdentifier");
        criteria.addEqualTo("active", (Object)true);
        return this.getItemMappingMap(criteria);
    }

    @Override
    public Map getItemMappingMap(Integer vendorHeaderId, Integer vendorDetailId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getItemMappingMap() started for vendor id " + vendorHeaderId + "-" + vendorDetailId);
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("vendorHeaderGeneratedIdentifier", (Object)vendorHeaderId);
        criteria.addEqualTo("vendorDetailAssignedIdentifier", (Object)vendorDetailId);
        criteria.addEqualTo("active", (Object)true);
        return this.getItemMappingMap(criteria);
    }

    protected Map getItemMappingMap(Criteria criteria) {
        HashMap<String, ElectronicInvoiceItemMapping> hm = new HashMap<String, ElectronicInvoiceItemMapping>();
        List itemMappings = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ElectronicInvoiceItemMapping.class, criteria));
        for (Object itemMapping : itemMappings) {
            ElectronicInvoiceItemMapping mapping = (ElectronicInvoiceItemMapping)((Object)itemMapping);
            hm.put(mapping.getInvoiceItemTypeCode(), mapping);
        }
        return hm;
    }
}

