/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.ReceivingDocumentBase;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.BulkReceivingService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.module.purap.util.PurapSearchUtils;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.LocationService;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class BulkReceivingDocument
extends ReceivingDocumentBase {
    protected static final Logger LOG = LogManager.getLogger(BulkReceivingDocument.class);
    protected String shipmentWeight;
    protected Integer noOfCartons;
    protected String trackingNumber;
    protected String vendorAddressInternationalProvinceName;
    protected String vendorNoteText;
    protected Integer goodsDeliveredVendorHeaderGeneratedIdentifier;
    protected Integer goodsDeliveredVendorDetailAssignedIdentifier;
    protected String goodsDeliveredVendorNumber;
    protected String deliveryAdditionalInstructionText;
    protected String requestorPersonName;
    protected String requestorPersonPhoneNumber;
    protected String requestorPersonEmailAddress;
    protected String preparerPersonName;
    protected String preparerPersonPhoneNumber;
    protected String deliveryCampusName;
    protected String institutionContactName;
    protected String institutionContactPhoneNumber;
    protected String institutionContactEmailAddress;
    protected VendorDetail alternateVendorDetail;
    protected String goodsDeliveredVendorName;
    protected String vendorContact;

    @Override
    public void initiateDocument() {
        this.setShipmentReceivedDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate());
    }

    public void populateBulkReceivingFromPurchaseOrder(PurchaseOrderDocument po) {
        this.setPurchaseOrderIdentifier(po.getPurapDocumentIdentifier());
        this.getDocumentHeader().setOrganizationDocumentNumber(po.getDocumentHeader().getOrganizationDocumentNumber());
        this.setAccountsPayablePurchasingDocumentLinkIdentifier(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
        this.setVendorHeaderGeneratedIdentifier(po.getVendorHeaderGeneratedIdentifier());
        this.setVendorDetailAssignedIdentifier(po.getVendorDetailAssignedIdentifier());
        this.setVendorName(po.getVendorName());
        this.setVendorNumber(po.getVendorNumber());
        this.setVendorLine1Address(po.getVendorLine1Address());
        this.setVendorLine2Address(po.getVendorLine2Address());
        this.setVendorCityName(po.getVendorCityName());
        this.setVendorStateCode(po.getVendorStateCode());
        this.setVendorPostalCode(po.getVendorPostalCode());
        this.setVendorCountryCode(po.getVendorCountryCode());
        this.setVendorDetail(po.getVendorDetail());
        this.setVendorNumber(po.getVendorNumber());
        this.setVendorAddressInternationalProvinceName(po.getVendorAddressInternationalProvinceName());
        this.setVendorNoteText(po.getVendorNoteText());
        this.setVendorAddressGeneratedIdentifier(po.getVendorAddressGeneratedIdentifier());
        this.setAlternateVendorName(po.getAlternateVendorName());
        this.setAlternateVendorNumber(StringUtils.isEmpty((CharSequence)po.getAlternateVendorNumber()) ? null : po.getAlternateVendorNumber());
        this.setAlternateVendorDetailAssignedIdentifier(po.getAlternateVendorDetailAssignedIdentifier());
        this.setAlternateVendorHeaderGeneratedIdentifier(po.getAlternateVendorHeaderGeneratedIdentifier());
        this.setDeliveryBuildingCode(po.getDeliveryBuildingCode());
        this.setDeliveryBuildingLine1Address(po.getDeliveryBuildingLine1Address());
        this.setDeliveryBuildingLine2Address(po.getDeliveryBuildingLine2Address());
        this.setDeliveryBuildingName(po.getDeliveryBuildingName());
        this.setDeliveryBuildingRoomNumber(po.getDeliveryBuildingRoomNumber());
        this.setDeliveryCampusCode(po.getDeliveryCampusCode());
        this.setDeliveryCityName(po.getDeliveryCityName());
        this.setDeliveryCountryCode(po.getDeliveryCountryCode());
        this.setDeliveryInstructionText(po.getDeliveryInstructionText());
        this.setDeliveryPostalCode(po.getDeliveryPostalCode());
        this.setDeliveryStateCode(po.getDeliveryStateCode());
        this.setDeliveryToEmailAddress(po.getDeliveryToEmailAddress());
        this.setDeliveryToName(po.getDeliveryToName());
        this.setDeliveryToPhoneNumber(po.getDeliveryToPhoneNumber());
        this.setInstitutionContactName(po.getInstitutionContactName());
        this.setInstitutionContactPhoneNumber(po.getInstitutionContactPhoneNumber());
        this.setInstitutionContactEmailAddress(po.getInstitutionContactEmailAddress());
        this.setRequestorPersonName(po.getRequestorPersonName());
        this.setRequestorPersonPhoneNumber(po.getRequestorPersonPhoneNumber());
        this.setRequestorPersonEmailAddress(po.getRequestorPersonEmailAddress());
        RequisitionDocument reqDoc = ((RequisitionService)SpringContext.getBean(RequisitionService.class)).getRequisitionById(po.getRequisitionIdentifier());
        if (reqDoc != null) {
            String requisitionPreparer = reqDoc.getFinancialSystemDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
            Person initiatorUser = KimApiServiceLocator.getPersonService().getPerson(requisitionPreparer);
            this.setPreparerPersonName(initiatorUser.getName());
        }
        if (this.getVendorNumber() != null) {
            this.setGoodsDeliveredVendorHeaderGeneratedIdentifier(this.getVendorHeaderGeneratedIdentifier());
            this.setGoodsDeliveredVendorDetailAssignedIdentifier(this.getVendorDetailAssignedIdentifier());
            this.setGoodsDeliveredVendorNumber(this.getVendorNumber());
            this.setGoodsDeliveredVendorName(this.getVendorName());
        }
        this.populateVendorDetails();
        this.populateDocumentDescription(po);
    }

    protected void populateVendorDetails() {
        VendorDetail tempVendor;
        if (this.getVendorHeaderGeneratedIdentifier() != null && this.getVendorDetailAssignedIdentifier() != null) {
            tempVendor = new VendorDetail();
            tempVendor.setVendorHeaderGeneratedIdentifier(this.getVendorHeaderGeneratedIdentifier());
            tempVendor.setVendorDetailAssignedIdentifier(this.getVendorDetailAssignedIdentifier());
            this.setVendorNumber(tempVendor.getVendorNumber());
        }
        if (this.getAlternateVendorHeaderGeneratedIdentifier() != null && this.getAlternateVendorDetailAssignedIdentifier() != null) {
            VendorDetail vendorDetail = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDetail(this.getAlternateVendorHeaderGeneratedIdentifier(), this.getAlternateVendorDetailAssignedIdentifier());
            String userCampus = GlobalVariables.getUserSession().getPerson().getCampusCode();
            VendorAddress vendorAddress = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDefaultAddress(this.getAlternateVendorHeaderGeneratedIdentifier(), this.getAlternateVendorDetailAssignedIdentifier(), "RM", userCampus);
            if (vendorAddress == null) {
                vendorAddress = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDefaultAddress(this.getAlternateVendorHeaderGeneratedIdentifier(), this.getAlternateVendorDetailAssignedIdentifier(), "PO", userCampus);
            }
            if (vendorAddress != null) {
                this.setAlternateVendorName(vendorDetail.getVendorName());
                this.setAlternateVendorNumber(vendorDetail.getVendorNumber());
                vendorDetail.setDefaultAddressLine1(vendorAddress.getVendorLine1Address());
                vendorDetail.setDefaultAddressLine2(vendorAddress.getVendorLine2Address());
                vendorDetail.setDefaultAddressCity(vendorAddress.getVendorCityName());
                vendorDetail.setDefaultAddressCountryCode(vendorAddress.getVendorCountryCode());
                vendorDetail.setDefaultAddressPostalCode(vendorAddress.getVendorZipCode());
                vendorDetail.setDefaultAddressStateCode(vendorAddress.getVendorStateCode());
                vendorDetail.setDefaultAddressInternationalProvince(vendorAddress.getVendorAddressInternationalProvinceName());
            }
            this.setAlternateVendorDetail(vendorDetail);
        }
        if (this.getGoodsDeliveredVendorHeaderGeneratedIdentifier() != null && this.getGoodsDeliveredVendorDetailAssignedIdentifier() != null) {
            tempVendor = new VendorDetail();
            tempVendor.setVendorHeaderGeneratedIdentifier(this.getGoodsDeliveredVendorHeaderGeneratedIdentifier());
            tempVendor.setVendorDetailAssignedIdentifier(this.getGoodsDeliveredVendorDetailAssignedIdentifier());
            this.setGoodsDeliveredVendorNumber(tempVendor.getVendorNumber());
            if (StringUtils.equals((CharSequence)this.getVendorNumber(), (CharSequence)this.getGoodsDeliveredVendorNumber())) {
                this.setGoodsDeliveredVendorName(this.getVendorName());
            } else {
                this.setGoodsDeliveredVendorName(this.getAlternateVendorName());
            }
        }
    }

    public void clearInitFields() {
        this.getDocumentHeader().setDocumentDescription(null);
        this.getDocumentHeader().setExplanation(null);
        this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(null);
        this.getDocumentHeader().setOrganizationDocumentNumber(null);
        this.setPurchaseOrderIdentifier(null);
        this.setShipmentReceivedDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate());
        this.setShipmentPackingSlipNumber(null);
        this.setShipmentBillOfLadingNumber(null);
        this.setCarrierCode(null);
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        this.refreshNonUpdateableReferences();
        this.populateVendorDetails();
    }

    public void prepareForSave(KualiDocumentEvent event) {
        if (event instanceof AttributedContinuePurapEvent) {
            ((BulkReceivingService)SpringContext.getBean(BulkReceivingService.class)).populateBulkReceivingFromPurchaseOrder(this);
            if (this.getPurchaseOrderIdentifier() == null) {
                this.getDocumentHeader().setDocumentDescription("Not associated with a PO");
            }
        } else if (this.getGoodsDeliveredVendorNumber() != null) {
            VendorDetail tempVendor = new VendorDetail();
            tempVendor.setVendorNumber(this.getGoodsDeliveredVendorNumber());
            this.setGoodsDeliveredVendorHeaderGeneratedIdentifier(tempVendor.getVendorHeaderGeneratedIdentifier());
            this.setGoodsDeliveredVendorDetailAssignedIdentifier(tempVendor.getVendorDetailAssignedIdentifier());
        }
        super.prepareForSave(event);
    }

    protected void populateDocumentDescription(PurchaseOrderDocument poDocument) {
        String description = "PO: " + poDocument.getPurapDocumentIdentifier() + " Vendor: " + poDocument.getVendorName();
        int noteTextMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(DocumentHeader.class, "documentDescription");
        if (noteTextMaxLength < description.length()) {
            description = description.substring(0, noteTextMaxLength);
        }
        this.getDocumentHeader().setDocumentDescription(description);
    }

    @Override
    public String getDeliveryCountryName() {
        Country country;
        if (StringUtils.isNotBlank((CharSequence)this.getDeliveryCountryCode()) && (country = ((LocationService)SpringContext.getBean(LocationService.class, (String)"locationService-fin")).getCountry(this.getDeliveryCountryCode())) != null) {
            return country.getName();
        }
        return null;
    }

    public String getGoodsDeliveredVendorNumber() {
        return this.goodsDeliveredVendorNumber;
    }

    public void setGoodsDeliveredVendorNumber(String goodsDeliveredVendorNumber) {
        this.goodsDeliveredVendorNumber = goodsDeliveredVendorNumber;
    }

    public Integer getNoOfCartons() {
        return this.noOfCartons;
    }

    public void setNoOfCartons(Integer noOfCartons) {
        this.noOfCartons = noOfCartons;
    }

    public String getVendorContact() {
        return this.vendorContact;
    }

    public void setVendorContact(String vendorContact) {
        this.vendorContact = vendorContact;
    }

    public VendorDetail getAlternateVendorDetail() {
        return this.alternateVendorDetail;
    }

    public void setAlternateVendorDetail(VendorDetail alternateVendorDetail) {
        this.alternateVendorDetail = alternateVendorDetail;
    }

    public String getShipmentWeight() {
        return this.shipmentWeight;
    }

    public void setShipmentWeight(String shipmentWeight) {
        this.shipmentWeight = shipmentWeight;
    }

    public String getGoodsDeliveredVendorName() {
        return this.goodsDeliveredVendorName;
    }

    public void setGoodsDeliveredVendorName(String goodsDeliveredVendorName) {
        this.goodsDeliveredVendorName = goodsDeliveredVendorName;
    }

    public String getVendorAddressInternationalProvinceName() {
        return this.vendorAddressInternationalProvinceName;
    }

    public void setVendorAddressInternationalProvinceName(String vendorAddressInternationalProvinceName) {
        this.vendorAddressInternationalProvinceName = vendorAddressInternationalProvinceName;
    }

    public String getDeliveryCampusName() {
        return this.deliveryCampusName;
    }

    public void setDeliveryCampusName(String deliveryCampusName) {
        this.deliveryCampusName = deliveryCampusName;
    }

    public String getRequestorPersonName() {
        return this.requestorPersonName;
    }

    public void setRequestorPersonName(String requestorPersonName) {
        this.requestorPersonName = requestorPersonName;
    }

    public String getRequestorPersonPhoneNumber() {
        return this.requestorPersonPhoneNumber;
    }

    public void setRequestorPersonPhoneNumber(String requestorPersonPhoneNumber) {
        this.requestorPersonPhoneNumber = requestorPersonPhoneNumber;
    }

    public String getPreparerPersonName() {
        return this.preparerPersonName;
    }

    public void setPreparerPersonName(String preparerPersonName) {
        this.preparerPersonName = preparerPersonName;
    }

    public String getPreparerPersonPhoneNumber() {
        return this.preparerPersonPhoneNumber;
    }

    public void setPreparerPersonPhoneNumber(String preparerPersonPhoneNumber) {
        this.preparerPersonPhoneNumber = preparerPersonPhoneNumber;
    }

    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getVendorNoteText() {
        return this.vendorNoteText;
    }

    public void setVendorNoteText(String vendorNoteText) {
        this.vendorNoteText = vendorNoteText;
    }

    public String getRequestorPersonEmailAddress() {
        return this.requestorPersonEmailAddress;
    }

    public void setRequestorPersonEmailAddress(String requestorPersonEmailAddress) {
        this.requestorPersonEmailAddress = requestorPersonEmailAddress;
    }

    public String getInstitutionContactEmailAddress() {
        return this.institutionContactEmailAddress;
    }

    public void setInstitutionContactEmailAddress(String institutionContactEmailAddress) {
        this.institutionContactEmailAddress = institutionContactEmailAddress;
    }

    public String getInstitutionContactName() {
        return this.institutionContactName;
    }

    public void setInstitutionContactName(String institutionContactName) {
        this.institutionContactName = institutionContactName;
    }

    public String getInstitutionContactPhoneNumber() {
        return this.institutionContactPhoneNumber;
    }

    public void setInstitutionContactPhoneNumber(String institutionContactPhoneNumber) {
        this.institutionContactPhoneNumber = institutionContactPhoneNumber;
    }

    public String getDeliveryAdditionalInstructionText() {
        return this.deliveryAdditionalInstructionText;
    }

    public void setDeliveryAdditionalInstructionText(String deliveryAdditionalInstructionText) {
        this.deliveryAdditionalInstructionText = deliveryAdditionalInstructionText;
    }

    public Integer getGoodsDeliveredVendorDetailAssignedIdentifier() {
        return this.goodsDeliveredVendorDetailAssignedIdentifier;
    }

    public void setGoodsDeliveredVendorDetailAssignedIdentifier(Integer goodsDeliveredVendorDetailAssignedIdentifier) {
        this.goodsDeliveredVendorDetailAssignedIdentifier = goodsDeliveredVendorDetailAssignedIdentifier;
    }

    public Integer getGoodsDeliveredVendorHeaderGeneratedIdentifier() {
        return this.goodsDeliveredVendorHeaderGeneratedIdentifier;
    }

    public void setGoodsDeliveredVendorHeaderGeneratedIdentifier(Integer goodsDeliveredVendorHeaderGeneratedIdentifier) {
        this.goodsDeliveredVendorHeaderGeneratedIdentifier = goodsDeliveredVendorHeaderGeneratedIdentifier;
    }

    @Override
    public boolean isBoNotesSupport() {
        return true;
    }

    @Override
    public String getWorkflowStatusForResult() {
        return PurapSearchUtils.getWorkFlowStatusString(this.getDocumentHeader());
    }

    @Override
    public Class getItemClass() {
        throw new UnsupportedOperationException("Items are not being handled in Bulk Receiving document");
    }

    @Override
    public <T> T getItem(int pos) {
        throw new UnsupportedOperationException("Items are not being handled in Bulk Receiving document");
    }

    @Override
    public List getItems() {
        throw new UnsupportedOperationException("Items are not being handled in Bulk Receiving document");
    }

    public void setItems(List items) {
        throw new UnsupportedOperationException("Items are not being handled in Bulk Receiving document");
    }
}

