/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.ReceivingDocumentBase;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.ReceivingService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class LineItemReceivingDocument
extends ReceivingDocumentBase {
    protected List<LineItemReceivingItem> items = new ArrayList<LineItemReceivingItem>();

    @Override
    public void initiateDocument() {
        super.initiateDocument();
        this.setAppDocStatus("In Process");
    }

    public void populateReceivingLineFromPurchaseOrder(PurchaseOrderDocument po) {
        this.setPurchaseOrderIdentifier(po.getPurapDocumentIdentifier());
        this.getDocumentHeader().setOrganizationDocumentNumber(po.getDocumentHeader().getOrganizationDocumentNumber());
        this.setAccountsPayablePurchasingDocumentLinkIdentifier(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
        this.setVendorHeaderGeneratedIdentifier(po.getVendorHeaderGeneratedIdentifier());
        this.setVendorDetailAssignedIdentifier(po.getVendorDetailAssignedIdentifier());
        this.setVendorName(po.getVendorName());
        this.setVendorNumber(po.getVendorNumber());
        this.setVendorAddressGeneratedIdentifier(po.getVendorAddressGeneratedIdentifier());
        this.setVendorLine1Address(po.getVendorLine1Address());
        this.setVendorLine2Address(po.getVendorLine2Address());
        this.setVendorCityName(po.getVendorCityName());
        this.setVendorStateCode(po.getVendorStateCode());
        this.setVendorPostalCode(po.getVendorPostalCode());
        this.setVendorCountryCode(po.getVendorCountryCode());
        this.setAlternateVendorName(po.getAlternateVendorName());
        this.setAlternateVendorNumber(po.getAlternateVendorNumber());
        this.setAlternateVendorDetailAssignedIdentifier(po.getAlternateVendorDetailAssignedIdentifier());
        this.setAlternateVendorHeaderGeneratedIdentifier(po.getAlternateVendorHeaderGeneratedIdentifier());
        this.setDeliveryBuildingCode(po.getDeliveryBuildingCode());
        this.setDeliveryBuildingLine1Address(po.getDeliveryBuildingLine1Address());
        this.setDeliveryBuildingLine2Address(po.getDeliveryBuildingLine2Address());
        this.setDeliveryBuildingName(po.getDeliveryBuildingName());
        this.setDeliveryBuildingRoomNumber(po.getDeliveryBuildingRoomNumber());
        this.setDeliveryCampusCode(po.getDeliveryCampusCode());
        this.setDeliveryCityName(po.getDeliveryCityName());
        this.setDeliveryCountryCode(po.getDeliveryCountryCode());
        this.setDeliveryInstructionText(po.getDeliveryInstructionText());
        this.setDeliveryPostalCode(po.getDeliveryPostalCode());
        this.setDeliveryRequiredDate(po.getDeliveryRequiredDate());
        this.setDeliveryRequiredDateReasonCode(po.getDeliveryRequiredDateReasonCode());
        this.setDeliveryStateCode(po.getDeliveryStateCode());
        this.setDeliveryToEmailAddress(po.getDeliveryToEmailAddress());
        this.setDeliveryToName(po.getDeliveryToName());
        this.setDeliveryToPhoneNumber(po.getDeliveryToPhoneNumber());
        for (PurchaseOrderItem poi : po.getItems()) {
            if (!poi.isItemActiveIndicator() || !poi.getItemType().isQuantityBasedGeneralLedgerIndicator() || !poi.getItemType().isLineItemIndicator()) continue;
            this.getItems().add(new LineItemReceivingItem(poi, this));
        }
        this.populateDocumentDescription(po);
    }

    public void clearInitFields(boolean fromPurchaseOrder) {
        this.getDocumentHeader().setDocumentDescription(null);
        this.getDocumentHeader().setExplanation(null);
        this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(null);
        this.getDocumentHeader().setOrganizationDocumentNumber(null);
        if (!fromPurchaseOrder) {
            this.setPurchaseOrderIdentifier(null);
        }
        this.setShipmentReceivedDate(null);
        this.setShipmentPackingSlipNumber(null);
        this.setShipmentBillOfLadingNumber(null);
        this.setCarrierCode(null);
    }

    public void prepareForSave(KualiDocumentEvent event) {
        if (event instanceof AttributedContinuePurapEvent) {
            ((ReceivingService)SpringContext.getBean(ReceivingService.class)).populateReceivingLineFromPurchaseOrder(this);
        }
        super.prepareForSave(event);
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
            this.setAppDocStatus("Cancelled");
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)this);
        }
    }

    public void doRouteLevelChange(DocumentRouteLevelChange change) {
        if (StringUtils.equals((CharSequence)"OutstandingTransactions", (CharSequence)change.getNewNodeName())) {
            this.setAppDocStatus("Awaiting Purchase Order Open Status");
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)this);
        } else if (StringUtils.equals((CharSequence)"Join", (CharSequence)change.getNewNodeName())) {
            this.setAppDocStatus("Complete");
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)this);
        }
        ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)this);
    }

    @Override
    public Class getItemClass() {
        return LineItemReceivingItem.class;
    }

    @Override
    public List getItems() {
        return this.items;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public LineItemReceivingItem getItem(int pos) {
        return this.items.get(pos);
    }

    public void addItem(LineItemReceivingItem item) {
        this.getItems().add(item);
    }

    public void deleteItem(int lineNum) {
        this.getItems().remove(lineNum);
    }

    protected void populateDocumentDescription(PurchaseOrderDocument poDocument) {
        String description = "PO: " + poDocument.getPurapDocumentIdentifier() + " Vendor: " + poDocument.getVendorName();
        int noteTextMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(DocumentHeader.class, "documentDescription");
        if (noteTextMaxLength < description.length()) {
            description = description.substring(0, noteTextMaxLength);
        }
        this.getDocumentHeader().setDocumentDescription(description);
    }

    protected boolean isRelatesToOutstandingTransactionsRequired() {
        return ((ReceivingService)SpringContext.getBean(ReceivingService.class)).hasNewUnorderedItem(this) && !((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).isPurchaseOrderOpenForProcessing(this.getPurchaseOrderDocument());
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("RelatesToOutstandingTransactions")) {
            return this.isRelatesToOutstandingTransactionsRequired();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getItems());
        return managedLists;
    }

    public KualiDecimal getTotalItemReceivedGivenLineNumber(Integer lineNumber) {
        for (LineItemReceivingItem item : this.items) {
            if (!item.getItemLineNumber().equals(lineNumber)) continue;
            return item.getItemReceivedTotalQuantity();
        }
        return new KualiDecimal(0);
    }
}

