/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.service.SufficientFundsService;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.NoteType;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.CreditMemoView;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderCapitalAssetSystem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorChoice;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.RecurringPaymentFrequency;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchasingDocumentBase;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.dataaccess.PurchaseOrderDao;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.PurchasingDocumentSpecificService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.MultiselectableDocSearchConversion;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.vnd.businessobject.ContractManager;
import org.kuali.kfs.vnd.businessobject.PaymentTermType;
import org.kuali.kfs.vnd.businessobject.ShippingPaymentTerms;
import org.kuali.kfs.vnd.businessobject.ShippingTitle;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class PurchaseOrderDocument
extends PurchasingDocumentBase
implements MultiselectableDocSearchConversion {
    private static final Logger LOG = LogManager.getLogger(PurchaseOrderDocument.class);
    protected Timestamp purchaseOrderCreateTimestamp;
    protected Integer requisitionIdentifier;
    protected String purchaseOrderVendorChoiceCode;
    protected String recurringPaymentFrequencyCode;
    protected KualiDecimal recurringPaymentAmount;
    protected Date recurringPaymentDate;
    protected KualiDecimal initialPaymentAmount;
    protected Date initialPaymentDate;
    protected KualiDecimal finalPaymentAmount;
    protected Date finalPaymentDate;
    protected Timestamp purchaseOrderInitialOpenTimestamp;
    protected Timestamp purchaseOrderLastTransmitTimestamp;
    protected Date purchaseOrderQuoteDueDate;
    protected String purchaseOrderQuoteTypeCode;
    protected String purchaseOrderQuoteVendorNoteText;
    protected boolean purchaseOrderConfirmedIndicator;
    protected String purchaseOrderCommodityDescription;
    protected Integer purchaseOrderPreviousIdentifier;
    protected Integer alternateVendorHeaderGeneratedIdentifier;
    protected Integer alternateVendorDetailAssignedIdentifier;
    protected Integer newQuoteVendorHeaderGeneratedIdentifier;
    protected Integer newQuoteVendorDetailAssignedIdentifier;
    protected String alternateVendorName;
    protected boolean purchaseOrderCurrentIndicator = false;
    protected boolean pendingActionIndicator = false;
    protected Timestamp purchaseOrderFirstTransmissionTimestamp;
    protected Integer contractManagerCode;
    protected Date purchaseOrderQuoteInitializationDate;
    protected Date purchaseOrderQuoteAwardedDate;
    protected String assignedUserPrincipalId;
    protected List<PurchaseOrderVendorStipulation> purchaseOrderVendorStipulations = new ArrayList<PurchaseOrderVendorStipulation>();
    protected List<PurchaseOrderVendorQuote> purchaseOrderVendorQuotes = new ArrayList<PurchaseOrderVendorQuote>();
    protected String statusChange;
    protected String alternateVendorNumber;
    protected String purchaseOrderRetransmissionMethodCode;
    protected String retransmitHeader;
    protected Integer purchaseOrderQuoteListIdentifier;
    protected KualiDecimal internalPurchasingLimit;
    protected boolean pendingSplit = false;
    protected boolean copyingNotesWhenSplitting;
    protected boolean assigningSensitiveData = false;
    protected List<PurchaseOrderSensitiveData> purchaseOrderSensitiveData;
    protected String assignedUserPrincipalName;
    protected List<SourceAccountingLine> glOnlySourceAccountingLines;
    protected PurchaseOrderVendorChoice purchaseOrderVendorChoice;
    protected PaymentTermType vendorPaymentTerms;
    protected ShippingTitle vendorShippingTitle;
    protected ShippingPaymentTerms vendorShippingPaymentTerms;
    protected RecurringPaymentFrequency recurringPaymentFrequency;
    protected ContractManager contractManager;

    @Override
    public PurchasingDocumentSpecificService getDocumentSpecificService() {
        return (PurchasingDocumentSpecificService)SpringContext.getBean(PurchaseOrderService.class);
    }

    @Override
    public boolean isInquiryRendered() {
        String applicationDocumentStatus = this.getApplicationDocumentStatus();
        return !this.isPostingYearPrior() || !"Closed".equals(applicationDocumentStatus) && !"Cancelled".equals(applicationDocumentStatus) && !"Void".equals(applicationDocumentStatus);
    }

    public String getDocumentTitle() {
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(PurchaseOrderDocument.class, "OVERRIDE_DOCUMENT_TITLE_IND").booleanValue()) {
            return this.getCustomDocumentTitle();
        }
        return this.buildDocumentTitle(super.getDocumentTitle());
    }

    protected String getCustomDocumentTitle() {
        String poNumber = this.getPurapDocumentIdentifier().toString();
        String cmCode = this.getContractManagerCode().toString();
        String vendorName = StringUtils.trimToEmpty((String)this.getVendorName());
        String totalAmount = this.getTotalDollarAmount().toString();
        PurApAccountingLine accountingLine = this.getFirstAccount();
        String chartAcctCode = accountingLine != null ? accountingLine.getChartOfAccountsCode() : "";
        String accountNumber = accountingLine != null ? accountingLine.getAccountNumber() : "";
        String chartCode = this.getChartOfAccountsCode();
        String orgCode = this.getOrganizationCode();
        String deliveryCampus = this.getDeliveryCampus() != null ? this.getDeliveryCampus().getCampus().getShortName() : "";
        String documentTitle = "";
        Set nodeNames = this.getFinancialSystemDocumentHeader().getWorkflowDocument().getCurrentNodeNames();
        String routeLevel = "";
        if (CollectionUtils.isNotEmpty((Collection)nodeNames) && nodeNames.size() >= 1) {
            routeLevel = (String)nodeNames.iterator().next();
        }
        documentTitle = StringUtils.equals((CharSequence)this.getApplicationDocumentStatus(), (CharSequence)"Open") ? super.getDocumentTitle() : (routeLevel.equals("Budget") || routeLevel.equals("Award") ? "PO: " + poNumber + " Account Number: " + chartAcctCode + "-" + accountNumber + " Dept: " + chartCode + "-" + orgCode + " Delivery Campus: " + deliveryCampus : (routeLevel.equals("Tax") ? "Vendor: " + vendorName + " PO: " + poNumber + " Account Number: " + chartCode + "-" + accountNumber + " Dept: " + chartCode + "-" + orgCode + " Delivery Campus: " + deliveryCampus : documentTitle + "PO: " + poNumber + " Contract Manager: " + cmCode + " Vendor: " + vendorName + " Amount: " + totalAmount));
        return documentTitle;
    }

    public Class getSourceAccountingLineClass() {
        return super.getSourceAccountingLineClass();
    }

    protected PurApAccountingLine getFirstAccount() {
        if (this.getItems() != null && !this.getItems().isEmpty()) {
            for (Object anItem : this.getItems()) {
                PurchaseOrderItem item = (PurchaseOrderItem)anItem;
                if (!item.isConsideredEntered() || item.getSourceAccountingLines() == null || item.getSourceAccountingLines().isEmpty()) continue;
                PurApAccountingLine accountingLine = item.getSourceAccountingLine(0);
                accountingLine.refreshNonUpdateableReferences();
                return accountingLine;
            }
        }
        return null;
    }

    public String getAssignedUserPrincipalId() {
        return this.assignedUserPrincipalId;
    }

    public void setAssignedUserPrincipalId(String assignedUserPrincipalId) {
        this.assignedUserPrincipalId = assignedUserPrincipalId;
    }

    public String getAssignedUserPrincipalName() {
        if (this.assignedUserPrincipalName == null && this.assignedUserPrincipalId != null) {
            Principal assignedUser = KimApiServiceLocator.getIdentityService().getPrincipal(this.assignedUserPrincipalId);
            this.assignedUserPrincipalName = assignedUser.getPrincipalName();
        }
        return this.assignedUserPrincipalName;
    }

    public void setAssignedUserPrincipalName(String assignedUserPrincipalName) {
        this.assignedUserPrincipalName = assignedUserPrincipalName;
        Principal assignedUser = null;
        if (assignedUserPrincipalName != null) {
            assignedUser = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(assignedUserPrincipalName);
        }
        this.assignedUserPrincipalId = assignedUser != null ? assignedUser.getPrincipalId() : null;
    }

    public boolean getAssigningSensitiveData() {
        return this.assigningSensitiveData;
    }

    public void setAssigningSensitiveData(boolean assigningSensitiveData) {
        this.assigningSensitiveData = assigningSensitiveData;
    }

    public List<PurchaseOrderSensitiveData> getPurchaseOrderSensitiveData() {
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put("purapDocumentIdentifier", this.getPurapDocumentIdentifier());
        return new ArrayList<PurchaseOrderSensitiveData>(((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(PurchaseOrderSensitiveData.class, fieldValues));
    }

    public void setPurchaseOrderSensitiveData(List<PurchaseOrderSensitiveData> purchaseOrderSensitiveData) {
        this.purchaseOrderSensitiveData = purchaseOrderSensitiveData;
    }

    public ContractManager getContractManager() {
        if (ObjectUtils.isNull((Object)this.contractManager)) {
            this.refreshReferenceObject("contractManager");
        }
        return this.contractManager;
    }

    public void setContractManager(ContractManager contractManager) {
        this.contractManager = contractManager;
    }

    public Integer getContractManagerCode() {
        return this.contractManagerCode;
    }

    public void setContractManagerCode(Integer contractManagerCode) {
        this.contractManagerCode = contractManagerCode;
    }

    @Override
    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getGeneralLedgerPendingEntries());
        if (this.allowDeleteAwareCollection) {
            managedLists.add(this.getPurchaseOrderVendorQuotes());
            managedLists.add(this.getPurchaseOrderVendorStipulations());
        }
        return managedLists;
    }

    @Override
    public Boolean getOverrideWorkflowButtons() {
        if (ObjectUtils.isNull((Object)super.getOverrideWorkflowButtons())) {
            this.setOverrideWorkflowButtons(Boolean.TRUE);
        }
        return super.getOverrideWorkflowButtons();
    }

    @Override
    public void customPrepareForSave(KualiDocumentEvent event) {
        super.customPrepareForSave(event);
        if (ObjectUtils.isNull((Object)this.getPurapDocumentIdentifier())) {
            SequenceAccessorService sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
            Long poSequenceNumber = sas.getNextAvailableSequenceNumber("PO_ID", this.getClass());
            this.setPurapDocumentIdentifier(poSequenceNumber.intValue());
        }
        for (Object anItem : this.getItems()) {
            PurchaseOrderItem item = (PurchaseOrderItem)anItem;
            item.setItemOutstandingEncumberedQuantity(item.getItemQuantity());
            if (item.getItemInvoicedTotalQuantity() == null) {
                item.setItemInvoicedTotalQuantity(KualiDecimal.ZERO);
            }
            if (item.getItemInvoicedTotalAmount() == null) {
                item.setItemInvoicedTotalAmount(KualiDecimal.ZERO);
            }
            item.setItemOutstandingEncumberedAmount(item.getTotalAmount() == null ? KualiDecimal.ZERO : item.getTotalAmount());
            List<PurApAccountingLine> accounts = item.getSourceAccountingLines();
            Collections.sort(accounts);
            for (PurApAccountingLine anAcct : accounts) {
                PurchaseOrderAccount account = (PurchaseOrderAccount)anAcct;
                if (account.isEmpty()) continue;
                account.setItemAccountOutstandingEncumbranceAmount(account.getAmount());
            }
        }
        this.setSourceAccountingLines(((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).generateSummaryWithNoZeroTotals(this.getItems()));
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        WorkflowDocument workFlowDocument = this.getFinancialSystemDocumentHeader().getWorkflowDocument();
        String documentType = workFlowDocument.getDocumentTypeName();
        if (documentType.equals("PO") || documentType.equals("POSP")) {
            if (workFlowDocument.isCanceled()) {
                this.setGeneralLedgerPendingEntries(new ArrayList());
            } else if (!workFlowDocument.isFinal()) {
                super.prepareForSave(event);
            }
        }
    }

    public void setDefaultValuesForAPO() {
        this.setPurchaseOrderAutomaticIndicator(Boolean.TRUE);
        if (!"B2B".equals(this.getRequisitionSourceCode())) {
            String paramName = "DEFAULT_APO_VENDOR_CHOICE";
            String paramValue = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(PurchaseOrderDocument.class, paramName);
            this.setPurchaseOrderVendorChoiceCode(paramValue);
        }
    }

    public void populatePurchaseOrderFromRequisition(RequisitionDocument requisitionDocument) {
        this.setPurchaseOrderCreateTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
        this.getDocumentHeader().setOrganizationDocumentNumber(requisitionDocument.getDocumentHeader().getOrganizationDocumentNumber());
        this.getDocumentHeader().setDocumentDescription(requisitionDocument.getDocumentHeader().getDocumentDescription());
        this.getDocumentHeader().setExplanation(requisitionDocument.getDocumentHeader().getExplanation());
        this.setBillingName(requisitionDocument.getBillingName());
        this.setBillingLine1Address(requisitionDocument.getBillingLine1Address());
        this.setBillingLine2Address(requisitionDocument.getBillingLine2Address());
        this.setBillingCityName(requisitionDocument.getBillingCityName());
        this.setBillingStateCode(requisitionDocument.getBillingStateCode());
        this.setBillingPostalCode(requisitionDocument.getBillingPostalCode());
        this.setBillingCountryCode(requisitionDocument.getBillingCountryCode());
        this.setBillingPhoneNumber(requisitionDocument.getBillingPhoneNumber());
        this.setBillingEmailAddress(requisitionDocument.getBillingEmailAddress());
        this.setReceivingName(requisitionDocument.getReceivingName());
        this.setReceivingCityName(requisitionDocument.getReceivingCityName());
        this.setReceivingLine1Address(requisitionDocument.getReceivingLine1Address());
        this.setReceivingLine2Address(requisitionDocument.getReceivingLine2Address());
        this.setReceivingStateCode(requisitionDocument.getReceivingStateCode());
        this.setReceivingPostalCode(requisitionDocument.getReceivingPostalCode());
        this.setReceivingCountryCode(requisitionDocument.getReceivingCountryCode());
        this.setAddressToVendorIndicator(requisitionDocument.getAddressToVendorIndicator());
        this.setDeliveryBuildingCode(requisitionDocument.getDeliveryBuildingCode());
        this.setDeliveryBuildingRoomNumber(requisitionDocument.getDeliveryBuildingRoomNumber());
        this.setDeliveryBuildingName(requisitionDocument.getDeliveryBuildingName());
        this.setDeliveryCampusCode(requisitionDocument.getDeliveryCampusCode());
        this.setDeliveryCityName(requisitionDocument.getDeliveryCityName());
        this.setDeliveryCountryCode(requisitionDocument.getDeliveryCountryCode());
        this.setDeliveryInstructionText(requisitionDocument.getDeliveryInstructionText());
        this.setDeliveryBuildingLine1Address(requisitionDocument.getDeliveryBuildingLine1Address());
        this.setDeliveryBuildingLine2Address(requisitionDocument.getDeliveryBuildingLine2Address());
        this.setDeliveryPostalCode(requisitionDocument.getDeliveryPostalCode());
        this.setDeliveryRequiredDate(requisitionDocument.getDeliveryRequiredDate());
        this.setDeliveryRequiredDateReasonCode(requisitionDocument.getDeliveryRequiredDateReasonCode());
        this.setDeliveryStateCode(requisitionDocument.getDeliveryStateCode());
        this.setDeliveryToEmailAddress(requisitionDocument.getDeliveryToEmailAddress());
        this.setDeliveryToName(requisitionDocument.getDeliveryToName());
        this.setDeliveryToPhoneNumber(requisitionDocument.getDeliveryToPhoneNumber());
        this.setDeliveryBuildingOtherIndicator(requisitionDocument.isDeliveryBuildingOtherIndicator());
        this.setPurchaseOrderBeginDate(requisitionDocument.getPurchaseOrderBeginDate());
        this.setPurchaseOrderCostSourceCode(requisitionDocument.getPurchaseOrderCostSourceCode());
        this.setPostingYear(requisitionDocument.getPostingYear());
        this.setPurchaseOrderEndDate(requisitionDocument.getPurchaseOrderEndDate());
        this.setChartOfAccountsCode(requisitionDocument.getChartOfAccountsCode());
        this.setDocumentFundingSourceCode(requisitionDocument.getDocumentFundingSourceCode());
        this.setInstitutionContactEmailAddress(requisitionDocument.getInstitutionContactEmailAddress());
        this.setInstitutionContactName(requisitionDocument.getInstitutionContactName());
        this.setInstitutionContactPhoneNumber(requisitionDocument.getInstitutionContactPhoneNumber());
        this.setNonInstitutionFundAccountNumber(requisitionDocument.getNonInstitutionFundAccountNumber());
        this.setNonInstitutionFundChartOfAccountsCode(requisitionDocument.getNonInstitutionFundChartOfAccountsCode());
        this.setNonInstitutionFundOrgChartOfAccountsCode(requisitionDocument.getNonInstitutionFundOrgChartOfAccountsCode());
        this.setNonInstitutionFundOrganizationCode(requisitionDocument.getNonInstitutionFundOrganizationCode());
        this.setOrganizationCode(requisitionDocument.getOrganizationCode());
        this.setRecurringPaymentTypeCode(requisitionDocument.getRecurringPaymentTypeCode());
        this.setRequestorPersonEmailAddress(requisitionDocument.getRequestorPersonEmailAddress());
        this.setRequestorPersonName(requisitionDocument.getRequestorPersonName());
        this.setRequestorPersonPhoneNumber(requisitionDocument.getRequestorPersonPhoneNumber());
        this.setRequisitionIdentifier(requisitionDocument.getPurapDocumentIdentifier());
        this.setPurchaseOrderTotalLimit(requisitionDocument.getPurchaseOrderTotalLimit());
        this.setPurchaseOrderTransmissionMethodCode(requisitionDocument.getPurchaseOrderTransmissionMethodCode());
        this.setUseTaxIndicator(requisitionDocument.isUseTaxIndicator());
        this.setVendorCityName(requisitionDocument.getVendorCityName());
        this.setVendorContractGeneratedIdentifier(requisitionDocument.getVendorContractGeneratedIdentifier());
        this.setVendorCountryCode(requisitionDocument.getVendorCountryCode());
        this.setVendorCustomerNumber(requisitionDocument.getVendorCustomerNumber());
        this.setVendorAttentionName(requisitionDocument.getVendorAttentionName());
        this.setVendorDetailAssignedIdentifier(requisitionDocument.getVendorDetailAssignedIdentifier());
        this.setVendorFaxNumber(requisitionDocument.getVendorFaxNumber());
        this.setVendorHeaderGeneratedIdentifier(requisitionDocument.getVendorHeaderGeneratedIdentifier());
        this.setVendorLine1Address(requisitionDocument.getVendorLine1Address());
        this.setVendorLine2Address(requisitionDocument.getVendorLine2Address());
        this.setVendorAddressInternationalProvinceName(requisitionDocument.getVendorAddressInternationalProvinceName());
        this.setVendorName(requisitionDocument.getVendorName());
        this.setVendorNoteText(requisitionDocument.getVendorNoteText());
        this.setVendorPhoneNumber(requisitionDocument.getVendorPhoneNumber());
        this.setVendorPostalCode(requisitionDocument.getVendorPostalCode());
        this.setVendorStateCode(requisitionDocument.getVendorStateCode());
        this.setVendorRestrictedIndicator(requisitionDocument.getVendorRestrictedIndicator());
        this.setJustification(requisitionDocument.getJustification());
        this.setExternalOrganizationB2bSupplierIdentifier(requisitionDocument.getExternalOrganizationB2bSupplierIdentifier());
        this.setRequisitionSourceCode(requisitionDocument.getRequisitionSourceCode());
        this.setAccountsPayablePurchasingDocumentLinkIdentifier(requisitionDocument.getAccountsPayablePurchasingDocumentLinkIdentifier());
        this.setReceivingDocumentRequiredIndicator(requisitionDocument.isReceivingDocumentRequiredIndicator());
        this.setPaymentRequestPositiveApprovalIndicator(requisitionDocument.isPaymentRequestPositiveApprovalIndicator());
        this.setApplicationDocumentStatus("In Process");
        this.setAccountDistributionMethod(requisitionDocument.getAccountDistributionMethod());
        ArrayList<PurchaseOrderItem> items = new ArrayList<PurchaseOrderItem>();
        for (PurApItem reqItem : requisitionDocument.getItems()) {
            RequisitionCapitalAssetItem reqCamsItem = (RequisitionCapitalAssetItem)requisitionDocument.getPurchasingCapitalAssetItemByItemIdentifier(reqItem.getItemIdentifier());
            items.add(new PurchaseOrderItem((RequisitionItem)reqItem, this, reqCamsItem));
        }
        this.setItems(items);
        this.setCapitalAssetSystemTypeCode(requisitionDocument.getCapitalAssetSystemTypeCode());
        this.setCapitalAssetSystemStateCode(requisitionDocument.getCapitalAssetSystemStateCode());
        for (CapitalAssetSystem capitalAssetSystem : requisitionDocument.getPurchasingCapitalAssetSystems()) {
            this.getPurchasingCapitalAssetSystems().add(new PurchaseOrderCapitalAssetSystem(capitalAssetSystem));
        }
        this.fixItemReferences();
    }

    public PurchaseOrderVendorStipulation getPurchaseOrderVendorStipulation(int index) {
        while (this.getPurchaseOrderVendorStipulations().size() <= index) {
            this.getPurchaseOrderVendorStipulations().add(new PurchaseOrderVendorStipulation());
        }
        return this.purchaseOrderVendorStipulations.get(index);
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        ArrayList<String> docIdStrings = new ArrayList<String>();
        docIdStrings.add(this.getDocumentNumber());
        String currentDocumentTypeName = this.getFinancialSystemDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List<PurchaseOrderView> relatedPoViews = this.getRelatedViews().getRelatedPurchaseOrderViews();
        for (PurchaseOrderView poView : relatedPoViews) {
            if (("In Process".equals(this.getApplicationDocumentStatus()) || "In Process".equals(this.getApplicationDocumentStatus())) && "POSP".equals(currentDocumentTypeName)) continue;
            docIdStrings.add(poView.getDocumentNumber());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("***** getWorkflowEngineDocumentIdsToLock(" + this.documentNumber + ") = '" + docIdStrings + "'");
        }
        return docIdStrings;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug("doRouteStatusChange() started");
        super.doRouteStatusChange(statusChangeEvent);
        String currentDocumentTypeName = this.getFinancialSystemDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        if ("PO".equals(currentDocumentTypeName) || "POSP".equals(currentDocumentTypeName)) {
            try {
                if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
                    ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).completePurchaseOrder(this);
                    ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).saveRoutingData(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
                } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
                    String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
                    String disapprovalStatus = this.findDisapprovalStatus(nodeName);
                    if (ObjectUtils.isNotNull((Object)disapprovalStatus)) {
                        this.updateAndSaveAppDocStatus(disapprovalStatus);
                    } else {
                        this.logAndThrowRuntimeException("No status found to set for document being disapproved in node '" + nodeName + "'");
                    }
                } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
                    this.updateAndSaveAppDocStatus("Cancelled");
                }
            }
            catch (WorkflowException e) {
                this.logAndThrowRuntimeException("Error saving routing data while saving document with id " + this.getDocumentNumber(), (Exception)((Object)e));
            }
        }
        if (this.shouldAdhocFyi()) {
            try {
                ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).saveRoutingData(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
            }
            catch (WorkflowException ex) {
                this.logAndThrowRuntimeException("Error saving routing data while saving document with id " + this.getDocumentNumber(), (Exception)((Object)ex));
            }
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).sendAdhocFyi(this);
        }
    }

    protected String findDisapprovalStatus(String nodeName) {
        return PurapConstants.PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(nodeName);
    }

    protected boolean shouldAdhocFyi() {
        Collection excludeList = new ArrayList();
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(PurchaseOrderDocument.class, "NOTIFY_REQUISITION_SOURCES").booleanValue()) {
            excludeList = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "NOTIFY_REQUISITION_SOURCES");
        }
        if (this.getDocumentHeader().getWorkflowDocument().isDisapproved() || this.getDocumentHeader().getWorkflowDocument().isCanceled()) {
            return true;
        }
        return this.getDocumentHeader().getWorkflowDocument().isFinal() && !excludeList.contains(this.getRequisitionSourceCode()) && !"Pending Print".equals(this.getApplicationDocumentStatus());
    }

    protected String getCurrentRouteNodeName(WorkflowDocument wd) throws WorkflowException {
        ArrayList nodeNames = new ArrayList(wd.getCurrentNodeNames());
        if (nodeNames.size() == 0) {
            return null;
        }
        return (String)nodeNames.get(0);
    }

    public void appSpecificRouteDocumentToUser(WorkflowDocument workflowDocument, String routePrincipalId, String annotation, String responsibility) throws WorkflowException {
        if (ObjectUtils.isNotNull((Object)workflowDocument)) {
            boolean isActiveUser = this.isActiveUser(routePrincipalId);
            HashMap<String, String> permissionDetails = new HashMap<String, String>();
            permissionDetails.put("documentTypeName", workflowDocument.getDocumentTypeName());
            permissionDetails.put("actionRequestCd", "F");
            boolean canReceiveAdHocRequest = KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(routePrincipalId, "KR-WKFLW", "Ad Hoc Review Document", permissionDetails, new HashMap());
            if (!isActiveUser || !canReceiveAdHocRequest) {
                String principalName = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(routePrincipalId).getName();
                String errorText = "cannot send FYI to the user: " + principalName + "; Annotation: " + annotation;
                LOG.info(errorText);
                Note note = ((DocumentService)SpringContext.getBean(DocumentService.class)).createNoteFromDocument((Document)this, errorText);
                this.addNote(((NoteService)SpringContext.getBean(NoteService.class)).save(note));
            } else {
                String annotationNote = ObjectUtils.isNull((Object)annotation) ? "" : annotation;
                String responsibilityNote = ObjectUtils.isNull((Object)responsibility) ? "" : responsibility;
                String currentNodeName = this.getCurrentRouteNodeName(workflowDocument);
                workflowDocument.adHocToPrincipal(ActionRequestType.FYI, currentNodeName, annotationNote, routePrincipalId, responsibilityNote, true);
            }
        }
    }

    protected boolean isActiveUser(String principalId) {
        Person principal = KimApiServiceLocator.getPersonService().getPerson(principalId);
        return ObjectUtils.isNotNull((Object)principal) && principal.isActive();
    }

    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
        LOG.debug("handleRouteLevelChange() started");
        super.doRouteLevelChange(levelChangeEvent);
    }

    public List getItemsActiveOnly() {
        ArrayList<PurchaseOrderItem> returnList = new ArrayList<PurchaseOrderItem>();
        for (Object anItem : this.getItems()) {
            PurchaseOrderItem item = (PurchaseOrderItem)anItem;
            if (!item.isItemActiveIndicator()) continue;
            returnList.add(item);
        }
        return returnList;
    }

    public List getItemsActiveOnlySetupAlternateAmount() {
        ArrayList<PurchaseOrderItem> returnList = new ArrayList<PurchaseOrderItem>();
        for (Object anItem : this.getItems()) {
            PurchaseOrderItem item = (PurchaseOrderItem)anItem;
            if (!item.isItemActiveIndicator()) continue;
            for (PurApAccountingLine purApAccountingLine : item.getSourceAccountingLines()) {
                PurchaseOrderAccount account = (PurchaseOrderAccount)purApAccountingLine;
                account.setAlternateAmountForGLEntryCreation(account.getItemAccountOutstandingEncumbranceAmount());
            }
            returnList.add(item);
        }
        return returnList;
    }

    public Integer getAlternateVendorDetailAssignedIdentifier() {
        return this.alternateVendorDetailAssignedIdentifier;
    }

    public void setAlternateVendorDetailAssignedIdentifier(Integer alternateVendorDetailAssignedIdentifier) {
        this.alternateVendorDetailAssignedIdentifier = alternateVendorDetailAssignedIdentifier;
    }

    public Integer getAlternateVendorHeaderGeneratedIdentifier() {
        return this.alternateVendorHeaderGeneratedIdentifier;
    }

    public void setAlternateVendorHeaderGeneratedIdentifier(Integer alternateVendorHeaderGeneratedIdentifier) {
        this.alternateVendorHeaderGeneratedIdentifier = alternateVendorHeaderGeneratedIdentifier;
    }

    public String getAlternateVendorName() {
        return this.alternateVendorName;
    }

    public void setAlternateVendorName(String alternateVendorName) {
        this.alternateVendorName = alternateVendorName;
    }

    public KualiDecimal getFinalPaymentAmount() {
        return this.finalPaymentAmount;
    }

    public void setFinalPaymentAmount(KualiDecimal finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
    }

    public Date getFinalPaymentDate() {
        return this.finalPaymentDate;
    }

    public void setFinalPaymentDate(Date finalPaymentDate) {
        this.finalPaymentDate = finalPaymentDate;
    }

    public KualiDecimal getInitialPaymentAmount() {
        return this.initialPaymentAmount;
    }

    public void setInitialPaymentAmount(KualiDecimal initialPaymentAmount) {
        this.initialPaymentAmount = initialPaymentAmount;
    }

    public Date getInitialPaymentDate() {
        return this.initialPaymentDate;
    }

    public void setInitialPaymentDate(Date initialPaymentDate) {
        this.initialPaymentDate = initialPaymentDate;
    }

    public String getPurchaseOrderCommodityDescription() {
        return this.purchaseOrderCommodityDescription;
    }

    public void setPurchaseOrderCommodityDescription(String purchaseOrderCommodityDescription) {
        this.purchaseOrderCommodityDescription = purchaseOrderCommodityDescription;
    }

    public boolean isPurchaseOrderConfirmedIndicator() {
        return this.purchaseOrderConfirmedIndicator;
    }

    public void setPurchaseOrderConfirmedIndicator(boolean purchaseOrderConfirmedIndicator) {
        this.purchaseOrderConfirmedIndicator = purchaseOrderConfirmedIndicator;
    }

    public Timestamp getPurchaseOrderCreateTimestamp() {
        return this.purchaseOrderCreateTimestamp;
    }

    public void setPurchaseOrderCreateTimestamp(Timestamp purchaseOrderCreateTimestamp) {
        this.purchaseOrderCreateTimestamp = purchaseOrderCreateTimestamp;
    }

    public Timestamp getPurchaseOrderInitialOpenTimestamp() {
        return this.purchaseOrderInitialOpenTimestamp;
    }

    public void setPurchaseOrderInitialOpenTimestamp(Timestamp purchaseOrderInitialOpenDate) {
        this.purchaseOrderInitialOpenTimestamp = purchaseOrderInitialOpenDate;
    }

    public Timestamp getPurchaseOrderLastTransmitTimestamp() {
        return this.purchaseOrderLastTransmitTimestamp;
    }

    public void setPurchaseOrderLastTransmitTimestamp(Timestamp PurchaseOrderLastTransmitTimestamp) {
        this.purchaseOrderLastTransmitTimestamp = PurchaseOrderLastTransmitTimestamp;
    }

    public Integer getPurchaseOrderPreviousIdentifier() {
        return this.purchaseOrderPreviousIdentifier;
    }

    public void setPurchaseOrderPreviousIdentifier(Integer purchaseOrderPreviousIdentifier) {
        this.purchaseOrderPreviousIdentifier = purchaseOrderPreviousIdentifier;
    }

    public Date getPurchaseOrderQuoteDueDate() {
        return this.purchaseOrderQuoteDueDate;
    }

    public void setPurchaseOrderQuoteDueDate(Date purchaseOrderQuoteDueDate) {
        this.purchaseOrderQuoteDueDate = purchaseOrderQuoteDueDate;
    }

    public String getPurchaseOrderQuoteTypeDescription() {
        String description = this.purchaseOrderQuoteTypeCode;
        if ("COMP".equals(this.purchaseOrderQuoteTypeCode)) {
            description = "Competitive";
        } else if ("CONF".equals(this.purchaseOrderQuoteTypeCode)) {
            description = "Price Confirmation";
        }
        return description;
    }

    public String getPurchaseOrderQuoteTypeCode() {
        return this.purchaseOrderQuoteTypeCode;
    }

    public void setPurchaseOrderQuoteTypeCode(String purchaseOrderQuoteTypeCode) {
        this.purchaseOrderQuoteTypeCode = purchaseOrderQuoteTypeCode;
    }

    public String getPurchaseOrderQuoteVendorNoteText() {
        return this.purchaseOrderQuoteVendorNoteText;
    }

    public void setPurchaseOrderQuoteVendorNoteText(String purchaseOrderQuoteVendorNoteText) {
        this.purchaseOrderQuoteVendorNoteText = purchaseOrderQuoteVendorNoteText;
    }

    public String getPurchaseOrderVendorChoiceCode() {
        return this.purchaseOrderVendorChoiceCode;
    }

    public void setPurchaseOrderVendorChoiceCode(String purchaseOrderVendorChoiceCode) {
        this.purchaseOrderVendorChoiceCode = purchaseOrderVendorChoiceCode;
    }

    public KualiDecimal getRecurringPaymentAmount() {
        return this.recurringPaymentAmount;
    }

    public void setRecurringPaymentAmount(KualiDecimal recurringPaymentAmount) {
        this.recurringPaymentAmount = recurringPaymentAmount;
    }

    public Date getRecurringPaymentDate() {
        return this.recurringPaymentDate;
    }

    public void setRecurringPaymentDate(Date recurringPaymentDate) {
        this.recurringPaymentDate = recurringPaymentDate;
    }

    public String getRecurringPaymentFrequencyCode() {
        return this.recurringPaymentFrequencyCode;
    }

    public void setRecurringPaymentFrequencyCode(String recurringPaymentFrequencyCode) {
        this.recurringPaymentFrequencyCode = recurringPaymentFrequencyCode;
    }

    public Integer getRequisitionIdentifier() {
        return this.requisitionIdentifier;
    }

    public void setRequisitionIdentifier(Integer requisitionIdentifier) {
        this.requisitionIdentifier = requisitionIdentifier;
    }

    public PurchaseOrderVendorChoice getPurchaseOrderVendorChoice() {
        return this.purchaseOrderVendorChoice;
    }

    public void setPurchaseOrderVendorChoice(PurchaseOrderVendorChoice purchaseOrderVendorChoice) {
        this.purchaseOrderVendorChoice = purchaseOrderVendorChoice;
    }

    public RecurringPaymentFrequency getRecurringPaymentFrequency() {
        return this.recurringPaymentFrequency;
    }

    public void setRecurringPaymentFrequency(RecurringPaymentFrequency recurringPaymentFrequency) {
        this.recurringPaymentFrequency = recurringPaymentFrequency;
    }

    public PaymentTermType getVendorPaymentTerms() {
        return this.vendorPaymentTerms;
    }

    public void setVendorPaymentTerms(PaymentTermType vendorPaymentTerms) {
        this.vendorPaymentTerms = vendorPaymentTerms;
    }

    public ShippingPaymentTerms getVendorShippingPaymentTerms() {
        return this.vendorShippingPaymentTerms;
    }

    public void setVendorShippingPaymentTerms(ShippingPaymentTerms vendorShippingPaymentTerms) {
        this.vendorShippingPaymentTerms = vendorShippingPaymentTerms;
    }

    public ShippingTitle getVendorShippingTitle() {
        if (ObjectUtils.isNull((Object)this.vendorShippingTitle)) {
            this.refreshReferenceObject("vendorShippingTitle");
        }
        return this.vendorShippingTitle;
    }

    public void setVendorShippingTitle(ShippingTitle vendorShippingTitle) {
        this.vendorShippingTitle = vendorShippingTitle;
    }

    public List getPurchaseOrderVendorStipulations() {
        return this.purchaseOrderVendorStipulations;
    }

    public String getStatusChange() {
        return this.statusChange;
    }

    public void setPurchaseOrderVendorStipulations(List purchaseOrderVendorStipulations) {
        this.purchaseOrderVendorStipulations = purchaseOrderVendorStipulations;
    }

    public List<PurchaseOrderVendorQuote> getPurchaseOrderVendorQuotes() {
        return this.purchaseOrderVendorQuotes;
    }

    public void setPurchaseOrderVendorQuotes(List<PurchaseOrderVendorQuote> purchaseOrderVendorQuotes) {
        this.purchaseOrderVendorQuotes = purchaseOrderVendorQuotes;
    }

    public PurchaseOrderVendorQuote getPurchaseOrderVendorQuote(int index) {
        while (this.getPurchaseOrderVendorQuotes().size() <= index) {
            this.getPurchaseOrderVendorQuotes().add(new PurchaseOrderVendorQuote());
        }
        return this.purchaseOrderVendorQuotes.get(index);
    }

    public void setStatusChange(String statusChange) {
        this.statusChange = statusChange;
    }

    public String getPurchaseOrderRetransmissionMethodCode() {
        return this.purchaseOrderRetransmissionMethodCode;
    }

    public void setPurchaseOrderRetransmissionMethodCode(String purchaseOrderRetransmissionMethodCode) {
        this.purchaseOrderRetransmissionMethodCode = purchaseOrderRetransmissionMethodCode;
    }

    public String getRetransmitHeader() {
        return this.retransmitHeader;
    }

    public void setRetransmitHeader(String retransmitHeader) {
        this.retransmitHeader = retransmitHeader;
    }

    public boolean isPendingActionIndicator() {
        return this.pendingActionIndicator;
    }

    public void setPendingActionIndicator(boolean pendingActionIndicator) {
        this.pendingActionIndicator = pendingActionIndicator;
    }

    public boolean isPurchaseOrderCurrentIndicator() {
        return this.purchaseOrderCurrentIndicator;
    }

    public void setPurchaseOrderCurrentIndicator(boolean purchaseOrderCurrentIndicator) {
        this.purchaseOrderCurrentIndicator = purchaseOrderCurrentIndicator;
    }

    public Timestamp getPurchaseOrderFirstTransmissionTimestamp() {
        return this.purchaseOrderFirstTransmissionTimestamp;
    }

    public void setPurchaseOrderFirstTransmissionTimestamp(Timestamp purchaseOrderFirstTransmissionTimestamp) {
        this.purchaseOrderFirstTransmissionTimestamp = purchaseOrderFirstTransmissionTimestamp;
    }

    public Date getPurchaseOrderQuoteAwardedDate() {
        return this.purchaseOrderQuoteAwardedDate;
    }

    public void setPurchaseOrderQuoteAwardedDate(Date purchaseOrderQuoteAwardedDate) {
        this.purchaseOrderQuoteAwardedDate = purchaseOrderQuoteAwardedDate;
    }

    public Date getPurchaseOrderQuoteInitializationDate() {
        return this.purchaseOrderQuoteInitializationDate;
    }

    public void setPurchaseOrderQuoteInitializationDate(Date purchaseOrderQuoteInitializationDate) {
        this.purchaseOrderQuoteInitializationDate = purchaseOrderQuoteInitializationDate;
    }

    public String getAlternateVendorNumber() {
        String hdrGenId = "";
        String detAssgndId = "";
        String vendorNumber = "";
        if (this.alternateVendorHeaderGeneratedIdentifier != null) {
            hdrGenId = this.alternateVendorHeaderGeneratedIdentifier.toString();
        }
        if (this.alternateVendorDetailAssignedIdentifier != null) {
            detAssgndId = this.alternateVendorDetailAssignedIdentifier.toString();
        }
        if (!StringUtils.isEmpty((CharSequence)hdrGenId) && !StringUtils.isEmpty((CharSequence)detAssgndId)) {
            vendorNumber = hdrGenId + "-" + detAssgndId;
        }
        return vendorNumber;
    }

    public void setAlternateVendorNumber(String vendorNumber) {
        if (!StringUtils.isEmpty((CharSequence)vendorNumber)) {
            int dashInd = vendorNumber.indexOf("-");
            if (vendorNumber.length() >= dashInd) {
                String vndrHdrGenId = vendorNumber.substring(0, dashInd);
                String vndrDetailAssignedId = vendorNumber.substring(dashInd + 1);
                if (!StringUtils.isEmpty((CharSequence)vndrHdrGenId) && !StringUtils.isEmpty((CharSequence)vndrDetailAssignedId)) {
                    this.alternateVendorHeaderGeneratedIdentifier = new Integer(vndrHdrGenId);
                    this.alternateVendorDetailAssignedIdentifier = new Integer(vndrDetailAssignedId);
                }
            }
        } else {
            this.alternateVendorNumber = vendorNumber;
        }
    }

    public void templateAlternateVendor(VendorDetail vendorDetail) {
        if (vendorDetail == null) {
            return;
        }
        this.setAlternateVendorNumber(vendorDetail.getVendorHeaderGeneratedIdentifier() + "-" + vendorDetail.getVendorDetailAssignedIdentifier());
        this.setAlternateVendorName(vendorDetail.getVendorName());
    }

    @Override
    public Class getItemClass() {
        return PurchaseOrderItem.class;
    }

    @Override
    public Class getItemUseTaxClass() {
        return PurchaseOrderItemUseTax.class;
    }

    @Override
    public RequisitionDocument getPurApSourceDocumentIfPossible() {
        RequisitionDocument sourceDoc = null;
        if (ObjectUtils.isNotNull((Object)this.getRequisitionIdentifier())) {
            sourceDoc = ((RequisitionService)SpringContext.getBean(RequisitionService.class)).getRequisitionById(this.getRequisitionIdentifier());
        }
        return sourceDoc;
    }

    @Override
    public String getPurApSourceDocumentLabelIfPossible() {
        return ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentLabelByTypeName("REQS");
    }

    public Integer getNewQuoteVendorDetailAssignedIdentifier() {
        return this.newQuoteVendorDetailAssignedIdentifier;
    }

    public void setNewQuoteVendorDetailAssignedIdentifier(Integer newQuoteVendorDetailAssignedIdentifier) {
        this.newQuoteVendorDetailAssignedIdentifier = newQuoteVendorDetailAssignedIdentifier;
    }

    public Integer getNewQuoteVendorHeaderGeneratedIdentifier() {
        return this.newQuoteVendorHeaderGeneratedIdentifier;
    }

    public void setNewQuoteVendorHeaderGeneratedIdentifier(Integer newQuoteVendorHeaderGeneratedIdentifier) {
        this.newQuoteVendorHeaderGeneratedIdentifier = newQuoteVendorHeaderGeneratedIdentifier;
    }

    public Integer getPurchaseOrderQuoteListIdentifier() {
        return this.purchaseOrderQuoteListIdentifier;
    }

    public void setPurchaseOrderQuoteListIdentifier(Integer purchaseOrderQuoteListIdentifier) {
        this.purchaseOrderQuoteListIdentifier = purchaseOrderQuoteListIdentifier;
    }

    public boolean isPurchaseOrderAwarded() {
        return this.getAwardedVendorQuote() != null;
    }

    public PurchaseOrderVendorQuote getAwardedVendorQuote() {
        for (PurchaseOrderVendorQuote vendorQuote : this.purchaseOrderVendorQuotes) {
            if (vendorQuote.getPurchaseOrderQuoteAwardTimestamp() == null) continue;
            return vendorQuote;
        }
        return null;
    }

    @Override
    public KualiDecimal getTotalDollarAmount() {
        return this.getTotalDollarAmount(false, true);
    }

    @Override
    public KualiDecimal getTotalDollarAmountAboveLineItems() {
        return this.getTotalDollarAmount(false, false);
    }

    public KualiDecimal getTotalDollarAmount(boolean includeInactive, boolean includeBelowTheLine) {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurApItem item : this.getItems()) {
            if (item.getPurapDocument() == null) {
                item.setPurapDocument(this);
            }
            ItemType it = item.getItemType();
            if (!includeBelowTheLine && !it.isLineItemIndicator() || !includeInactive && !PurApItemUtils.checkItemActive(item)) continue;
            KualiDecimal totalAmount = item.getTotalAmount();
            KualiDecimal itemTotal = totalAmount != null ? totalAmount : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    @Override
    public KualiDecimal getTotalPreTaxDollarAmount() {
        return this.getTotalPreTaxDollarAmount(false, true);
    }

    @Override
    public KualiDecimal getTotalPreTaxDollarAmountAboveLineItems() {
        return this.getTotalPreTaxDollarAmount(false, false);
    }

    public KualiDecimal getTotalPreTaxDollarAmount(boolean includeInactive, boolean includeBelowTheLine) {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurchaseOrderItem item : this.getItems()) {
            ItemType it = item.getItemType();
            if (!includeBelowTheLine && !it.isLineItemIndicator() || !includeInactive && !item.isItemActiveIndicator()) continue;
            KualiDecimal extendedPrice = item.getExtendedPrice();
            KualiDecimal itemTotal = extendedPrice != null ? extendedPrice : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    @Override
    public KualiDecimal getTotalTaxAmount() {
        return this.getTotalTaxAmount(false, true);
    }

    @Override
    public KualiDecimal getTotalTaxAmountAboveLineItems() {
        return this.getTotalTaxAmount(false, false);
    }

    public KualiDecimal getTotalTaxAmount(boolean includeInactive, boolean includeBelowTheLine) {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurchaseOrderItem item : this.getItems()) {
            ItemType it = item.getItemType();
            if (!includeBelowTheLine && !it.isLineItemIndicator() || !includeInactive && !item.isItemActiveIndicator()) continue;
            KualiDecimal taxAmount = item.getItemTaxAmount();
            KualiDecimal itemTotal = taxAmount != null ? taxAmount : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    public boolean getContainsUnpaidPaymentRequestsOrCreditMemos() {
        if (this.getRelatedViews().getRelatedPaymentRequestViews() != null) {
            for (PaymentRequestView paymentRequestView : this.getRelatedViews().getRelatedPaymentRequestViews()) {
                if (PurapConstants.PaymentRequestStatuses.CANCELLED_STATUSES.contains(paymentRequestView.getApplicationDocumentStatus()) || paymentRequestView.getPaymentPaidTimestamp() != null) continue;
                return true;
            }
        }
        if (this.getRelatedViews().getRelatedCreditMemoViews() != null) {
            for (CreditMemoView creditMemoView : this.getRelatedViews().getRelatedCreditMemoViews()) {
                if (PurapConstants.CreditMemoStatuses.CANCELLED_STATUSES.contains(creditMemoView.getApplicationDocumentStatus()) || creditMemoView.getCreditMemoPaidTimestamp() != null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getAdditionalChargesExist() {
        List items = this.getItems();
        for (PurchaseOrderItem item : items) {
            if (item == null || item.getItemType() == null || !item.getItemType().isAdditionalChargeIndicator() || item.getExtendedPrice() == null || KualiDecimal.ZERO.equals((Object)item.getExtendedPrice())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getContractManagerName() {
        return "";
    }

    @Deprecated
    public void setContractManagerName(String contractManagerName) {
    }

    public KualiDecimal getInternalPurchasingLimit() {
        if (this.internalPurchasingLimit == null) {
            this.setInternalPurchasingLimit(((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getInternalPurchasingDollarLimit(this));
        }
        return this.internalPurchasingLimit;
    }

    public void setInternalPurchasingLimit(KualiDecimal internalPurchasingLimit) {
        this.internalPurchasingLimit = internalPurchasingLimit;
    }

    public boolean isPendingSplit() {
        return this.pendingSplit;
    }

    public void setPendingSplit(boolean pendingSplit) {
        this.pendingSplit = pendingSplit;
    }

    public boolean isCopyingNotesWhenSplitting() {
        return this.copyingNotesWhenSplitting;
    }

    public void setCopyingNotesWhenSplitting(boolean copyingNotesWhenSplitting) {
        this.copyingNotesWhenSplitting = copyingNotesWhenSplitting;
    }

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        super.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).customizeGeneralLedgerPendingEntry(this, (AccountingLine)postable, explicitEntry, this.getPurapDocumentIdentifier(), "D", "PO", true);
        KualiDecimal accountTotalGLEntryAmount = "POA".equals(explicitEntry.getFinancialDocumentTypeCode()) || "POC".equals(explicitEntry.getFinancialDocumentTypeCode()) || "POR".equals(explicitEntry.getFinancialDocumentTypeCode()) ? explicitEntry.getTransactionLedgerEntryAmount() : this.getAccountTotalGLEntryAmount((AccountingLine)postable);
        explicitEntry.setTransactionLedgerEntryAmount(accountTotalGLEntryAmount);
        this.handleNegativeEntryAmount(explicitEntry);
        explicitEntry.setFinancialDocumentTypeCode("PO");
    }

    protected void handleNegativeEntryAmount(GeneralLedgerPendingEntry explicitEntry) {
        if (explicitEntry.getTransactionLedgerEntryAmount().doubleValue() < 0.0) {
            explicitEntry.setTransactionDebitCreditCode("C");
            explicitEntry.setTransactionLedgerEntryAmount((KualiDecimal)explicitEntry.getTransactionLedgerEntryAmount().abs());
        } else {
            explicitEntry.setTransactionDebitCreditCode("D");
        }
    }

    @Override
    public Class getPurchasingCapitalAssetItemClass() {
        return PurchaseOrderCapitalAssetItem.class;
    }

    @Override
    public Class getPurchasingCapitalAssetSystemClass() {
        return PurchaseOrderCapitalAssetSystem.class;
    }

    public boolean canClosePOForTradeIn() {
        for (PurchaseOrderItem item : this.getItems()) {
            if (!item.getItemTypeCode().equals("TRDI") || !item.getItemOutstandingEncumberedAmount().isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) continue;
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.tradeIn.outstanding.encumbered.amount.negative", new String[]{"amend the PO"});
            return false;
        }
        return true;
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("RequiresContractManagementReview")) {
            return this.isContractManagementReviewRequired();
        }
        if (nodeName.equals("RequiresAwardReview")) {
            return this.isAwardReviewRequired();
        }
        if (nodeName.equals("RequiresBudgetReview")) {
            return this.isBudgetReviewRequired();
        }
        if (nodeName.equals("VendorIsEmployeeOrNonResidentAlien")) {
            return this.isVendorEmployeeOrNonResidentAlien();
        }
        return super.answerSplitNodeQuestion(nodeName);
    }

    protected boolean isContractManagementReviewRequired() {
        KualiDecimal internalPurchasingLimit = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getInternalPurchasingDollarLimit(this);
        return ObjectUtils.isNull((Object)internalPurchasingLimit) || internalPurchasingLimit.compareTo((AbstractKualiDecimal)this.getTotalDollarAmount()) < 0;
    }

    protected boolean isAwardReviewRequired() {
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        boolean objectCodeAllowed = true;
        for (PurApItem item : this.getItems()) {
            for (PurApAccountingLine accountingLine : item.getSourceAccountingLines()) {
                objectCodeAllowed = this.isObjectCodeAllowedForAwardRouting(accountingLine, parameterService);
                if (!objectCodeAllowed) continue;
                return objectCodeAllowed;
            }
        }
        return objectCodeAllowed;
    }

    protected boolean isObjectCodeAllowedForAwardRouting(PurApAccountingLine accountingLine, ParameterService parameterService) {
        if (ObjectUtils.isNull((Object)accountingLine.getObjectCode())) {
            return false;
        }
        if (!accountingLine.getObjectCode().isFinancialObjectActiveCode()) {
            return false;
        }
        String chartCode = accountingLine.getChartOfAccountsCode();
        boolean objectCodeAllowed = ((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(PurchaseOrderDocument.class, "CG_ROUTE_OBJECT_LEVELS_BY_CHART", "NO_CG_ROUTE_OBJECT_LEVELS_BY_CHART", chartCode, accountingLine.getObjectCode().getFinancialObjectLevelCode()).evaluationSucceeds();
        if (!objectCodeAllowed) {
            objectCodeAllowed = ((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(PurchaseOrderDocument.class, "CG_ROUTE_OBJECT_CODES_BY_CHART", "NO_CG_ROUTE_OBJECT_CODES_BY_CHART", chartCode, accountingLine.getFinancialObjectCode()).evaluationSucceeds();
        }
        return objectCodeAllowed;
    }

    protected boolean isBudgetReviewRequired() {
        if (((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear().compareTo(this.getPostingYear()) >= 0) {
            List fundsItems = ((SufficientFundsService)SpringContext.getBean(SufficientFundsService.class)).checkSufficientFunds(this.getPendingLedgerEntriesForSufficientFundsChecking());
            return fundsItems != null && fundsItems.size() > 0;
        }
        return false;
    }

    protected boolean isVendorEmployeeOrNonResidentAlien() {
        if (ObjectUtils.isNull((Object)this.getVendorHeaderGeneratedIdentifier())) {
            return false;
        }
        String vendorHeaderGeneratedId = this.getVendorHeaderGeneratedIdentifier().toString();
        VendorService vendorService = (VendorService)SpringContext.getBean(VendorService.class);
        boolean routeDocumentAsEmployeeVendor = vendorService.isVendorInstitutionEmployee(Integer.valueOf(vendorHeaderGeneratedId));
        boolean routeDocumentAsForeignVendor = vendorService.isVendorForeign(Integer.valueOf(vendorHeaderGeneratedId));
        return routeDocumentAsEmployeeVendor || routeDocumentAsForeignVendor;
    }

    public List<Account> getAccountsForAwardRouting() {
        ArrayList<Account> accounts = new ArrayList<Account>();
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        for (PurApItem item : this.getItems()) {
            for (PurApAccountingLine accountingLine : item.getSourceAccountingLines()) {
                if (!this.isObjectCodeAllowedForAwardRouting(accountingLine, parameterService)) continue;
                if (ObjectUtils.isNull((Object)accountingLine.getAccount())) {
                    accountingLine.refreshReferenceObject("account");
                }
                if (accountingLine.getAccount() == null || accounts.contains(accountingLine.getAccount())) continue;
                accounts.add(accountingLine.getAccount());
            }
        }
        return accounts;
    }

    public DocumentSearchCriteria convertSelections(DocumentSearchCriteria searchCriteria) {
        return searchCriteria;
    }

    public boolean getPurchaseOrderCurrentIndicatorForSearching() {
        return this.purchaseOrderCurrentIndicator;
    }

    public String getDocumentTitleForResult() throws WorkflowException {
        return KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this.getFinancialSystemDocumentHeader().getWorkflowDocument().getDocumentTypeName()).getLabel();
    }

    public boolean getNeedWarning() {
        return this.getPurchaseOrderInitialOpenTimestamp() == null;
    }

    public List<SourceAccountingLine> getGlOnlySourceAccountingLines() {
        return this.glOnlySourceAccountingLines;
    }

    public void setGlOnlySourceAccountingLines(List<SourceAccountingLine> glOnlySourceAccountingLines) {
        this.glOnlySourceAccountingLines = glOnlySourceAccountingLines;
    }

    public PersistableBusinessObject getNoteTarget() {
        PurchaseOrderDao purchaseOrderDao = (PurchaseOrderDao)SpringContext.getBean(PurchaseOrderDao.class);
        DocumentDao docDao = KRADServiceLocatorInternal.getDocumentDao();
        PurchaseOrderDocument oldest = (PurchaseOrderDocument)docDao.findByDocumentHeaderId(PurchaseOrderDocument.class, purchaseOrderDao.getOldestPurchaseOrderDocumentNumber(this.getPurapDocumentIdentifier()));
        if (oldest != null) {
            return oldest.getDocumentHeader();
        }
        return this.getDocumentHeader();
    }

    @Override
    public NoteType getNoteType() {
        return NoteType.BUSINESS_OBJECT;
    }
}

