/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.datadictionary.TransactionalDocumentEntry;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.authorization.AccountingLineAuthorizerBase;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentAuthorizerBase;
import org.kuali.kfs.sys.document.web.AccountingLineRenderingContext;
import org.kuali.rice.kim.api.identity.Person;

public class PurapAccountingLineAuthorizer
extends AccountingLineAuthorizerBase {
    protected String getAddMethod(AccountingLine accountingLine, String accountingLineProperty) {
        String infix = this.getActionInfixForNewAccountingLine(accountingLine, accountingLineProperty);
        String lineNumber = accountingLineProperty.equals("accountDistributionnewSourceLine") ? "-2" : StringUtils.substringBetween((String)accountingLineProperty, (String)"[", (String)"]");
        return "insert" + infix + "Line.line" + lineNumber + ".anchoraccounting" + infix + "Anchor";
    }

    protected String getDeleteLineMethod(AccountingLine accountingLine, String accountingLineProperty, Integer accountingLineIndex) {
        String infix = this.getActionInfixForExtantAccountingLine(accountingLine, accountingLineProperty);
        String lineNumber = StringUtils.substringBetween((String)accountingLineProperty, (String)"item[", (String)"].sourceAccountingLine");
        if (lineNumber == null) {
            lineNumber = "-2";
        }
        String accountingLineNumber = StringUtils.substringBetween((String)accountingLineProperty, (String)"sourceAccountingLine[", (String)"]");
        return "delete" + infix + "Line.line" + lineNumber + ":" + accountingLineNumber + ".anchoraccounting" + infix + "Anchor";
    }

    protected String getBalanceInquiryMethod(AccountingLine accountingLine, String accountingLineProperty, Integer accountingLineIndex) {
        String infix = this.getActionInfixForNewAccountingLine(accountingLine, accountingLineProperty);
        String lineNumber = StringUtils.substringBetween((String)accountingLineProperty, (String)"item[", (String)"].sourceAccountingLine");
        if (lineNumber == null) {
            lineNumber = "-2";
        }
        String accountingLineNumber = StringUtils.substringBetween((String)accountingLineProperty, (String)"sourceAccountingLine[", (String)"]");
        return "performBalanceInquiryFor" + infix + "Line.line:" + lineNumber + ":" + accountingLineNumber + ".anchoraccounting" + infix + "existingLineLineAnchor" + accountingLineNumber;
    }

    public Set<String> getUnviewableBlocks(AccountingDocument accountingDocument, AccountingLine accountingLine, boolean newLine, Person currentUser) {
        Set unviewableBlocks = super.getUnviewableBlocks(accountingDocument, accountingLine, newLine, currentUser);
        if (this.showAmountOnly(accountingDocument)) {
            unviewableBlocks.add("accountLinePercent");
        } else {
            unviewableBlocks.add("amount");
        }
        return unviewableBlocks;
    }

    private boolean showAmountOnly(AccountingDocument accountingDocument) {
        PurapService purapService = (PurapService)SpringContext.getBean(PurapService.class);
        if (accountingDocument instanceof PurchasingAccountsPayableDocument) {
            return purapService.isFullDocumentEntryCompleted((PurchasingAccountsPayableDocument)accountingDocument);
        }
        return false;
    }

    protected FinancialSystemTransactionalDocumentAuthorizerBase getDocumentAuthorizer(AccountingDocument accountingDocument) {
        FinancialSystemTransactionalDocumentAuthorizerBase documentAuthorizer;
        Class documentAuthorizerClass = ((TransactionalDocumentEntry)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getDictionaryObjectEntry(accountingDocument.getClass().getName())).getDocumentAuthorizerClass();
        try {
            documentAuthorizer = (FinancialSystemTransactionalDocumentAuthorizerBase)documentAuthorizerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ie) {
            throw new RuntimeException("Cannot instantiate instance of document authorizer for " + accountingDocument.getClass().getName(), ie);
        }
        return documentAuthorizer;
    }

    public boolean isGroupEditable(AccountingDocument accountingDocument, List<? extends AccountingLineRenderingContext> accountingLineRenderingContexts, Person currentUser) {
        boolean isEditable = super.isGroupEditable(accountingDocument, accountingLineRenderingContexts, currentUser);
        if (isEditable) {
            if (accountingLineRenderingContexts.size() == 0) {
                return false;
            }
            isEditable = this.allowAccountingLinesAreEditable(accountingDocument, accountingLineRenderingContexts.get(0).getAccountingLine());
        }
        return isEditable;
    }

    public boolean determineEditPermissionOnField(AccountingDocument accountingDocument, AccountingLine accountingLine, String accountingLineCollectionProperty, String fieldName, boolean editablePage) {
        if (accountingLine.getSequenceNumber() == null) {
            return true;
        }
        boolean isEditable = super.determineEditPermissionOnField(accountingDocument, accountingLine, accountingLineCollectionProperty, fieldName, editablePage);
        if (isEditable) {
            isEditable = this.allowAccountingLinesAreEditable(accountingDocument, accountingLine);
        }
        return isEditable;
    }

    public boolean determineEditPermissionOnLine(AccountingDocument accountingDocument, AccountingLine accountingLine, String accountingLineCollectionProperty, boolean currentUserIsDocumentInitiator, boolean pageIsEditable) {
        boolean isEditable = super.determineEditPermissionOnLine(accountingDocument, accountingLine, accountingLineCollectionProperty, currentUserIsDocumentInitiator, pageIsEditable);
        if (isEditable) {
            isEditable = this.allowAccountingLinesAreEditable(accountingDocument, accountingLine);
        }
        return isEditable && pageIsEditable;
    }

    protected boolean allowAccountingLinesAreEditable(AccountingDocument accountingDocument, AccountingLine accountingLine) {
        PurApAccountingLine purapAccount = (PurApAccountingLine)accountingLine;
        Class clazz = this.getPurapDocumentClass(accountingDocument);
        if (clazz == null) {
            return true;
        }
        PurchasingAccountsPayableDocumentBase purapDoc = (PurchasingAccountsPayableDocumentBase)accountingDocument;
        if (!purapDoc.isCalculated()) {
            return true;
        }
        ArrayList restrictedItemTypesList = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(clazz, "ITEM_TYPES_RESTRICTING_ACCOUNT_EDIT"));
        boolean retval = this.isEditableBasedOnTradeInRestriction(accountingDocument, accountingLine);
        if (purapAccount.getPurapItem() == null) {
            return retval;
        }
        return !restrictedItemTypesList.contains(purapAccount.getPurapItem().getItemTypeCode()) && retval;
    }

    protected PurApItem findTheItemForAccountingLine(AccountingDocument accountingDocument, AccountingLine accountingLine) {
        if (accountingDocument instanceof PurchasingAccountsPayableDocumentBase) {
            List listItems = ((PurchasingAccountsPayableDocumentBase)accountingDocument).getItems();
            for (PurApItem oneItem : listItems) {
                List<PurApAccountingLine> acctLines = oneItem.getSourceAccountingLines();
                for (PurApAccountingLine oneAcctLine : acctLines) {
                    if (oneAcctLine != accountingLine) continue;
                    return oneItem;
                }
            }
        }
        return null;
    }

    private boolean isEditableBasedOnTradeInRestriction(AccountingDocument accountingDocument, AccountingLine accountingLine) {
        boolean retval = true;
        if (accountingLine instanceof PurApAccountingLine) {
            String itemTypeCode;
            Object purApItem = ((PurApAccountingLine)accountingLine).getPurapItem();
            if (purApItem == null) {
                purApItem = this.findTheItemForAccountingLine(accountingDocument, accountingLine);
            }
            if (purApItem != null && (itemTypeCode = purApItem.getItemTypeCode()).toUpperCase().equalsIgnoreCase("TRDI") && (accountingLine.getChartOfAccountsCode() != null || accountingLine.getAccountNumber() != null || accountingLine.getFinancialObjectCode() != null)) {
                retval = false;
            }
        }
        return retval;
    }

    protected Class getPurapDocumentClass(AccountingDocument accountingDocument) {
        if (accountingDocument instanceof RequisitionDocument) {
            return RequisitionDocument.class;
        }
        if (accountingDocument instanceof PurchaseOrderDocument) {
            return PurchaseOrderDocument.class;
        }
        if (accountingDocument instanceof PaymentRequestDocument) {
            return PaymentRequestDocument.class;
        }
        return null;
    }

    protected boolean approvedForUnqualifiedEditing(AccountingDocument accountingDocument, AccountingLine accountingLine, String accountingLineCollectionProperty, boolean currentUserIsDocumentInitiator) {
        boolean retval = this.isEditableBasedOnTradeInRestriction(accountingDocument, accountingLine);
        if (retval) {
            retval = super.approvedForUnqualifiedEditing(accountingDocument, accountingLine, accountingLineCollectionProperty, currentUserIsDocumentInitiator);
        }
        return retval;
    }
}

