/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.dataaccess.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.kfs.module.purap.businessobject.ReceivingThreshold;
import org.kuali.kfs.module.purap.document.dataaccess.ThresholdDao;
import org.kuali.kfs.module.purap.util.ThresholdField;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ThresholdDaoOjb
extends PlatformAwareDaoBaseOjb
implements ThresholdDao {
    @Override
    public Collection<ReceivingThreshold> findByChart(String chartCode) {
        HashMap<String, Object> criteriaFields = new HashMap<String, Object>(1);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), chartCode);
        criteriaFields.put(ThresholdField.ACTIVE.getName(), Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndFund(String chartCode, String fund) {
        HashMap<String, Object> criteriaFields = new HashMap<String, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), chartCode);
        criteriaFields.put(ThresholdField.ACCOUNT_TYPE_CODE.getName(), fund);
        criteriaFields.put(ThresholdField.ACTIVE.getName(), Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndSubFund(String chartCode, String subFund) {
        HashMap<String, Object> criteriaFields = new HashMap<String, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), chartCode);
        criteriaFields.put(ThresholdField.SUBFUND_GROUP_CODE.getName(), subFund);
        criteriaFields.put(ThresholdField.ACTIVE.getName(), Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndCommodity(String chartCode, String commodityCode) {
        HashMap<String, Object> criteriaFields = new HashMap<String, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), chartCode);
        criteriaFields.put(ThresholdField.COMMODITY_CODE.getName(), commodityCode);
        criteriaFields.put(ThresholdField.ACTIVE.getName(), Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndObjectCode(String chartCode, String objectCode) {
        HashMap<String, Object> criteriaFields = new HashMap<String, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), chartCode);
        criteriaFields.put(ThresholdField.FINANCIAL_OBJECT_CODE.getName(), objectCode);
        criteriaFields.put(ThresholdField.ACTIVE.getName(), Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndOrg(String chartCode, String org) {
        HashMap<String, Object> criteriaFields = new HashMap<String, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), chartCode);
        criteriaFields.put(ThresholdField.ORGANIZATION_CODE.getName(), org);
        criteriaFields.put(ThresholdField.ACTIVE.getName(), Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndVendor(String chartCode, String vendorHeaderGeneratedIdentifier, String vendorDetailAssignedIdentifier) {
        HashMap<String, Object> criteriaFields = new HashMap<String, Object>(3);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), chartCode);
        criteriaFields.put(ThresholdField.VENDOR_HEADER_GENERATED_ID.getName(), vendorHeaderGeneratedIdentifier);
        criteriaFields.put(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID.getName(), vendorDetailAssignedIdentifier);
        criteriaFields.put(ThresholdField.ACTIVE.getName(), Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    protected Collection<ReceivingThreshold> getThresholdEnum(Map<String, Object> criteriaFields) {
        if (criteriaFields == null || criteriaFields.size() == 0) {
            return null;
        }
        Criteria criteria = new Criteria();
        List<ThresholdField> allFields = ThresholdField.getEnumList();
        for (ThresholdField thresholdField : allFields) {
            if (!thresholdField.isPersistedField()) continue;
            Object criteriaValue = criteriaFields.get(thresholdField.getName());
            if (criteriaValue != null) {
                criteria.addEqualTo(thresholdField.getName(), criteriaValue);
                continue;
            }
            criteria.addIsNull(thresholdField.getName());
        }
        QueryByCriteria query = new QueryByCriteria(ReceivingThreshold.class, criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }
}

